/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.dbutils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.drda.NetworkServerControl;

public class DerbyDatabaseServer {
    private static final Log log = LogFactory.getLog(DerbyDatabaseServer.class);
    private NetworkServerControl networkServerControl = null;
    private boolean isServerStarted = false;

    public void start() throws Exception {
        if (!this.isServerRunning()) {
            this.networkServerControl = new NetworkServerControl();
            this.networkServerControl.start(null);
            this.isServerStarted = true;
            log.info((Object)"Derby Database Server started");
        }
    }

    public void stop() throws Exception {
        if (this.isServerRunning()) {
            this.networkServerControl.shutdown();
            this.isServerStarted = false;
            log.info((Object)"Derby Database Server Shutdown");
        }
    }

    public boolean isServerRunning() {
        return this.isServerStarted;
    }

    public String getJdbcUrl() {
        String jdbc = null;
        if (this.isServerRunning()) {
            try {
                jdbc = "jdbc:derby:" + this.networkServerControl.getCurrentProperties().getProperty("derby.drda.host") + ":" + this.networkServerControl.getCurrentProperties().getProperty("derby.drda.portNumber") + "/";
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return jdbc;
    }
}

