/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.generic.email;

import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.GreenMail;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailUser {
    static final Log log = LogFactory.getLog(MailUser.class);
    GreenMailUser greenMailUser;
    GreenMail greenMail;

    public MailUser(GreenMail greenMail) {
        this.greenMail = greenMail;
    }

    public void registerUser(GreenMailUser greenMailUser) {
        this.greenMailUser = greenMailUser;
    }

    public void sendMessage(MimeMessage mimeMessage) throws RuntimeException {
        try {
            this.greenMailUser.deliver(mimeMessage);
        }
        catch (UserException e) {
            log.error((Object)"Error occurred while delivering user mail via greenmail", (Throwable)e);
            throw new RuntimeException("Error occurred while delivering user mail via greenmail", e);
        }
    }

    public int getMessageCount() throws RuntimeException {
        int mailCount = 0;
        try {
            mailCount = this.greenMail.getManagers().getUserManager().getImapHostManager().getInbox(this.greenMailUser).getMessageCount();
        }
        catch (FolderException e) {
            log.error((Object)"Error occurred while retrieving user mail box via greenmail", (Throwable)e);
            throw new RuntimeException("Error occurred while retrieving user mail box via greenmail", e);
        }
        return mailCount;
    }

    public int getUnReadMessageCount() throws RuntimeException {
        int mailCount = 0;
        try {
            mailCount = this.greenMail.getManagers().getUserManager().getImapHostManager().getInbox(this.greenMailUser).getUnseenCount();
        }
        catch (FolderException e) {
            log.error((Object)"Error occurred while retrieving user mail box via greenmail", (Throwable)e);
            throw new RuntimeException("Error occurred while retrieving user mail box via greenmail", e);
        }
        return mailCount;
    }

    public List<MimeMessage> getUnreadMails() throws RuntimeException {
        ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
        try {
            List storedMessageList = this.greenMail.getManagers().getUserManager().getImapHostManager().getInbox(this.greenMailUser).getMessages();
            for (StoredMessage storedMessage : storedMessageList) {
                if (storedMessage.getFlags().contains(Flags.Flag.SEEN)) continue;
                mimeMessages.add(storedMessage.getMimeMessage());
            }
        }
        catch (FolderException e) {
            log.error((Object)"Error occurred while retrieving user mail box messages greenmail", (Throwable)e);
            throw new RuntimeException("Error occurred while retrieving user mail box messages greenmail", e);
        }
        return mimeMessages;
    }

    public void deleteAllMessages() throws RuntimeException {
        try {
            this.greenMail.getManagers().getUserManager().getImapHostManager().getInbox(this.greenMailUser).deleteAllMessages();
        }
        catch (FolderException e) {
            log.error((Object)"Error occurred while retrieving user mail box messages greenmail", (Throwable)e);
            throw new RuntimeException("Error occurred while retrieving user mail box messages greenmail", e);
        }
    }
}

