/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.http.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class HttpRequestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendGetRequest(String endpoint, String requestParameters) throws IOException {
        HttpURLConnection conn = null;
        try {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            Iterator<String> itr = conn.getHeaderFields().keySet().iterator();
            HashMap<String, String> headers = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                headers.put(key, conn.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(sb.toString(), conn.getResponseCode(), headers);
            return httpResponse;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST?? " + e.getMessage(), (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(URL endpoint, String body) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST?? " + e.getMessage(), (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                writer.write(body);
                ((Writer)writer).close();
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            Iterator<String> itr = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> headers = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                headers.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(sb.toString(), urlConnection.getResponseCode(), headers);
            return httpResponse;
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(URL endpoint, String postBody, Map<String, String> headers) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST?? " + e.getMessage(), (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            for (Map.Entry<String, String> e : headers.entrySet()) {
                urlConnection.setRequestProperty(e.getKey(), e.getValue());
            }
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                writer.write(postBody);
                ((Writer)writer).close();
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            Iterator<String> itr = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                responseHeaders.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(sb.toString(), urlConnection.getResponseCode(), responseHeaders);
            return httpResponse;
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doGet(String endpoint, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = null;
        try {
            HttpResponse httpResponse;
            URL url = new URL(endpoint);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(30000);
            for (Map.Entry<String, String> e : headers.entrySet()) {
                conn.setRequestProperty(e.getKey(), e.getValue());
            }
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                httpResponse = new HttpResponse(sb.toString(), conn.getResponseCode());
                httpResponse.setResponseMessage(conn.getResponseMessage());
            }
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output, String contentType) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST?? " + e.getMessage(), (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void sendPutRequest(Reader data, URL endpoint, Writer output, String contentType) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("PUT");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support PUT?? " + e.getMessage(), (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static int sendDeleteRequest(URL endpoint, String contentType) throws AutomationFrameworkException {
        int responseCode;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("DELETE");
            }
            catch (ProtocolException var33) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support DELETE?? " + var33.getMessage(), (Throwable)var33);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Content-type", contentType);
            responseCode = urlConnection.getResponseCode();
        }
        catch (IOException var36) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + var36.getMessage(), (Throwable)var36);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return responseCode;
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }
}

