/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.http.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class HttpURLConnectionClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendGetRequest(String endpoint, String requestParameters) throws IOException {
        if (endpoint.startsWith("http://")) {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            return new HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendGetRequest(String endpoint, String requestParameters, String contentType) throws IOException {
        if (endpoint.startsWith("http://")) {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-type", contentType);
            conn.setRequestProperty("charset", "UTF-8");
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            return new HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST??", (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpURLConnectionClient.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
                HttpURLConnectionClient.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output, String contentType) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST??", (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpURLConnectionClient.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
                HttpURLConnectionClient.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void sendPutRequest(Reader data, URL endpoint, Writer output, String contentType) throws AutomationFrameworkException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("PUT");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support PUT??", (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpURLConnectionClient.pipe(data, writer);
                ((Writer)writer).close();
            }
            try (InputStream in = urlConnection.getInputStream();){
                InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
                HttpURLConnectionClient.pipe(reader, output);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static String sendPostRequestAndReadResponse(Reader data, URL endpoint, Writer output, String contentType) throws AutomationFrameworkException {
        String resultData;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new AutomationFrameworkException("Shouldn't happen: HttpURLConnection doesn't support POST??", (Throwable)e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            try (OutputStream out = urlConnection.getOutputStream();){
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpURLConnectionClient.pipe(data, writer);
                ((Writer)writer).close();
            }
            InputStream in = urlConnection.getInputStream();
            resultData = HttpURLConnectionClient.getStringFromInputStream(in);
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return resultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendDeleteRequest(URL endpoint, String requestParameters) throws IOException {
        if (endpoint.toString().startsWith("http://")) {
            String urlStr = endpoint.toString();
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "=?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = null;){
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            return new HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

