/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.tcpmon.client;

class SlowLinkSimulator {
    private int delayBytes;
    private int delayTime;
    private int currentBytes;
    private int totalBytes;

    public SlowLinkSimulator(int delayBytes, int delayTime) {
        this.delayBytes = delayBytes;
        this.delayTime = delayTime;
    }

    public SlowLinkSimulator(SlowLinkSimulator that) {
        this.delayBytes = that.delayBytes;
        this.delayTime = that.delayTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public void pump(int bytes) {
        this.totalBytes += bytes;
        if (this.delayBytes == 0) {
            return;
        }
        this.currentBytes += bytes;
        if (this.currentBytes > this.delayBytes) {
            int delaysize = this.currentBytes / this.delayBytes;
            long delay = (long)delaysize * (long)this.delayTime;
            this.currentBytes %= this.delayBytes;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public int getCurrentBytes() {
        return this.currentBytes;
    }

    public void setCurrentBytes(int currentBytes) {
        this.currentBytes = currentBytes;
    }
}

