/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.generic;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.governance.api.common.GovernanceArtifactManager;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactFilter;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifactImpl;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifactImpl;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GenericArtifactManager {
    private String artifactNameAttribute;
    private String artifactNamespaceAttribute;
    private String artifactElementNamespace;
    private GovernanceArtifactManager manager;
    private String mediaType;

    public GenericArtifactManager(Registry registry, String mediaType, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementRoot, String artifactElementNamespace, String pathExpression, Association[] relationshipDefinitions) {
        this.manager = new GovernanceArtifactManager(registry, mediaType, artifactNameAttribute, artifactNamespaceAttribute, artifactElementRoot, artifactElementNamespace, pathExpression, relationshipDefinitions);
        this.artifactNameAttribute = artifactNameAttribute;
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
        this.artifactElementNamespace = artifactElementNamespace;
        this.mediaType = mediaType;
    }

    public GenericArtifactManager(Registry registry, String key) throws RegistryException {
        try {
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration(key, registry);
            if (configuration == null) {
                throw new GovernanceException("Artifact type '" + key + "' is not in registry or unable to find relevant configuration.");
            }
            this.artifactNameAttribute = configuration.getArtifactNameAttribute();
            this.artifactNamespaceAttribute = configuration.getArtifactNamespaceAttribute();
            this.artifactElementNamespace = configuration.getArtifactElementNamespace();
            this.manager = new GovernanceArtifactManager(registry, configuration.getMediaType(), this.artifactNameAttribute, this.artifactNamespaceAttribute, configuration.getArtifactElementRoot(), this.artifactElementNamespace, configuration.getPathExpression(), configuration.getLifecycle(), configuration.getValidationAttributes(), configuration.getRelationshipDefinitions());
            this.mediaType = configuration.getMediaType();
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to obtain governance artifact configuration for rxt: " + key, e);
        }
    }

    public GenericArtifact newGovernanceArtifact(QName qName) throws GovernanceException {
        GenericArtifactImpl genericArtifact = new GenericArtifactImpl(this.manager.newGovernanceArtifact(), this.mediaType){};
        genericArtifact.setQName(qName);
        return genericArtifact;
    }

    public GenericArtifact newGovernanceArtifact(QName qName, byte[] content) throws GovernanceException {
        GenericArtifact genericArtifact = this.newGovernanceArtifact(qName);
        genericArtifact.setContent(content);
        return genericArtifact;
    }

    public GenericArtifact newGovernanceArtifact(OMElement content) throws GovernanceException {
        String namespace;
        GenericArtifactImpl genericArtifact = new GenericArtifactImpl(this.manager.newGovernanceArtifact(content), this.mediaType){};
        String name = GovernanceUtils.getAttributeValue(content, this.artifactNameAttribute, this.artifactElementNamespace);
        String string = namespace = this.artifactNamespaceAttribute != null ? GovernanceUtils.getAttributeValue(content, this.artifactNamespaceAttribute, this.artifactElementNamespace) : null;
        if (name != null && !name.equals("")) {
            genericArtifact.setQName(new QName(namespace, name));
        }
        return genericArtifact;
    }

    public GenericArtifact newGovernanceArtifact(String omContent) throws GovernanceException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(omContent));
            GenericArtifact artifact = this.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            artifact.setContent(omContent.getBytes());
            return artifact;
        }
        catch (XMLStreamException e) {
            throw new GovernanceException("Error in creating generic artifact form content: " + omContent, e);
        }
    }

    public void addGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        this.manager.addGovernanceArtifact(artifact);
    }

    public void updateGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        this.manager.updateGovernanceArtifact(artifact);
    }

    public GenericArtifact getGenericArtifact(String artifactId) throws GovernanceException {
        GovernanceArtifact governanceArtifact = this.manager.getGovernanceArtifact(artifactId);
        if (governanceArtifact == null) {
            return null;
        }
        if (governanceArtifact instanceof GenericArtifactImpl && ((GenericArtifactImpl)governanceArtifact).getMediaType() != null && !this.mediaType.equals(((GenericArtifactImpl)governanceArtifact).getMediaType())) {
            return null;
        }
        return new GenericArtifactImpl(governanceArtifact, this.mediaType){};
    }

    public void removeGenericArtifact(String artifactId) throws GovernanceException {
        this.manager.removeGovernanceArtifact(artifactId);
    }

    public GenericArtifact[] findGenericArtifacts(Map<String, List<String>> criteria) throws GovernanceException {
        return this.getGenericArtifacts(this.manager.findGovernanceArtifacts(criteria));
    }

    public TermData[] getTermData(Map<String, List<String>> criteria, String facetField, boolean authRequired) throws GovernanceException {
        return this.manager.getTermData(criteria, facetField, authRequired);
    }

    public GenericArtifact[] findGovernanceArtifacts(String query) throws GovernanceException {
        return this.getGenericArtifacts(this.manager.findGovernanceArtifacts(query));
    }

    public GenericArtifact[] findGenericArtifacts(GenericArtifactFilter criteria) throws GovernanceException {
        ArrayList<GenericArtifact> artifacts = new ArrayList<GenericArtifact>();
        for (GenericArtifact artifact : this.getAllGenericArtifacts()) {
            if (artifact == null || !criteria.matches(artifact)) continue;
            artifacts.add(artifact);
        }
        return artifacts.toArray(new GenericArtifact[artifacts.size()]);
    }

    public GenericArtifact[] getAllGenericArtifacts() throws GovernanceException {
        return this.getGenericArtifacts(this.manager.getAllGovernanceArtifacts());
    }

    public GenericArtifact[] getAllGenericArtifactsByLifecycle(String lcName) throws GovernanceException {
        return this.getGenericArtifacts(this.manager.getAllGovernanceArtifactsByLifecycle(lcName));
    }

    public GenericArtifact[] getAllGenericArtifactsByLifecycleStatus(String lcName, String lcState) throws GovernanceException {
        return this.getGenericArtifacts(this.manager.getAllGovernanceArtifactsByLIfecycleStatus(lcName, lcState));
    }

    private GenericArtifact[] getGenericArtifacts(GovernanceArtifact[] governanceArtifacts) {
        ArrayList<4> artifacts = new ArrayList<4>(governanceArtifacts.length);
        for (GovernanceArtifact governanceArtifact : governanceArtifacts) {
            if (governanceArtifact == null) continue;
            artifacts.add(new GenericArtifactImpl(governanceArtifact, this.mediaType){});
        }
        return artifacts.toArray(new GenericArtifact[artifacts.size()]);
    }

    public String[] getAllGenericArtifactIds() throws GovernanceException {
        return this.manager.getAllGovernanceArtifactIds();
    }

    public static GenericArtifact newDetachedGovernanceArtifact(QName artifactName, String mediaType) {
        return new DetachedGenericArtifactImpl(artifactName, mediaType);
    }

    public boolean isExists(GovernanceArtifact artifact) throws GovernanceException {
        return this.manager.isExists(artifact);
    }

    public void removeGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        this.manager.removeGenericArtifact(artifact);
    }

    public void setContent(Resource resource, GovernanceArtifact artifact) throws GovernanceException {
        this.manager.setContent(resource, artifact);
    }
}

