/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.services.dataobjects;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.endpoints.dataobjects.EndpointImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.policies.dataobjects.PolicyImpl;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.schema.dataobjects.SchemaImpl;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.governance.api.wsdls.dataobjects.WsdlImpl;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ServiceImpl
extends GovernanceArtifactImpl
implements Service {
    private static final Log log = LogFactory.getLog(ServiceImpl.class);
    private static final String ACTIVATE_PROPERTY_FLAG_NAME = "active";
    private QName qName;

    protected ServiceImpl(GovernanceArtifact service) {
        super((GovernanceArtifactImpl)service);
        this.qName = service.getQName();
        this.setLcName(((GovernanceArtifactImpl)service).getLcName());
        this.setLcState(((GovernanceArtifactImpl)service).getLcState());
        this.setArtifactPath(((GovernanceArtifactImpl)service).getArtifactPath());
    }

    public ServiceImpl(String id, QName qName) {
        super(id);
        this.qName = qName;
    }

    public ServiceImpl(String id, OMElement serviceContentElement) throws GovernanceException {
        super(id, serviceContentElement);
        String serviceName = CommonUtil.getServiceName((OMElement)serviceContentElement);
        String serviceNamespace = CommonUtil.getServiceNamespace((OMElement)serviceContentElement);
        if (serviceName != null && !serviceName.equals("")) {
            this.qName = new QName(serviceNamespace, serviceName);
        }
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public void setQName(QName qName) throws GovernanceException {
        this.qName = qName;
    }

    @Override
    public void activate() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            Registry registry = this.getAssociatedRegistry();
            String path = this.getPath();
            Resource r = registry.get(path);
            r.setProperty(ACTIVATE_PROPERTY_FLAG_NAME, Boolean.toString(true));
            registry.put(path, r);
        }
        catch (RegistryException e) {
            String msg = "Error in activating the service: id:" + this.getId() + ", path: " + this.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void deactivate() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            Registry registry = this.getAssociatedRegistry();
            String path = this.getPath();
            Resource r = registry.get(path);
            r.setProperty(ACTIVATE_PROPERTY_FLAG_NAME, Boolean.toString(false));
            registry.put(path, r);
        }
        catch (RegistryException e) {
            String msg = "Error in activating the service: id:" + this.getId() + ", path: " + this.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Deprecated
    public void setActive(boolean isActive) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            Registry registry = this.getAssociatedRegistry();
            String path = this.getPath();
            Resource r = registry.get(path);
            r.setProperty(ACTIVATE_PROPERTY_FLAG_NAME, Boolean.toString(isActive));
            registry.put(path, r);
        }
        catch (RegistryException e) {
            String msg = "Error in activating the service: id:" + this.getId() + ", path: " + this.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public boolean isActive() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            Registry registry = this.getAssociatedRegistry();
            String path = this.getPath();
            Resource r = registry.get(path);
            return !Boolean.toString(false).equals(r.getProperty(ACTIVATE_PROPERTY_FLAG_NAME));
        }
        catch (RegistryException e) {
            String msg = "Error in checking the activeness of the service: id:" + this.getId() + ", path: " + this.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void attachPolicy(Policy policy) throws GovernanceException {
        this.attach(policy);
    }

    @Override
    public void detachPolicy(String policyId) throws GovernanceException {
        this.detach(policyId);
    }

    @Override
    public Policy[] getAttachedPolicies() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Policy> policies = new ArrayList<Policy>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof PolicyImpl)) continue;
                policies.add((Policy)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached policies from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return policies.toArray(new Policy[policies.size()]);
    }

    @Override
    public void attachSchema(Schema schema) throws GovernanceException {
        this.attach(schema);
    }

    @Override
    public void detachSchema(String schemaId) throws GovernanceException {
        this.detach(schemaId);
    }

    @Override
    public Schema[] getAttachedSchemas() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof SchemaImpl)) continue;
                schemas.add((Schema)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached schemas from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }

    @Override
    public void attachWSDL(Wsdl wsdl) throws GovernanceException {
        this.attach(wsdl);
        this.addAttribute("interface_wsdlURL", RegistryUtils.getAbsolutePathToOriginal((String)wsdl.getPath(), (String)"/_system/governance"));
    }

    @Override
    public void detachWSDL(String wsdlId) throws GovernanceException {
        this.detach(wsdlId);
    }

    @Override
    public Wsdl[] getAttachedWsdls() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Wsdl> wsdls = new ArrayList<Wsdl>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof WsdlImpl)) continue;
                wsdls.add((Wsdl)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached wsdls from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return wsdls.toArray(new Wsdl[wsdls.size()]);
    }

    @Override
    public void attachEndpoint(Endpoint endpoint) throws GovernanceException {
        this.attach(endpoint);
    }

    @Override
    public void detachEndpoint(String endpointId) throws GovernanceException {
        this.detach(endpointId);
    }

    @Override
    public Endpoint[] getAttachedEndpoints() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof EndpointImpl)) continue;
                endpoints.add((Endpoint)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached endpoints from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return endpoints.toArray(new Endpoint[endpoints.size()]);
    }
}

