/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.common.dataobjects;

import org.apache.commons.lang.StringEscapeUtils;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.UIComponent;

public class DateField
extends UIComponent {
    private String value;
    private boolean isSkipName;

    public DateField(String label, String name, String id, String mandatory, String widget, String value, boolean isReadOnly, String tooltip, boolean isSkipName, boolean isJSGenerating) {
        super(label, name, id, mandatory, widget, isReadOnly, tooltip, isJSGenerating);
        this.value = value;
        this.isSkipName = isSkipName;
    }

    @Override
    public String generate() {
        StringBuilder element = new StringBuilder();
        String dateFieldName = this.widget.replaceAll(" ", "") + "_" + this.name.replaceAll(" ", "");
        String id = this.id == null ? "id_" + dateFieldName : this.id;
        if (this.value != null) {
            this.value = StringEscapeUtils.escapeHtml((String)this.value);
        }
        if (this.isSkipName) {
            element.append("</tr>");
        }
        if (this.label != null) {
            element.append("<td class=\"leftCol-big\">").append(this.label != null ? this.label : "");
        }
        if ("true".equals(this.mandatory)) {
            element.append("<span class=\"required\">*</span>");
        }
        if (this.label != null) {
            element.append("</td>");
        }
        element.append("<td>");
        if (!this.isReadOnly) {
            element.append("<a class=\"icon-link\" style=\"background-image: ").append("url( ../admin/images/calendar.gif);\" ").append((this.isJSGenerating ? "onclick=\"jQuery(\\'#" + id + "\\').datepicker(\\'show\\');\"" : "onclick=\"jQuery('#" + id + "').datepicker('show');\"") + " href=\"javascript:void(0)\"></a>");
        }
        element.append("<input type=\"text\" name=\"").append(dateFieldName).append("\" title=\"").append(this.tooltip).append("\" style=\"width:").append("100").append("px\"").append(this.isReadOnly ? " readonly" : "").append(" id=\"").append(id).append("\" value=\"").append(this.value != null ? this.value : "").append("\" />");
        element.append("</td>");
        if (this.isSkipName) {
            element.append("</tr>");
        }
        return element.toString();
    }
}

