/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.internal;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.governance.generic.ui.utils.GenericUtil;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.UIAuthenticationExtender;

@Component(name="org.wso2.carbon.governance.generic.ui", immediate=true)
public class GovernanceGenericUIServiceComponent {
    private static Log log = LogFactory.getLog(GovernanceGenericUIServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    @Activate
    protected void activate(ComponentContext context) {
        UIAuthenticationExtender authenticationExtender = new UIAuthenticationExtender(){

            public void onSuccessAdminLogin(HttpServletRequest request, String s, String s1, String s2) {
                GenericUtil.buildMenuItems(request, s, s1, s2);
            }
        };
        this.serviceRegistration = context.getBundleContext().registerService(UIAuthenticationExtender.class.getName(), (Object)authenticationExtender, null);
        log.debug((Object)"******* Governance List UI bundle is activated ******* ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        log.debug((Object)"Governance Generic UI bundle is deactivated ");
    }

    @Reference(name="ui.authenticator", service=CarbonUIAuthenticator.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonUIAuthenticator")
    protected void setCarbonUIAuthenticator(CarbonUIAuthenticator uiAuthenticator) {
    }

    protected void unsetCarbonUIAuthenticator(CarbonUIAuthenticator uiAuthenticator) {
    }
}

