/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.generic.ui.clients.ManageGenericArtifactServiceClient;
import org.wso2.carbon.governance.generic.ui.utils.GenericUIGenerator;
import org.wso2.carbon.governance.generic.ui.utils.InstalledRxt;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.search.stub.SearchAdminServiceStub;
import org.wso2.carbon.registry.search.stub.beans.xsd.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.stub.beans.xsd.ArrayOfString;
import org.wso2.carbon.registry.search.stub.beans.xsd.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.stub.common.xsd.ResourceData;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ManageGenericArtifactUtil {
    private static final Log log = LogFactory.getLog(ManageGenericArtifactUtil.class);

    public static String addArtifactContent(OMElement info, HttpServletRequest request, ServletConfig config, HttpSession session, String dataName, String dataNamespace, String currentPath) throws UIException {
        try {
            ManageGenericArtifactServiceClient serviceClient = new ManageGenericArtifactServiceClient(config, session);
            OMElement filledService = new GenericUIGenerator(dataName, dataNamespace).getDataFromUI(info, request);
            String operation = request.getParameter("add_edit_operation");
            if (operation != null) {
                if (operation.equals("add")) {
                    return serviceClient.addArtifact(request.getParameter("key"), filledService.toString(), request.getParameter("lifecycleAttribute"));
                }
                if (operation.equals("edit")) {
                    return serviceClient.editArtifact(currentPath, request.getParameter("key"), filledService.toString(), request.getParameter("lifecycleAttribute"));
                }
            }
            return null;
        }
        catch (Exception e) {
            String msg = "Failed to add/edit artifact details. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException((Throwable)e);
        }
    }

    public static List<InstalledRxt> getInstalledRxts(String cookie, ServletConfig config, HttpSession session) throws Exception {
        SearchAdminServiceStub stub;
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "SearchAdminService";
        try {
            stub = new SearchAdminServiceStub(configContext, epr);
            ServiceClient client = stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate search service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new Exception(msg, axisFault);
        }
        CustomSearchParameterBean searchQuery = new CustomSearchParameterBean();
        ArrayOfString arr = new ArrayOfString();
        arr.setArray(new String[]{"mediaType", "application/vnd.wso2.registry-ext-type+xml"});
        ArrayOfString[] paramList = new ArrayOfString[]{arr};
        searchQuery.setParameterValues(paramList);
        AdvancedSearchResultsBean result = stub.getAdvancedSearchResults(searchQuery);
        ResourceData[] results = result.getResourceDataList();
        ArrayList<InstalledRxt> listInstalledRxts = new ArrayList<InstalledRxt>();
        if (results != null && results.length > 0) {
            for (ResourceData data : results) {
                String path = data.getResourcePath();
                if (path == null || !path.contains("/")) continue;
                String rxt = path.substring(path.lastIndexOf("/") + 1).split("\\.")[0];
                InstalledRxt rxtObj = new InstalledRxt();
                rxtObj.setRxt(rxt);
                if (data.getDeleteAllowed()) {
                    rxtObj.setDeleteAllowed();
                }
                listInstalledRxts.add(rxtObj);
            }
        }
        return listInstalledRxts;
    }
}

