/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.MediaTypeMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

@Component(name="org.wso2.carbon.governance.list", immediate=true)
public class GovernanceMgtUIListMetadataServiceComponent {
    private static Log log = LogFactory.getLog(GovernanceMgtUIListMetadataServiceComponent.class);
    private ServiceRegistration serviceRegistration;
    private static Map<Integer, List<String>> tenantList = new HashMap<Integer, List<String>>();

    @Activate
    protected void activate(ComponentContext context) {
        final RegistryService registryService = org.wso2.carbon.governance.list.util.CommonUtil.getRegistryService();
        try {
            UserRegistry registry = registryService.getGovernanceUserRegistry("wso2.system.user");
            org.wso2.carbon.governance.list.util.CommonUtil.configureGovernanceArtifacts((Registry)registry, org.wso2.carbon.governance.list.util.CommonUtil.getConfigurationContext().getAxisConfiguration());
            HandlerManager handlerManager = registry.getRegistryContext().getHandlerManager();
            if (handlerManager != null) {
                handlerManager.addHandler(null, (Filter)new MediaTypeMatcher("application/vnd.wso2.registry-ext-type+xml"), new Handler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void put(RequestContext requestContext) throws RegistryException {
                        if (!CommonUtil.isUpdateLockAvailable()) {
                            return;
                        }
                        CommonUtil.acquireUpdateLock();
                        try {
                            String rxtContent;
                            Object rxtObj = requestContext.getResource().getContent();
                            if (rxtObj instanceof byte[]) {
                                rxtContent = RegistryUtils.decodeBytes((byte[])((byte[])requestContext.getResource().getContent()));
                            } else if (rxtObj instanceof String) {
                                rxtContent = rxtObj.toString();
                            } else {
                                throw new RegistryException("Invalid RXT");
                            }
                            if (!org.wso2.carbon.governance.list.util.CommonUtil.validateXMLConfigOnSchema(rxtContent, "rxt-ui-config")) {
                                throw new RegistryException("Violation of RXT definition in configuration file, follow the schema correctly..!!");
                            }
                            this.populateRXTPaths(rxtContent);
                            Registry userRegistry = requestContext.getRegistry();
                            userRegistry.put(requestContext.getResourcePath().getPath(), requestContext.getResource());
                            Registry systemRegistry = requestContext.getSystemRegistry();
                            org.wso2.carbon.governance.list.util.CommonUtil.configureGovernanceArtifacts(systemRegistry, org.wso2.carbon.governance.list.util.CommonUtil.getConfigurationContext().getAxisConfiguration());
                            requestContext.setProcessingComplete(true);
                        }
                        finally {
                            CommonUtil.releaseUpdateLock();
                        }
                    }

                    public Resource get(RequestContext requestContext) throws RegistryException {
                        Resource resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
                        requestContext.setProcessingComplete(true);
                        Object content = resource.getContent();
                        String path = resource.getPath();
                        String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
                        if (tenantList.get(tenantId) != null && !((List)tenantList.get(tenantId)).contains(path)) {
                            List rxtPaths = (List)tenantList.get(tenantId);
                            rxtPaths.add(path);
                            this.populateRXTPaths(elementString);
                            tenantList.put(tenantId, rxtPaths);
                        } else if (tenantList.get(tenantId) == null) {
                            ArrayList<String> rxtPaths = new ArrayList<String>();
                            rxtPaths.add(path);
                            this.populateRXTPaths(elementString);
                            tenantList.put(tenantId, rxtPaths);
                        }
                        return resource;
                    }

                    private void populateRXTPaths(String elementString) {
                        GovernanceArtifactConfiguration artifactConfiguration = GovernanceUtils.getGovernanceArtifactConfiguration((String)elementString);
                        org.wso2.carbon.governance.list.util.CommonUtil.addStoragePath(artifactConfiguration.getMediaType(), artifactConfiguration.getPathExpression());
                    }

                    public void delete(RequestContext requestContext) throws RegistryException {
                        Resource resource = requestContext.getResource();
                        Object content = resource.getContent();
                        String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                        GovernanceArtifactConfiguration artifactConfiguration = GovernanceUtils.getGovernanceArtifactConfiguration((String)elementString);
                        org.wso2.carbon.governance.list.util.CommonUtil.removeStoragePath(artifactConfiguration.getMediaType());
                        String needToDelete = artifactConfiguration.getKey();
                        UserRegistry systemRegistry = registryService.getRegistry("wso2.system.user");
                        if (systemRegistry.resourceExists("/_system/config/repository/components/org.wso2.carbon.governance/configuration/" + needToDelete)) {
                            systemRegistry.delete("/_system/config/repository/components/org.wso2.carbon.governance/configuration/" + needToDelete);
                        }
                        List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)systemRegistry);
                        GovernanceUtils.loadGovernanceArtifacts((UserRegistry)systemRegistry, (List)configurations);
                        for (GovernanceArtifactConfiguration configuration : configurations) {
                            for (ManagementPermission uiPermission : configuration.getUIPermissions()) {
                                String resourceId = "/_system/governance" + uiPermission.getResourceId();
                                if (!systemRegistry.resourceExists(resourceId) || !needToDelete.equals(configuration.getKey())) continue;
                                systemRegistry.delete(resourceId);
                            }
                        }
                        GovernanceMgtUIListMetadataServiceComponent.this.unDeployCRUDService(artifactConfiguration, org.wso2.carbon.governance.list.util.CommonUtil.getConfigurationContext().getAxisConfiguration());
                    }
                });
                handlerManager.addHandler(null, (Filter)new MediaTypeMatcher(){

                    public boolean handlePut(RequestContext requestContext) throws RegistryException {
                        Resource resource = requestContext.getResource();
                        if (resource == null) {
                            return false;
                        }
                        String mType = resource.getMediaType();
                        return mType != null && this.invert != (mType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml") & !mType.matches("application/vnd.wso2-service\\+xml"));
                    }

                    public boolean handleCreateLink(RequestContext requestContext) throws RegistryException {
                        String targetPath = requestContext.getTargetPath();
                        if (!requestContext.getRegistry().resourceExists(targetPath)) {
                            return false;
                        }
                        Resource targetResource = requestContext.getRegistry().get(targetPath);
                        String mType = targetResource.getMediaType();
                        return mType != null && this.invert != (mType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml") & !mType.matches("application/vnd.wso2-service\\+xml"));
                    }
                }, new Handler(){

                    public void createLink(RequestContext requestContext) throws RegistryException {
                        String symlinkPath = requestContext.getResourcePath().getPath();
                        if (!symlinkPath.startsWith("/_system/governance")) {
                            throw new RegistryException("symlink creation is not allowed for artifact " + requestContext.getTargetPath());
                        }
                    }
                });
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to load governance artifacts.", (Throwable)e);
        }
        log.debug((Object)"******* Governance List Metadata bundle is activated ******* ");
    }

    private void unDeployCRUDService(GovernanceArtifactConfiguration configuration, AxisConfiguration axisConfig) {
        String singularLabel = configuration.getSingularLabel();
        try {
            if (axisConfig.getService(singularLabel) != null) {
                axisConfig.removeService(singularLabel);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault);
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        org.wso2.carbon.governance.list.util.CommonUtil.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        org.wso2.carbon.governance.list.util.CommonUtil.setRegistryService(null);
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"The Configuration Context Service was set");
        if (configurationContextService != null) {
            org.wso2.carbon.governance.list.util.CommonUtil.setConfigurationContext(configurationContextService.getServerConfigContext());
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        org.wso2.carbon.governance.list.util.CommonUtil.setConfigurationContext(null);
    }

    @Reference(name="extensions.service", service=RXTStoragePathService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRxtStoragePathService")
    protected void setRxtStoragePathService(RXTStoragePathService rxtStoragePathService) {
        org.wso2.carbon.governance.list.util.CommonUtil.setRxtStoragePathService(rxtStoragePathService);
    }

    protected void unsetRxtStoragePathService(RXTStoragePathService rxtStoragePathService) {
        org.wso2.carbon.governance.list.util.CommonUtil.setRxtStoragePathService(null);
    }
}

