/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.governance.list.operations.CreateOperation;
import org.wso2.carbon.governance.list.operations.DeleteOperation;
import org.wso2.carbon.governance.list.operations.GetAllArtifactIDsOperation;
import org.wso2.carbon.governance.list.operations.GetDependenciesOperation;
import org.wso2.carbon.governance.list.operations.RXTMessageReceiver;
import org.wso2.carbon.governance.list.operations.ReadOperation;
import org.wso2.carbon.governance.list.operations.UpdateOperation;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathServiceImpl;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static RegistryService registryService;
    private static ConfigurationContext configurationContext;
    private static RXTStoragePathService rxtStoragePathService;

    public static void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    public static void setConfigurationContext(ConfigurationContext configurationContext) {
        CommonUtil.configurationContext = configurationContext;
    }

    public static RXTStoragePathService getRxtStoragePathService() {
        return rxtStoragePathService;
    }

    public static void setRxtStoragePathService(RXTStoragePathService rxtStoragePathService) {
        CommonUtil.rxtStoragePathService = rxtStoragePathService;
    }

    public static String getServiceName(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceInfoElement = builder.getDocumentElement();
            return CommonUtil.getNameFromContent(serviceInfoElement);
        }
        catch (Exception e) {
            String msg = "Error in getting the service name. service path: " + resource.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static String getServiceNamespace(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceInfoElement = builder.getDocumentElement();
            return CommonUtil.getNamespaceFromContent(serviceInfoElement);
        }
        catch (Exception e) {
            String msg = "Error in getting the service namespace. service path: " + resource.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static String getLifeCycleName(Resource resource) {
        String lifeCycleName = "";
        if (resource.getProperties() != null && resource.getProperty("registry.LC.name") != null) {
            lifeCycleName = resource.getProperty("registry.LC.name");
        }
        return lifeCycleName;
    }

    public static String getLifeCycleState(Resource resource) {
        String LCStatePropertyName;
        String lifeCycleState = "";
        if (resource.getProperties() != null && !CommonUtil.getLifeCycleName(resource).equals("") && resource.getProperty(LCStatePropertyName = "registry.lifecycle." + CommonUtil.getLifeCycleName(resource) + ".state") != null) {
            lifeCycleState = resource.getProperty(LCStatePropertyName);
        }
        return lifeCycleState;
    }

    public static String getResourceName(String path) {
        String[] temp = path.split("/");
        return temp[temp.length - 1];
    }

    public static String getNamespaceFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        return head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview")).getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
    }

    public static String getNameFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        return head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview")).getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
    }

    public static OMElement buildServiceOMElement(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)"Unable to build service OMElement", (Throwable)e);
            return null;
        }
    }

    private static String convertContentToString(Resource resource) throws RegistryException {
        if (resource.getContent() instanceof String) {
            return RegistryUtils.decodeBytes((byte[])((String)resource.getContent()).getBytes());
        }
        if (resource.getContent() instanceof byte[]) {
            return RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
        }
        return RegistryUtils.decodeBytes((byte[])"".getBytes());
    }

    public static String getVersionFromContent(OMElement content) {
        try {
            AXIOMXPath xPath = new AXIOMXPath("//pre:version");
            SimpleNamespaceContext context = new SimpleNamespaceContext();
            context.addNamespace("pre", content.getNamespace().getNamespaceURI());
            xPath.setNamespaceContext((NamespaceContext)context);
            List versionElements = xPath.selectNodes((Object)content);
            if (versionElements != null) {
                for (Object versionElement : versionElements) {
                    OMElement version = (OMElement)versionElement;
                    if (!((OMElement)version.getParent()).getLocalName().equals("overview")) continue;
                    return version.getText();
                }
            }
        }
        catch (JaxenException e) {
            log.error((Object)"Unable to get the version of the service", (Throwable)e);
        }
        return "";
    }

    public static boolean validateXMLConfigOnSchema(String xml, String schema) throws RegistryException {
        String serviceConfPath = "";
        if ("rxt-ui-config".equalsIgnoreCase(schema)) {
            serviceConfPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxt.xsd";
        } else if ("lifecycle-config".equalsIgnoreCase(schema)) {
            serviceConfPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "lifecycle-config.xsd";
        }
        return CommonUtil.validateRXTContent(xml, serviceConfPath);
    }

    private static boolean validateRXTContent(String rxtContent, String xsdPath) throws RegistryException {
        try {
            OMElement rxt = CommonUtil.getRXTContentOMElement(rxtContent);
            AXIOMXPath xpath = new AXIOMXPath("//artifactType");
            OMElement c1 = (OMElement)xpath.selectSingleNode((Object)rxt);
            ByteArrayInputStream is = new ByteArrayInputStream(c1.toString().getBytes());
            StreamSource xmlFile = new StreamSource(is);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File(xsdPath));
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (Exception e) {
            log.error((Object)("RXT validation fails due to: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static OMElement getRXTContentOMElement(String xml) throws RegistryException {
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(xml.getBytes("utf-8")));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public static void configureGovernanceArtifacts(Registry systemRegistry, AxisConfiguration axisConfig) throws RegistryException {
        List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)systemRegistry);
        GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)systemRegistry), (List)configurations);
        Registry governanceSystemRegistry = GovernanceUtils.getGovernanceSystemRegistry((Registry)systemRegistry);
        for (GovernanceArtifactConfiguration configuration : configurations) {
            for (ManagementPermission uiPermission : configuration.getUIPermissions()) {
                String resourceId = uiPermission.getResourceId();
                if (systemRegistry.resourceExists(resourceId)) continue;
                Collection collection = systemRegistry.newCollection();
                collection.setProperty("name", uiPermission.getDisplayName());
                systemRegistry.put(resourceId, (Resource)collection);
            }
            RXTMessageReceiver receiver = new RXTMessageReceiver();
            if (axisConfig == null) continue;
            try {
                String singularLabel = configuration.getSingularLabel().replaceAll("\\s", "");
                String key = configuration.getKey();
                String mediaType = configuration.getMediaType();
                if (axisConfig.getService(singularLabel) != null) continue;
                AxisService service = new AxisService(singularLabel);
                Parameter param1 = new Parameter("AuthorizationAction", (Object)"/permission/admin/login");
                param1.setLocked(true);
                service.addParameter(param1);
                Parameter param2 = new Parameter("adminService", (Object)"true");
                param2.setLocked(true);
                service.addParameter(param2);
                Parameter param3 = new Parameter("hiddenService", (Object)"true");
                param3.setLocked(true);
                service.addParameter(param3);
                Parameter param4 = new Parameter("enableMTOM", (Object)"true");
                param4.setLocked(true);
                service.addParameter(param4);
                XmlSchemaCollection schemaCol = new XmlSchemaCollection();
                ArrayList<XmlSchema> schemaList = new ArrayList<XmlSchema>();
                AbstractOperation create = new CreateOperation(new QName("add" + singularLabel), governanceSystemRegistry, mediaType, "http://services.add." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionCreate = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/add"));
                authorizationActionCreate.setLocked(true);
                create.addParameter(authorizationActionCreate);
                service.addOperation((AxisOperation)create);
                schemaList.addAll(Arrays.asList(create.getSchemas(schemaCol)));
                AbstractOperation read = new ReadOperation(new QName("get" + singularLabel), governanceSystemRegistry, mediaType, "http://services.get." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionRead = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/list"));
                authorizationActionRead.setLocked(true);
                read.addParameter(authorizationActionRead);
                service.addOperation((AxisOperation)read);
                schemaList.addAll(Arrays.asList(read.getSchemas(schemaCol)));
                AbstractOperation update = new UpdateOperation(new QName("update" + singularLabel), governanceSystemRegistry, mediaType, "http://services.update." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionUpdate = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/add"));
                authorizationActionUpdate.setLocked(true);
                update.addParameter(authorizationActionUpdate);
                service.addOperation((AxisOperation)update);
                schemaList.addAll(Arrays.asList(update.getSchemas(schemaCol)));
                AbstractOperation delete = new DeleteOperation(new QName("delete" + singularLabel), governanceSystemRegistry, mediaType, "http://services.delete." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionDelete = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/add"));
                authorizationActionDelete.setLocked(true);
                delete.addParameter(authorizationActionDelete);
                service.addOperation((AxisOperation)delete);
                schemaList.addAll(Arrays.asList(delete.getSchemas(schemaCol)));
                AbstractOperation getAllArtifactIds = new GetAllArtifactIDsOperation(new QName("get" + singularLabel + "ArtifactIDs"), governanceSystemRegistry, mediaType, "http://services.get." + key + "." + "ArtifactIDs".toLowerCase() + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionGetArtifactIDs = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/list"));
                authorizationActionGetArtifactIDs.setLocked(true);
                getAllArtifactIds.addParameter(authorizationActionGetArtifactIDs);
                service.addOperation((AxisOperation)getAllArtifactIds);
                schemaList.addAll(Arrays.asList(getAllArtifactIds.getSchemas(schemaCol)));
                AbstractOperation getDependencies = new GetDependenciesOperation(new QName("get" + singularLabel + "Dependencies"), governanceSystemRegistry, mediaType, "http://services.get." + key + "." + "Dependencies".toLowerCase() + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionGetDependencies = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + key + "/list"));
                authorizationActionGetDependencies.setLocked(true);
                getDependencies.addParameter(authorizationActionGetDependencies);
                service.addOperation((AxisOperation)getDependencies);
                schemaList.addAll(Arrays.asList(getDependencies.getSchemas(schemaCol)));
                ArrayList<String> transports = new ArrayList<String>();
                transports.add("https");
                service.setExposedTransports(transports);
                axisConfig.addService(service);
                XmlSchema schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://api.registry.carbon.wso2.org/xsd\">\n            <xs:complexType name=\"RegistryException\">\n                <xs:sequence />\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ax2233=\"http://exceptions.core.registry.carbon.wso2.org/xsd\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://exception.api.governance.carbon.wso2.org/xsd\">\n            <xs:import namespace=\"http://exceptions.core.registry.carbon.wso2.org/xsd\" />\n            <xs:complexType name=\"GovernanceException\">\n                <xs:complexContent>\n                    <xs:extension base=\"ax2233:RegistryException\">\n                        <xs:sequence />\n                    </xs:extension>\n                </xs:complexContent>\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ax2232=\"http://api.registry.carbon.wso2.org/xsd\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://exceptions.core.registry.carbon.wso2.org/xsd\">\n            <xs:import namespace=\"http://api.registry.carbon.wso2.org/xsd\" />\n            <xs:complexType name=\"RegistryException\">\n                <xs:complexContent>\n                    <xs:extension base=\"ax2232:RegistryException\">\n                        <xs:sequence />\n                    </xs:extension>\n                </xs:complexContent>\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                service.addSchema(schemaList);
            }
            catch (AxisFault axisFault) {
                String msg = "Error occured while adding services";
                log.error((Object)msg, (Throwable)axisFault);
            }
        }
    }

    public static void addStoragePath(String mediaType, String storagePath) {
        RXTStoragePathServiceImpl service = (RXTStoragePathServiceImpl)CommonUtil.getRxtStoragePathService();
        service.addStoragePath(mediaType, storagePath);
    }

    public static void removeStoragePath(String mediaType) {
        RXTStoragePathServiceImpl service = (RXTStoragePathServiceImpl)CommonUtil.getRxtStoragePathService();
        service.removeStoragePath(mediaType);
    }
}

