/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.services.dataobjects.ServiceImpl;
import org.wso2.carbon.governance.list.beans.ServiceBean;
import org.wso2.carbon.governance.list.util.StringComparatorUtil;
import org.wso2.carbon.governance.list.util.filter.FilterGenericArtifact;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserStoreException;

public class ListServiceUtil {
    private static final Log log = LogFactory.getLog(ListServiceUtil.class);

    public static ServiceBean fillServiceBean(UserRegistry registry, String criteria) throws RegistryException {
        ServiceBean bean = new ServiceBean();
        GovernanceArtifact[] artifacts = new GovernanceArtifact[]{};
        String defaultServicePath = RegistryUtils.getRelativePathToOriginal((String)registry.getRegistryContext().getServicePath(), (String)"/_system/governance");
        try {
            artifacts = new FilterGenericArtifact(criteria, (Registry)registry, "service").getArtifacts();
        }
        catch (RegistryException e) {
            log.error((Object)"An error occurred while obtaining the list of services.", (Throwable)e);
        }
        String[] path = new String[artifacts.length];
        String[] name = new String[artifacts.length];
        String[] namespace = new String[artifacts.length];
        String[] LCName = new String[artifacts.length];
        String[] LCState = new String[artifacts.length];
        String[] version = new String[artifacts.length];
        boolean[] canDelete = new boolean[artifacts.length];
        for (int i = 0; i < artifacts.length; ++i) {
            bean.increment();
            if (registry.getUserRealm() != null && registry.getUserName() != null) {
                try {
                    canDelete[i] = registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), "/_system/governance" + path[i], "http://www.wso2.org/projects/registry/actions/delete");
                }
                catch (UserStoreException e) {
                    canDelete[i] = false;
                }
            } else {
                canDelete[i] = false;
            }
            path[i] = ((ServiceImpl)artifacts[i]).getArtifactPath();
            version[i] = artifacts[i].getAttribute("overview_version");
            name[i] = artifacts[i].getAttribute("overview_name");
            namespace[i] = artifacts[i].getAttribute("overview_namespace");
            LCName[i] = ((ServiceImpl)artifacts[i]).getLcName();
            LCState[i] = ((ServiceImpl)artifacts[i]).getLcState();
        }
        bean.setDefaultServicePath(defaultServicePath);
        bean.setNames(name);
        bean.setNamespace(namespace);
        bean.setPath(path);
        bean.setLCName(LCName);
        bean.setLCState(LCState);
        bean.setCanDelete(canDelete);
        bean.setVersion(version);
        ListServiceUtil.sortServicesByName(bean);
        return bean;
    }

    private static void sortServicesByName(ServiceBean bean) {
        int i;
        ArrayList<ServiceEntry> serviceEntryList = new ArrayList<ServiceEntry>();
        for (i = 0; i < bean.getPath().length; ++i) {
            serviceEntryList.add(new ServiceEntry(bean.getPath()[i], bean.getNames()[i], bean.getNamespace()[i], bean.getLCName()[i], bean.getLCState()[i], bean.getVersion()[i], bean.getCanDelete()[i]));
        }
        Collections.sort(serviceEntryList, new Comparator<ServiceEntry>(){

            @Override
            public int compare(ServiceEntry se1, ServiceEntry se2) {
                int res = StringComparatorUtil.compare(se2.name, se1.name);
                if (res != 0) {
                    return res;
                }
                return StringComparatorUtil.compare(se1.version, se2.version);
            }
        });
        i = 0;
        for (ServiceEntry se : serviceEntryList) {
            bean.getPath()[i] = se.path;
            bean.getNames()[i] = se.name;
            bean.getNamespace()[i] = se.namespace;
            bean.getLCName()[i] = se.lcname;
            bean.getLCState()[i] = se.lcstate;
            bean.getCanDelete()[i] = se.canDelete;
            bean.getVersion()[i] = se.version;
            ++i;
        }
    }

    private static class ServiceEntry {
        private String path;
        private String name;
        private String namespace;
        private String lcname;
        private String lcstate;
        private String version;
        private boolean canDelete;

        ServiceEntry(String path, String name, String namespace, String lcname, String lcstate, String version, boolean canDelete) {
            this.path = path;
            this.name = name;
            this.namespace = namespace;
            this.lcname = lcname;
            this.lcstate = lcstate;
            this.canDelete = canDelete;
            this.version = version;
        }
    }
}

