/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util.filter;

import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.PolicyFilter;
import org.wso2.carbon.governance.api.policies.PolicyManager;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.list.util.filter.FilterStrategy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class FilterPolicy
extends FilterStrategy {
    public FilterPolicy(String criteria, Registry governanceRegistry, String artifactKey) {
        super(criteria, governanceRegistry, artifactKey);
    }

    @Override
    public GovernanceArtifact[] getArtifacts() throws RegistryException {
        PolicyManager policyManager = new PolicyManager(this.getGovernanceRegistry());
        if (this.getCriteria() != null && !"".equals(this.getCriteria())) {
            return policyManager.findPolicies(new PolicyFilter(){

                public boolean matches(Policy policy) throws GovernanceException {
                    String policyName = FilterPolicy.getPolicyName(policy);
                    return FilterPolicy.this.getCriteria() != null && !"".equals(FilterPolicy.this.getCriteria()) && policyName != null && policyName.contains(FilterPolicy.this.getCriteria());
                }
            });
        }
        return policyManager.getAllPolicies();
    }

    private static String getPolicyName(Policy policy) {
        String local = policy.getQName().getLocalPart();
        if (local != null && !"".equals(local)) {
            if (local.contains("\\.")) {
                return local.substring(0, local.lastIndexOf("\\."));
            }
            return local;
        }
        return local;
    }
}

