/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util.filter;

import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.schema.SchemaFilter;
import org.wso2.carbon.governance.api.schema.SchemaManager;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.list.util.filter.FilterStrategy;
import org.wso2.carbon.registry.core.Registry;

public class FilterSchema
extends FilterStrategy {
    public FilterSchema(String criteria, Registry governanceRegistry, String artifactKey) {
        super(criteria, governanceRegistry, artifactKey);
    }

    @Override
    public GovernanceArtifact[] getArtifacts() throws GovernanceException {
        SchemaManager schemaManager = new SchemaManager(this.getGovernanceRegistry());
        if (this.getCriteria() != null && !"".equals(this.getCriteria())) {
            return schemaManager.findSchemas(new SchemaFilter(){

                public boolean matches(Schema schema) throws GovernanceException {
                    String schemaName = FilterSchema.getSchemaName(schema);
                    return FilterSchema.this.getCriteria() != null && !"".equals(FilterSchema.this.getCriteria()) && schemaName != null && schemaName.contains(FilterSchema.this.getCriteria());
                }
            });
        }
        return schemaManager.getAllSchemas();
    }

    private static String getSchemaName(Schema schema) {
        String local = schema.getQName().getLocalPart();
        if (local != null && !"".equals(local)) {
            if (local.contains("\\.")) {
                return local.substring(0, local.lastIndexOf("\\."));
            }
            return local;
        }
        return local;
    }
}

