/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util.filter;

import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.list.util.GovernanceArtifactFilter;
import org.wso2.carbon.governance.list.util.filter.FilterStrategy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class FilterService
extends FilterStrategy {
    public FilterService(String criteria, Registry governanceRegistry, String artifactKey) {
        super(criteria, governanceRegistry, artifactKey);
    }

    @Override
    public GovernanceArtifact[] getArtifacts() throws GovernanceException {
        ServiceManager serviceManger;
        Service[] service = new Service[]{};
        try {
            serviceManger = new ServiceManager(this.getGovernanceRegistry());
        }
        catch (RegistryException e) {
            throw new GovernanceException("Service Manager Initialization Failed", (Throwable)e);
        }
        if (this.getCriteria() != null && !"".equals(this.getCriteria())) {
            XMLStreamReader reader = null;
            try {
                reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(this.getCriteria()));
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement referenceServiceElement = builder.getDocumentElement();
            final Service referenceService = serviceManger.newService(referenceServiceElement);
            ServiceFilter listServiceFilter = new ServiceFilter(){
                GovernanceArtifactFilter filter;
                {
                    this.filter = new GovernanceArtifactFilter((GovernanceArtifact)referenceService);
                }

                public boolean matches(Service service) throws GovernanceException {
                    return this.filter.matches((GovernanceArtifact)service);
                }
            };
            service = serviceManger.findServices(listServiceFilter);
        } else {
            service = serviceManger.getAllServices();
        }
        return service;
    }
}

