/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    int maxSize;
    private ReadWriteLock lock;

    public LRUCache(int maxSize) {
        super(maxSize + 1, 1.0f, false);
        this.maxSize = maxSize;
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.lock.writeLock().lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean remove;
        boolean bl = remove = this.size() > this.maxSize;
        if (remove) {
            this.handleRemovableEntry(eldest);
        }
        return remove;
    }

    protected void handleRemovableEntry(Map.Entry<K, V> entry) {
    }

    public void exclusiveLock() {
        this.lock.writeLock().lock();
    }

    public void release() {
        this.lock.writeLock().unlock();
    }
}

