/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.endpoints.dataobjects;

import java.io.StringReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;

public class EndpointImpl
extends GovernanceArtifactImpl
implements Endpoint {
    private static final Log log = LogFactory.getLog(EndpointImpl.class);
    private String url;
    private String name;

    public EndpointImpl(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadEndpointDetails();
    }

    public EndpointImpl(String url, String id) {
        super(id);
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public QName getQName() {
        return new QName(this.name);
    }

    @Override
    public void setQName(QName qName) throws GovernanceException {
        this.name = qName.getLocalPart();
    }

    public void loadEndpointDetails() throws GovernanceException {
        String endpointContent;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            Resource resource = registry.get(path);
            Object contentObj = resource.getContent();
            endpointContent = contentObj instanceof String ? (String)contentObj : new String((byte[])contentObj);
            this.url = EndpointUtils.deriveEndpointFromContent((String)endpointContent);
            this.name = EndpointUtils.deriveNameFromContent((String)endpointContent);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the content for the artifact. artifact id: " + id + ", path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        OMElement contentElement = this.buildOMElement(endpointContent);
        this.serializeToAttributes(contentElement, null);
    }

    public OMElement buildOMElement(String content) throws GovernanceException {
        XMLStreamReader parser;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", new Boolean(true));
            parser = factory.createXMLStreamReader(new StringReader(content));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private void serializeToAttributes(OMElement contentElement, String parentAttributeName) throws GovernanceException {
        Iterator childIt = contentElement.getChildren();
        if (childIt.hasNext()) {
            while (childIt.hasNext()) {
                OMText childText;
                Object childObj = childIt.next();
                if (childObj instanceof OMElement) {
                    OMElement childElement = (OMElement)childObj;
                    String elementName = childElement.getLocalName();
                    String attributeName = (parentAttributeName == null ? "" : parentAttributeName + "_") + elementName;
                    this.serializeToAttributes(childElement, attributeName);
                    continue;
                }
                if (!(childObj instanceof OMText) || (childText = (OMText)childObj).getNextOMSibling() != null || childText.getPreviousOMSibling() != null) continue;
                String textValue = childText.getText();
                this.addAttribute(parentAttributeName, textValue);
            }
        } else if (!contentElement.getChildElements().hasNext()) {
            this.addAttribute(parentAttributeName, null);
        }
    }
}

