/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.generic.dataobjects;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GenericArtifactImpl
extends GovernanceArtifactImpl
implements GenericArtifact {
    private QName qName;
    private String mediaType;
    private byte[] content;

    protected GenericArtifactImpl(GovernanceArtifact artifact, String mediaType) {
        super((GovernanceArtifactImpl)artifact);
        this.qName = artifact.getQName();
        this.setArtifactPath(((GovernanceArtifactImpl)artifact).getArtifactPath());
        this.setLcName(((GovernanceArtifactImpl)artifact).getLcName());
        this.setLcState(((GovernanceArtifactImpl)artifact).getLcState());
        this.mediaType = mediaType;
    }

    protected GenericArtifactImpl(GovernanceArtifact artifact, String mediaType, List<String> uniqueAttributes) {
        super((GovernanceArtifactImpl)artifact, uniqueAttributes);
        this.qName = artifact.getQName();
        this.setArtifactPath(((GovernanceArtifactImpl)artifact).getArtifactPath());
        this.setLcName(((GovernanceArtifactImpl)artifact).getLcName());
        this.setLcState(((GovernanceArtifactImpl)artifact).getLcState());
        this.mediaType = mediaType;
    }

    public GenericArtifactImpl(String id, QName qName, String mediaType) {
        super(id);
        this.qName = qName;
        this.mediaType = mediaType;
    }

    public GenericArtifactImpl(String id, QName qName, String mediaType, List<String> uniqueAttributes) {
        this(id, qName, mediaType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public GenericArtifactImpl(QName qName, String mediaType) {
        super(UUID.randomUUID().toString());
        this.qName = qName;
        this.mediaType = mediaType;
    }

    public GenericArtifactImpl(QName qName, String mediaType, List<String> uniqueAttributes) {
        this(qName, mediaType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    public void loadDetails() throws GovernanceException {
        Set<Object> keySet;
        Resource resource;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            resource = registry.get(path);
            this.content = (byte[])resource.getContent();
            this.mediaType = resource.getMediaType();
        }
        catch (RegistryException e) {
            throw new GovernanceException("Error in getting the qualified name for the artifact. artifact id: " + id + ", path: " + path + ".", e);
        }
        String fileName = RegistryUtils.getResourceName((String)path);
        this.qName = new QName(null, fileName);
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    this.addAttribute(key, value);
                }
            }
        }
    }

    public GenericArtifactImpl(String id, OMElement artifactContentElement, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementNamespace, String mediaType) throws GovernanceException {
        super(id, artifactContentElement);
        String namespace;
        String name = GovernanceUtils.getAttributeValue(artifactContentElement, artifactNameAttribute, artifactElementNamespace);
        String string = namespace = artifactNamespaceAttribute != null ? GovernanceUtils.getAttributeValue(artifactContentElement, artifactNamespaceAttribute, artifactElementNamespace) : null;
        if (name != null && !name.equals("")) {
            this.qName = new QName(namespace, name);
        }
        this.mediaType = mediaType;
    }

    public GenericArtifactImpl(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadDetails();
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setQName(QName qName) {
        this.qName = qName;
    }
}

