/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.indexing.service.TermsQuerySearchService;
import org.wso2.carbon.registry.indexing.service.TermsSearchService;

@Component(name="org.wso2.carbon.governance.api", immediate=true)
public class GovernanceAPIServiceComponent {
    private static final Log log = LogFactory.getLog(GovernanceAPIServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            log.debug((Object)"Governance API bundle is activated ");
        }
        catch (Exception e) {
            log.debug((Object)"****** Failed to activate Governance API bundle *******");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Governance API bundle is deactivated ");
    }

    @Reference(name="registryService.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        log.debug((Object)"Setting the Registry Service");
        GovernanceUtils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        log.debug((Object)"Un-setting the Registry Service");
        GovernanceUtils.setRegistryService(null);
    }

    @Reference(name="registry.search.component", service=AttributeSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAttributeSearchService")
    protected void setAttributeSearchService(AttributeSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Attribute Search Service");
        }
        GovernanceUtils.setAttributeSearchService(searchService);
    }

    protected void unsetAttributeSearchService(AttributeSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting Attribute Search Service");
        }
        GovernanceUtils.setAttributeSearchService(null);
    }

    @Reference(name="registry.content.search.component", service=ContentSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetContentSearchService")
    protected void setContentSearchService(ContentSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Content Search Service");
        }
        GovernanceUtils.setContentSearchService(searchService);
    }

    protected void unsetContentSearchService(ContentSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting Content Search Service");
        }
        GovernanceUtils.setContentSearchService(null);
    }

    @Reference(name="registry.term.component", service=TermsSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTermsSearchService")
    protected void setTermsSearchService(TermsSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting TermSearchService");
        }
        GovernanceUtils.setTermsSearchService(searchService);
    }

    protected void unsetTermsSearchService(TermsSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting TermSearchService");
        }
        GovernanceUtils.setTermsSearchService(null);
    }

    @Reference(name="registry.term.query.component", service=TermsQuerySearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTermsQuerySearchService")
    protected void setTermsQuerySearchService(TermsQuerySearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting TermsQuerySearchService");
        }
        GovernanceUtils.setTermsQuerySearchService(searchService);
    }

    protected void unsetTermsQuerySearchService(TermsQuerySearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting TermQuerySearchService");
        }
        GovernanceUtils.setTermsQuerySearchService(null);
    }
}

