/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class CheckpointTimeUtils {
    private static final String durationSecondsFormat = "%02ds";
    private static final String durationMinutesSecondsFormat = "%02dm:%02ds";
    private static final String durationHoursMinutesSecondsFormat = "%02dh:%02dm:%02ds";
    private static final String durationDaysHoursMinutesSecondsFormat = "%dd:%02dh:%02dm:%02ds";

    public static boolean isDurationBetweenTimestamps(long duration, String minTime, String maxTime) {
        boolean result = false;
        long durationInMillySeconds = TimeUnit.MILLISECONDS.convert(duration, TimeUnit.MILLISECONDS);
        long minBoundaryInMillySeconds = CheckpointTimeUtils.getMillySecondsByDuration(minTime);
        long maxBoundaryInMillySeconds = CheckpointTimeUtils.getMillySecondsByDuration(maxTime);
        if (minBoundaryInMillySeconds < durationInMillySeconds && durationInMillySeconds < maxBoundaryInMillySeconds) {
            result = true;
        }
        return result;
    }

    public static long getMillySecondsByDuration(String duration) {
        if (StringUtils.isEmpty((String)duration)) {
            throw new IllegalArgumentException("Invalid arguments supplied as duration: " + duration);
        }
        String formattedDuration = duration.replaceAll("d", "").replaceAll("h", "").replaceAll("m", "").replaceAll("s", "");
        String[] tokens = formattedDuration.split(":");
        long secondsToMillySeconds = Long.parseLong(tokens[3]) * 1000L;
        long minutesToMillySeconds = Long.parseLong(tokens[2]) * 60L * 1000L;
        long hoursToMillySeconds = Long.parseLong(tokens[1]) * 60L * 60L * 1000L;
        long daysToMillySeconds = Long.parseLong(tokens[0]) * 24L * 60L * 60L * 1000L;
        return daysToMillySeconds + secondsToMillySeconds + minutesToMillySeconds + hoursToMillySeconds;
    }

    public static long calculateTimeDifference(String timeStampOne, String timeStampTwo) {
        if (StringUtils.isEmpty((String)timeStampOne) && StringUtils.isEmpty((String)timeStampTwo)) {
            throw new IllegalArgumentException("Invalid arguments supplied as timestamp one: '" + timeStampOne + "' or timestamp two: '" + timeStampTwo + "' is not set");
        }
        return Timestamp.valueOf(timeStampOne).getTime() - Timestamp.valueOf(timeStampTwo).getTime();
    }

    public static long calculateTimeDifferenceToPresent(String timeStamp) {
        if (StringUtils.isEmpty((String)CheckpointTimeUtils.getCurrentTime()) && StringUtils.isEmpty((String)timeStamp)) {
            throw new IllegalArgumentException("Invalid arguments supplied as timestamp two: '" + timeStamp + "' is not set");
        }
        return Timestamp.valueOf(CheckpointTimeUtils.getCurrentTime()).getTime() - Timestamp.valueOf(timeStamp).getTime();
    }

    public static String getCurrentTime() {
        Date currentTimeStamp = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(currentTimeStamp);
    }

    public static String formatTimeDuration(long duration) {
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        String timeDuration = days == 0L && hours == 0L && minutes == 0L ? String.format(durationSecondsFormat, seconds) : (days == 0L && hours == 0L ? String.format(durationMinutesSecondsFormat, minutes, seconds) : (days == 0L ? String.format(durationHoursMinutesSecondsFormat, hours, minutes, seconds) : String.format(durationDaysHoursMinutesSecondsFormat, days, hours, minutes, seconds)));
        return timeDuration;
    }
}

