/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.util;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.base.CarbonContextHolderBase;
import org.wso2.carbon.base.UnloadTenantTask;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.cache.ArtifactCache;
import org.wso2.carbon.governance.api.cache.ArtifactCacheManager;
import org.wso2.carbon.governance.api.cache.RXTConfigCacheEntryCreatedListener;
import org.wso2.carbon.governance.api.cache.RXTConfigCacheEntryRemovedListener;
import org.wso2.carbon.governance.api.cache.RXTConfigCacheEntryUpdatedListener;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.common.util.ApproveItemBean;
import org.wso2.carbon.governance.api.common.util.CheckListItemBean;
import org.wso2.carbon.governance.api.endpoints.dataobjects.EndpointImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifactImpl;
import org.wso2.carbon.governance.api.policies.dataobjects.PolicyImpl;
import org.wso2.carbon.governance.api.schema.dataobjects.SchemaImpl;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.wsdls.dataobjects.WsdlImpl;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.indexing.service.RxtUnboundedFieldManagerService;
import org.wso2.carbon.registry.indexing.service.TermsQuerySearchService;
import org.wso2.carbon.registry.indexing.service.TermsSearchService;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class GovernanceUtils {
    private static final Log log = LogFactory.getLog(GovernanceUtils.class);
    private static final String OVERVIEW = "overview";
    private static final String UNDERSCORE = "_";
    private static final String FIELDS_OR_WILD_SEARCH = " or*&";
    private static final String FIELDS_OR_SEARCH = " or&";
    private static final String FIELDS_AND_WILD_SEARCH = " and*&";
    private static final String SYMBOL_EQUAL = "=";
    private static final String SYMBOL_COLON = ":";
    private static final String FIELDS_AND_SEARCH = " and&";
    private static final String SYMBOL_AND = "&";
    private static final String REPLACEMENT_OR_WILD_SEARCH = "* OR ";
    private static final String REPLACEMENT_AND_WILD_SEARCH = "* AND ";
    private static final String REPLACEMENT_OR_SEARCH = " OR ";
    private static final String REPLACEMENT_AND_SEARCH = "AND ";
    private static final String REPLACEMENT_SYMBOL_AND = " AND ";
    private static RegistryService registryService;
    private static final Map<Integer, List<GovernanceArtifactConfiguration>> artifactConfigurations;
    private static Map<Integer, Map<String, Boolean>> lifecycleAspects;
    private static final Object ASPECT_MAP_LOCK;
    private static AttributeSearchService attributeSearchService;
    private static final ThreadLocal<Registry> tenantGovernanceSystemRegistry;
    private static final RXTConfigCacheEntryCreatedListener<String, Boolean> entryCreatedListener;
    private static final RXTConfigCacheEntryRemovedListener<String, Boolean> entryRemovedListener;
    private static final RXTConfigCacheEntryUpdatedListener<String, Boolean> entryUpdatedListener;
    private static boolean rxtCacheInitiated;
    private static TermsSearchService termsSearchService;
    private static ContentSearchService contentSearchService;
    private static TermsQuerySearchService termsQuerySearchService;

    public static void setRegistryService(RegistryService registryService) {
        GovernanceUtils.registryService = registryService;
    }

    private static void registerArtifactConfigurations(int tenantId, List<GovernanceArtifactConfiguration> configurations) {
        artifactConfigurations.put(tenantId, configurations);
        CarbonContextHolderBase.registerUnloadTenantTask((UnloadTenantTask)new UnloadTenantTask(){

            public void register(int tenantId, Object registration) {
            }

            public void cleanup(int tenantId) {
                if (artifactConfigurations.get(tenantId) != null) {
                    artifactConfigurations.remove(tenantId);
                }
                if (lifecycleAspects.get(tenantId) != null) {
                    lifecycleAspects.remove(tenantId);
                }
            }
        });
    }

    public static void registerArtifactConfigurationByPath(Registry registry, int tenantId, String path) throws RegistryException {
        Resource resource = registry.get(path);
        Object content = resource.getContent();
        String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
        GovernanceArtifactConfiguration governanceArtifactConfiguration = GovernanceUtils.getGovernanceArtifactConfiguration(elementString);
        List<GovernanceArtifactConfiguration> configurations = artifactConfigurations.get(tenantId);
        if (configurations != null) {
            configurations.add(governanceArtifactConfiguration);
        } else {
            configurations = new LinkedList<GovernanceArtifactConfiguration>();
            configurations.add(governanceArtifactConfiguration);
        }
        artifactConfigurations.put(tenantId, configurations);
    }

    public static String[] findGovernanceArtifacts(String mediaType, Registry registry) throws RegistryException {
        String[] paths = MediaTypesUtils.getResultPaths((Registry)registry, (String)mediaType);
        if (paths == null) {
            paths = new String[]{};
        }
        Arrays.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = RegistryUtils.getResourceName((String)o1).compareToIgnoreCase(RegistryUtils.getResourceName((String)o2));
                if (result == 0) {
                    return o1.compareToIgnoreCase(o2);
                }
                return result;
            }
        });
        return paths;
    }

    public static GovernanceArtifactConfiguration findGovernanceArtifactConfigurationByMediaType(String mediaType, Registry registry) throws RegistryException {
        List<GovernanceArtifactConfiguration> governanceArtifactConfigurations = artifactConfigurations.get(((UserRegistry)registry).getTenantId());
        if (governanceArtifactConfigurations == null || governanceArtifactConfigurations.isEmpty()) {
            governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations(registry);
            artifactConfigurations.put(((UserRegistry)registry).getTenantId(), governanceArtifactConfigurations);
        }
        for (GovernanceArtifactConfiguration configuration : governanceArtifactConfigurations) {
            if (!mediaType.equals(configuration.getMediaType())) continue;
            return configuration;
        }
        return null;
    }

    public static GovernanceArtifactConfiguration findGovernanceArtifactConfiguration(String key, Registry registry) throws RegistryException {
        int tenantID = ((UserRegistry)registry).getTenantId();
        List<GovernanceArtifactConfiguration> governanceArtifactConfigurations = artifactConfigurations.get(tenantID);
        if (governanceArtifactConfigurations == null || governanceArtifactConfigurations.isEmpty()) {
            governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations(registry);
            artifactConfigurations.put(tenantID, governanceArtifactConfigurations);
        }
        GovernanceArtifactConfiguration configuration = null;
        for (GovernanceArtifactConfiguration config : governanceArtifactConfigurations) {
            if (!key.equals(config.getKey())) continue;
            configuration = config;
            break;
        }
        if (configuration == null) {
            artifactConfigurations.remove(tenantID);
            governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations(registry);
            artifactConfigurations.put(tenantID, governanceArtifactConfigurations);
            for (GovernanceArtifactConfiguration config : governanceArtifactConfigurations) {
                if (!key.equals(config.getKey())) continue;
                configuration = config;
                break;
            }
        }
        return configuration;
    }

    public static String getLifeCycleOfContext(String key, String contextName, Registry registry) throws RegistryException {
        GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration(key, registry);
        if (configuration != null) {
            return configuration.getLifeCycleOfContext(contextName);
        }
        return null;
    }

    public static String[] getResultPaths(Registry registry, String mediaType) throws GovernanceException {
        try {
            return MediaTypesUtils.getResultPaths((Registry)registry, (String)mediaType);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the result for media type: " + mediaType + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    private static String[] removeSymbolicLinks(String[] paths, Registry governanceRegistry) {
        if (paths == null) {
            return new String[0];
        }
        LinkedList<String> fixedPaths = new LinkedList<String>();
        for (String path : paths) {
            try {
                if (governanceRegistry.get(path).getProperty("registry.link") != null && governanceRegistry.get(path).getProperty("registry.realpath") == null || path.contains("/repository/components/org.wso2.carbon.registry/mount")) continue;
                fixedPaths.add(path);
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        return fixedPaths.toArray(new String[fixedPaths.size()]);
    }

    public static void loadGovernanceArtifacts(UserRegistry registry, List<GovernanceArtifactConfiguration> configurations) throws RegistryException {
        GovernanceUtils.registerArtifactConfigurations(registry.getTenantId(), configurations);
    }

    public static void loadGovernanceArtifacts(UserRegistry registry) throws RegistryException {
        if (!artifactConfigurations.containsKey(registry.getTenantId())) {
            GovernanceUtils.loadGovernanceArtifacts(registry, Collections.unmodifiableList(GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry)));
        }
    }

    public static GovernanceArtifactConfiguration getGovernanceArtifactConfiguration(String elementString) {
        GovernanceArtifactConfiguration configuration = null;
        try {
            OMElement configElement = AXIOMUtil.stringToOM((String)elementString);
            if (configElement != null) {
                OMElement uiPermissions;
                OMElement uiConfigurations;
                OMElement associationDefinitions;
                OMElement contentDefinition;
                OMElement lifecycleContextsElement;
                OMElement groupingAttributeElement;
                OMElement taxonomiesElement;
                OMElement pathExpressionElement;
                OMElement artifactElementNamespaceElement;
                OMElement artifactNamespaceAttributeElement;
                configuration = new GovernanceArtifactConfiguration();
                OMElement artifactNameAttributeElement = configElement.getFirstChildWithName(new QName("nameAttribute"));
                if (artifactNameAttributeElement != null) {
                    configuration.setArtifactNameAttribute(artifactNameAttributeElement.getText());
                }
                if ((artifactNamespaceAttributeElement = configElement.getFirstChildWithName(new QName("namespaceAttribute"))) != null) {
                    configuration.setArtifactNamespaceAttribute(artifactNamespaceAttributeElement.getText());
                } else if (Boolean.toString(false).equals(configElement.getAttributeValue(new QName("hasNamespace")))) {
                    configuration.setArtifactNamespaceAttribute(null);
                } else {
                    configuration.setHasNamespace(true);
                }
                OMElement artifactElementRootElement = configElement.getFirstChildWithName(new QName("elementRoot"));
                if (artifactElementRootElement != null) {
                    configuration.setArtifactElementRoot(artifactElementRootElement.getText());
                }
                if ((artifactElementNamespaceElement = configElement.getFirstChildWithName(new QName("elementNamespace"))) != null) {
                    configuration.setArtifactElementNamespace(artifactElementNamespaceElement.getText());
                }
                configuration.setKey(configElement.getAttributeValue(new QName("shortName")));
                configuration.setSingularLabel(configElement.getAttributeValue(new QName("singularLabel")));
                configuration.setPluralLabel(configElement.getAttributeValue(new QName("pluralLabel")));
                configuration.setMediaType(configElement.getAttributeValue(new QName("type")));
                configuration.setExtension(configElement.getAttributeValue(new QName("fileExtension")));
                String iconSetString = configElement.getAttributeValue(new QName("iconSet"));
                if (iconSetString != null) {
                    configuration.setIconSet(Integer.parseInt(iconSetString));
                }
                if ((pathExpressionElement = configElement.getFirstChildWithName(new QName("storagePath"))) != null) {
                    configuration.setPathExpression(pathExpressionElement.getText());
                } else {
                    configuration.setPathExpression("/@{name}");
                }
                OMElement lifecycleElement = configElement.getFirstChildWithName(new QName("lifecycle"));
                if (lifecycleElement != null) {
                    configuration.setLifecycle(lifecycleElement.getText());
                }
                if ((taxonomiesElement = configElement.getFirstChildWithName(new QName("taxonomies"))) != null) {
                    Iterator taxonomiesElements = taxonomiesElement.getChildrenWithName(new QName("taxonomy"));
                    String isGlobalTaxonomyEnabled = taxonomiesElement.getAttributeValue(new QName("excludeGlobal"));
                    while (taxonomiesElements.hasNext()) {
                        OMElement taxonomyElement = (OMElement)taxonomiesElements.next();
                        if (taxonomyElement == null) continue;
                        String name = taxonomyElement.getAttributeValue(new QName("name"));
                        String isDisable = taxonomyElement.getAttributeValue(new QName("disable"));
                        configuration.setTaxonomy(name, Boolean.valueOf(isDisable), Boolean.valueOf(isGlobalTaxonomyEnabled));
                    }
                }
                if ((groupingAttributeElement = configElement.getFirstChildWithName(new QName("groupingAttribute"))) != null) {
                    configuration.setGroupingAttribute(groupingAttributeElement.getText());
                }
                if ((lifecycleContextsElement = configElement.getFirstChildWithName(new QName("lifecycleContexts"))) != null) {
                    Iterator lifecycleContextsIterator = lifecycleContextsElement.getChildrenWithName(new QName("lifecycleContext"));
                    while (lifecycleContextsIterator.hasNext()) {
                        String[] contexts;
                        OMElement lifecycleContextElement = (OMElement)lifecycleContextsIterator.next();
                        String lcName = lifecycleContextElement.getAttributeValue(new QName("lcName"));
                        String contextsStr = lifecycleContextElement.getText();
                        for (String context : contexts = contextsStr.split(",")) {
                            configuration.addLifeCycleToContext(context, lcName);
                        }
                    }
                }
                if ((contentDefinition = configElement.getFirstChildWithName(new QName("content"))) != null) {
                    String href = contentDefinition.getAttributeValue(new QName("href"));
                    if (href != null) {
                        configuration.setContentURL(href);
                    }
                    configuration.setContentDefinition(contentDefinition);
                }
                if ((associationDefinitions = configElement.getFirstChildWithName(new QName("relationships"))) != null) {
                    OMElement associationElement;
                    LinkedList<Association> associations = new LinkedList<Association>();
                    Iterator associationElements = associationDefinitions.getChildrenWithName(new QName("association"));
                    while (associationElements.hasNext()) {
                        associationElement = (OMElement)associationElements.next();
                        String type = associationElement.getAttributeValue(new QName("type"));
                        String source = associationElement.getAttributeValue(new QName("source"));
                        String target = associationElement.getAttributeValue(new QName("target"));
                        associations.add(new Association(source, target, type));
                    }
                    associationElements = associationDefinitions.getChildrenWithName(new QName("dependency"));
                    while (associationElements.hasNext()) {
                        associationElement = (OMElement)associationElements.next();
                        String source = associationElement.getAttributeValue(new QName("source"));
                        String target = associationElement.getAttributeValue(new QName("target"));
                        associations.add(new Association(source, target, "depends"));
                    }
                    configuration.setRelationshipDefinitions(associations.toArray(new Association[associations.size()]));
                }
                if ((uiConfigurations = configElement.getFirstChildWithName(new QName("ui"))) != null) {
                    configuration.setUIConfigurations(uiConfigurations);
                    OMElement uiListConfigurations = uiConfigurations.getFirstChildWithName(new QName("list"));
                    if (uiListConfigurations != null) {
                        configuration.setUIListConfigurations(uiListConfigurations);
                    }
                }
                if ((uiPermissions = configElement.getFirstChildWithName(new QName("permissions"))) != null) {
                    Iterator permissionElements = uiPermissions.getChildrenWithName(new QName("permission"));
                    LinkedList<ManagementPermission> managementPermissions = new LinkedList<ManagementPermission>();
                    while (permissionElements.hasNext()) {
                        String id;
                        OMElement permissionElement = (OMElement)permissionElements.next();
                        OMElement nameElement = permissionElement.getFirstChildWithName(new QName("name"));
                        String name = nameElement != null ? nameElement.getText() : null;
                        OMElement idElement = permissionElement.getFirstChildWithName(new QName("id"));
                        String string = id = idElement != null ? idElement.getText() : null;
                        if (name == null || id == null) continue;
                        managementPermissions.add(new ManagementPermission(name, id));
                    }
                    configuration.setUIPermissions(managementPermissions.toArray(new ManagementPermission[managementPermissions.size()]));
                } else {
                    LinkedList<ManagementPermission> managementPermissions = new LinkedList<ManagementPermission>();
                    String idPrefix = "/permission/admin/manage/resources/govern/" + configuration.getKey();
                    managementPermissions.add(new ManagementPermission(configuration.getPluralLabel(), idPrefix));
                    managementPermissions.add(new ManagementPermission("Add", idPrefix + "/add"));
                    managementPermissions.add(new ManagementPermission("List", idPrefix + "/list"));
                    managementPermissions.add(new ManagementPermission(configuration.getPluralLabel(), "/permission/admin/configure/governance/" + configuration.getKey() + "-ui"));
                    configuration.setUIPermissions(managementPermissions.toArray(new ManagementPermission[managementPermissions.size()]));
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return configuration;
    }

    public static List<GovernanceArtifactConfiguration> findGovernanceArtifactConfigurations(Registry registry) throws RegistryException {
        String[] artifactConfigurations = GovernanceUtils.findGovernanceArtifacts("application/vnd.wso2.registry-ext-type+xml", registry);
        LinkedList<GovernanceArtifactConfiguration> configurations = new LinkedList<GovernanceArtifactConfiguration>();
        for (String artifactConfiguration : artifactConfigurations) {
            Resource resource = registry.get(artifactConfiguration);
            Object content = resource.getContent();
            String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
            configurations.add(GovernanceUtils.getGovernanceArtifactConfiguration(elementString));
        }
        return configurations;
    }

    public static GovernanceArtifactConfiguration getArtifactConfigurationByMediaType(Registry registry, String mediaType) throws RegistryException {
        List<GovernanceArtifactConfiguration> configurations = GovernanceUtils.findGovernanceArtifactConfigurations(registry);
        for (GovernanceArtifactConfiguration configuration : configurations) {
            if (!configuration.getMediaType().equals(mediaType)) continue;
            return configuration;
        }
        return null;
    }

    public static void setTenantGovernanceSystemRegistry(int tenantId) throws RegistryException {
        if (registryService != null) {
            tenantGovernanceSystemRegistry.set((Registry)registryService.getGovernanceSystemRegistry(tenantId));
        }
    }

    public static void unsetTenantGovernanceSystemRegistry() throws RegistryException {
        tenantGovernanceSystemRegistry.remove();
    }

    public static Registry getGovernanceSystemRegistry(Registry registry) throws RegistryException {
        if (tenantGovernanceSystemRegistry.get() != null) {
            return tenantGovernanceSystemRegistry.get();
        }
        if (registryService == null) {
            return null;
        }
        if (!(registry instanceof UserRegistry)) {
            return null;
        }
        UserRegistry userRegistry = (UserRegistry)registry;
        return registryService.getGovernanceSystemRegistry(userRegistry.getTenantId());
    }

    public static Registry getGovernanceUserRegistry(Registry registry, String username) throws RegistryException {
        if (RegistryContext.getBaseInstance() == null) {
            RegistryContext.getBaseInstance(null, (boolean)false);
        }
        return new UserRegistry(username, -1234, registry, null, "/_system/governance");
    }

    public static Registry getGovernanceUserRegistry(Registry registry, String username, int tenantId) throws RegistryException {
        if (RegistryContext.getBaseInstance() == null) {
            RegistryContext.getBaseInstance(null, (boolean)false);
        }
        return new UserRegistry(username, tenantId, registry, null, "/_system/governance");
    }

    public static String parameterizeString(RequestContext requestContext, String parameterString) {
        String parameterizedString = parameterString;
        Pattern pattern = Pattern.compile("\\{@(\\w)*\\}");
        Matcher matcher = pattern.matcher(parameterString);
        Registry registry = requestContext.getRegistry();
        String resourcePath = requestContext.getResourcePath().getPath();
        HashSet<String> matchSet = new HashSet<String>();
        while (matcher.find()) {
            matchSet.add(matcher.group());
        }
        for (String current : matchSet) {
            String name = current.substring(2, current.length() - 1);
            if (name.equals("resourcePath")) {
                parameterizedString = parameterizedString.replaceAll("\\" + current.replace("}", "\\}"), resourcePath);
            }
            try {
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(requestContext.getSystemRegistry(), resourcePath);
                if (governanceArtifact != null && governanceArtifact.getAttribute(name) != null) {
                    parameterizedString = parameterizedString.replaceAll("\\" + current.replace("}", "\\}"), governanceArtifact.getAttribute(name));
                    continue;
                }
                if (registry.get(resourcePath).getProperty(name) != null) {
                    parameterizedString = parameterizedString.replaceAll("\\" + current.replace("}", "\\}"), registry.get(resourcePath).getProperty(name));
                    continue;
                }
                log.error((Object)"Unable to locate the given value in properties or attributes");
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return parameterizedString;
    }

    public static void removeArtifact(Registry registry, String artifactId) throws GovernanceException {
        try {
            ArtifactCache artifactCache;
            String path = GovernanceUtils.getArtifactPath(registry, artifactId);
            if (registry.resourceExists(path)) {
                GovernanceUtils.deleteLifecycleHistoryFile(path, registry);
                registry.delete(path);
            }
            if ((artifactCache = ArtifactCacheManager.getCacheManager().getTenantArtifactCache(((UserRegistry)registry).getTenantId())) != null && path != null) {
                artifactCache.invalidateArtifact(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in deleting the the artifact id:" + artifactId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String getArtifactPath(Registry registry, String artifactId) throws GovernanceException {
        UserRegistry userRegistry = (UserRegistry)registry;
        if (userRegistry.getUserRealm() == null) {
            return GovernanceUtils.getDirectArtifactPath(registry, artifactId);
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(userRegistry.getTenantId());
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            if (tenantDomain == null) {
                tenantDomain = MultitenantUtils.getTenantDomain((String)((UserRegistry)registry).getUserName());
            }
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
            Cache cache = RegistryUtils.getUUIDCache((String)"REG_UUID_CACHE");
            if (cache.containsKey((Object)artifactId)) {
                String string = (String)cache.get((Object)artifactId);
                return string;
            }
            String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_UUID = ?";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("1", artifactId);
            parameter.put("query", sql);
            String[] result = registry.executeQuery(null, parameter).getChildren();
            if (result != null && result.length == 1) {
                cache.put((Object)artifactId, (Object)result[0]);
                String string = result[0];
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static String getDirectArtifactPath(Registry registry, String artifactId) throws GovernanceException {
        try {
            String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_UUID = ?";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("1", artifactId);
            parameter.put("query", sql);
            String[] result = registry.executeQuery(null, parameter).getChildren();
            if (result != null && result.length == 1) {
                return result[0];
            }
            return null;
        }
        catch (RegistryException e) {
            String msg = "Error in getting the path from the registry. Execute query failed with message : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String[] getAllArtifactPathsByLifecycle(Registry registry, String lcName, String mediaType) throws GovernanceException {
        String sql = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID AND PP.REG_NAME = ?  AND  PP.REG_VALUE = ? AND R.REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("1", "registry.LC.name");
        parameter.put("2", lcName);
        parameter.put("3", mediaType);
        parameter.put("query", sql);
        try {
            return (String[])registry.executeQuery(null, parameter).getContent();
        }
        catch (RegistryException e) {
            String msg = "Error occured while executing custom query";
            throw new GovernanceException(msg, e);
        }
    }

    public static String[] getAllArtifactPathsByLifecycleState(Registry registry, String lcName, String lcState, String mediaType) throws GovernanceException {
        String sql = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID AND PP.REG_NAME = ?  AND  PP.REG_VALUE = ? AND R.REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("1", "registry.lifecycle." + lcName + ".state");
        parameter.put("2", lcState);
        parameter.put("3", mediaType);
        parameter.put("query", sql);
        try {
            return (String[])registry.executeQuery(null, parameter).getContent();
        }
        catch (RegistryException e) {
            String msg = "Error occured while executing custom query";
            throw new GovernanceException(msg, e);
        }
    }

    public static String getAttributeValue(OMElement element, String name, String namespace) {
        String[] parts = name.split(UNDERSCORE);
        OMElement attributeElement = element;
        for (String part : parts) {
            if ((attributeElement = attributeElement.getFirstChildWithName(new QName(namespace, part))) != null) continue;
            return "";
        }
        return attributeElement.getText();
    }

    public static String[] getAllArtifactIds(Registry registry) throws GovernanceException {
        throw new UnsupportedOperationException();
    }

    public static GovernanceArtifact[] getAllArtifacts(Registry registry) throws GovernanceException {
        throw new UnsupportedOperationException();
    }

    public static GovernanceArtifact retrieveGovernanceArtifactById(Registry registry, String artifactId) throws GovernanceException {
        String artifactPath = GovernanceUtils.getArtifactPath(registry, artifactId);
        if (artifactPath == null) {
            String msg = "Governance artifact is not found for id: " + artifactId + ".";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            return null;
        }
        return GovernanceUtils.retrieveGovernanceArtifactByPath(registry, artifactPath);
    }

    public static GovernanceArtifact retrieveGovernanceArtifactByPath(Registry registry, String artifactPath) throws GovernanceException {
        GovernanceArtifact governanceArtifact;
        UserRegistry userRegistry = (UserRegistry)registry;
        String currentUser = userRegistry.getUserName();
        ArtifactCache artifactCache = ArtifactCacheManager.getCacheManager().getTenantArtifactCache(userRegistry.getTenantId());
        if (artifactPath != null && artifactCache != null && (governanceArtifact = artifactCache.getArtifact(artifactPath)) != null) {
            return governanceArtifact;
        }
        String artifactLCState = null;
        try {
            List<GovernanceArtifactConfiguration> configurations;
            String artifactLC;
            Resource artifactResource;
            if (registry.resourceExists(artifactPath)) {
                try {
                    artifactResource = registry.get(artifactPath);
                }
                catch (AuthorizationFailedException e) {
                    if (log.isDebugEnabled()) {
                        String msg = "User does not have access to path " + artifactPath + ".";
                        log.debug((Object)msg);
                    }
                    return null;
                }
                artifactLC = artifactResource.getProperty("registry.LC.name");
                if (artifactLC != null) {
                    artifactLCState = artifactResource.getProperty("registry.lifecycle." + artifactLC + ".state");
                }
            } else {
                if (log.isDebugEnabled()) {
                    String msg = "The artifact path doesn't exists at " + artifactPath + ".";
                    log.debug((Object)msg);
                }
                return null;
            }
            String artifactId = artifactResource.getUUID();
            String mediaType = artifactResource.getMediaType();
            List<String> uniqueAttributes = GovernanceUtils.getUniqueAttributesNames(registry, mediaType);
            if ("application/wsdl+xml".equals(mediaType)) {
                WsdlImpl wsdl = new WsdlImpl(artifactId, registry);
                wsdl.setLcName(artifactLC);
                wsdl.setLcState(artifactLCState);
                wsdl.setArtifactPath(artifactPath);
                wsdl.setUniqueAttributes(uniqueAttributes);
                if (artifactCache != null) {
                    artifactCache.addArtifact(artifactPath, wsdl);
                }
                return wsdl;
            }
            if ("application/x-xsd+xml".equals(mediaType)) {
                SchemaImpl schema = new SchemaImpl(artifactId, registry);
                schema.setLcName(artifactLC);
                schema.setLcState(artifactLCState);
                schema.setArtifactPath(artifactPath);
                schema.setUniqueAttributes(uniqueAttributes);
                if (artifactCache != null) {
                    artifactCache.addArtifact(artifactPath, schema);
                }
                return schema;
            }
            if ("application/policy+xml".equals(mediaType)) {
                PolicyImpl policy = new PolicyImpl(artifactId, registry);
                policy.setLcName(artifactLC);
                policy.setLcState(artifactLCState);
                policy.setArtifactPath(artifactPath);
                policy.setUniqueAttributes(uniqueAttributes);
                if (artifactCache != null) {
                    artifactCache.addArtifact(artifactPath, policy);
                }
                return policy;
            }
            if ("application/vnd.wso2-endpoint+xml".equals(mediaType)) {
                EndpointImpl endpoint = new EndpointImpl(artifactId, registry);
                endpoint.setLcName(artifactLC);
                endpoint.setLcState(artifactLCState);
                endpoint.setArtifactPath(artifactPath);
                endpoint.setUniqueAttributes(uniqueAttributes);
                if (artifactCache != null) {
                    artifactCache.addArtifact(artifactPath, endpoint);
                }
                return endpoint;
            }
            if (mediaType != null && mediaType.matches("application/[a-zA-Z0-9.+-]+") && registry instanceof UserRegistry && (configurations = artifactConfigurations.get(((UserRegistry)registry).getTenantId())) != null) {
                for (GovernanceArtifactConfiguration configuration : configurations) {
                    GenericArtifactImpl artifact;
                    if (!mediaType.equals(configuration.getMediaType())) continue;
                    if (mediaType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml")) {
                        byte[] contentBytes = (byte[])artifactResource.getContent();
                        if (contentBytes == null || contentBytes.length == 0) {
                            throw new GovernanceException("Unable to read payload of governance artifact at path: " + artifactPath);
                        }
                        OMElement contentElement = GovernanceUtils.buildOMElement(contentBytes);
                        artifact = new GenericArtifactImpl(artifactId, contentElement, configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementNamespace(), configuration.getMediaType());
                        artifact.associateRegistry(registry);
                        artifact.setArtifactPath(artifactPath);
                    } else {
                        artifact = new GenericArtifactImpl(artifactId, registry);
                    }
                    artifact.setLcState(artifactLCState);
                    artifact.setLcName(artifactLC);
                    artifact.setUniqueAttributes(uniqueAttributes);
                    if (artifactCache != null) {
                        artifactCache.addArtifact(artifactPath, artifact);
                    }
                    return artifact;
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Error in retrieving governance artifact by path. path: " + artifactPath + ".";
            throw new GovernanceException(msg, e);
        }
        return null;
    }

    public static CheckListItemBean[] getAllCheckListItemBeans(Resource artifactResource, GovernanceArtifact artifact, String artifactLC) throws GovernanceException {
        String defaultLC = artifactResource.getProperty("registry.LC.name");
        String artifactLCState = artifactResource.getProperty("registry.lifecycle." + artifactLC + ".state");
        if (artifactLC.equals(defaultLC)) {
            ((GovernanceArtifactImpl)artifact).setLcState(artifactLCState);
        }
        ArrayList<CheckListItemBean> checkListItemList = new ArrayList<CheckListItemBean>();
        Properties lifecycleProps = artifactResource.getProperties();
        Set<Object> propertyKeys = lifecycleProps.keySet();
        for (Object propertyObj : propertyKeys) {
            String propertyKey = (String)propertyObj;
            String checkListPrefix = "registry.custom_lifecycle.checklist.";
            String checkListSuffix = ".item";
            if (!propertyKey.startsWith(checkListPrefix) || !propertyKey.endsWith(checkListSuffix) || !propertyKey.contains("." + artifactLC + ".")) continue;
            List propValues = (List)lifecycleProps.get(propertyKey);
            CheckListItemBean checkListItem = new CheckListItemBean();
            if (propValues != null && propValues.size() > 2) {
                for (String param : propValues) {
                    if (param.startsWith("status:")) {
                        checkListItem.setStatus(param.substring(7));
                        continue;
                    }
                    if (param.startsWith("name:")) {
                        checkListItem.setName(param.substring(5));
                        continue;
                    }
                    if (param.startsWith("value:")) {
                        checkListItem.setValue(Boolean.parseBoolean(param.substring(6)));
                        continue;
                    }
                    if (!param.startsWith("order:")) continue;
                    checkListItem.setOrder(Integer.parseInt(param.substring(6)));
                }
            }
            checkListItemList.add(checkListItem);
        }
        CheckListItemBean[] checkListItemBeans = new CheckListItemBean[checkListItemList.size()];
        if (checkListItemBeans.length > 0) {
            Iterator iterator = checkListItemList.iterator();
            while (iterator.hasNext()) {
                CheckListItemBean checkListItemBean;
                checkListItemBeans[checkListItemBean.getOrder()] = checkListItemBean = (CheckListItemBean)iterator.next();
            }
            return checkListItemBeans;
        }
        return null;
    }

    public static ApproveItemBean[] getAllApproveItemBeans(String currentUser, Resource artifactResource, GovernanceArtifact artifact, String artifactLC) throws GovernanceException {
        String defaultLC = artifactResource.getProperty("registry.LC.name");
        String artifactLCState = artifactResource.getProperty("registry.lifecycle." + artifactLC + ".state");
        if (artifactLC.equals(defaultLC)) {
            ((GovernanceArtifactImpl)artifact).setLcState(artifactLCState);
        }
        if (artifactLC == null) {
            throw new GovernanceException("No lifecycle associated with the artifact path " + artifactResource.getPath());
        }
        ((GovernanceArtifactImpl)artifact).setLcState(artifactLCState);
        ArrayList<ApproveItemBean> approveItemList = new ArrayList<ApproveItemBean>();
        Properties lifecycleProps = artifactResource.getProperties();
        Set<Object> propertyKeys = lifecycleProps.keySet();
        for (Object propertyObj : propertyKeys) {
            String propertyKey = (String)propertyObj;
            String votingPrefix = "registry.custom_lifecycle.votes.";
            String votingSuffix = ".vote";
            if (!propertyKey.startsWith(votingPrefix) || !propertyKey.endsWith(votingSuffix) || !propertyKey.contains("." + artifactLC + ".")) continue;
            List propValues = (List)lifecycleProps.get(propertyKey);
            ApproveItemBean approveItemBean = new ApproveItemBean();
            if (propValues != null && propValues.size() > 2) {
                for (String param : propValues) {
                    String users;
                    if (param.startsWith("status:")) {
                        approveItemBean.setStatus(param.substring(7));
                        continue;
                    }
                    if (param.startsWith("name:")) {
                        approveItemBean.setName(param.substring(5));
                        continue;
                    }
                    if (param.startsWith("votes:")) {
                        approveItemBean.setRequiredVotes(Integer.parseInt(param.substring(6)));
                        continue;
                    }
                    if (param.startsWith("current:")) {
                        approveItemBean.setVotes(Integer.parseInt(param.substring(8)));
                        continue;
                    }
                    if (param.startsWith("order:")) {
                        approveItemBean.setOrder(Integer.parseInt(param.substring(6)));
                        continue;
                    }
                    if (!param.startsWith("users:") || (users = param.substring(6)).equals("")) continue;
                    List<String> votedUsers = Arrays.asList(users.split(","));
                    approveItemBean.setVoters(votedUsers);
                    approveItemBean.setValue(votedUsers.contains(currentUser));
                }
            }
            approveItemList.add(approveItemBean);
        }
        ApproveItemBean[] approveItemBeans = new ApproveItemBean[approveItemList.size()];
        if (approveItemBeans.length > 0) {
            Iterator iterator = approveItemList.iterator();
            while (iterator.hasNext()) {
                ApproveItemBean approveItemBean;
                approveItemBeans[approveItemBean.getOrder()] = approveItemBean = (ApproveItemBean)iterator.next();
            }
            return approveItemBeans;
        }
        return null;
    }

    public static OMElement buildOMElement(byte[] content) throws RegistryException {
        XMLStreamReader parser;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", new Boolean(true));
            parser = factory.createXMLStreamReader(new StringReader(RegistryUtils.decodeBytes((byte[])content)));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static String serializeOMElement(OMElement element) throws GovernanceException {
        try {
            return element.toStringWithConsume();
        }
        catch (XMLStreamException e) {
            String msg = "Error in serializing the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String getPathFromPathExpression(String pathExpression, GovernanceArtifact artifact, String storagePath) throws GovernanceException {
        return GovernanceUtils.getPathFromPathExpression(pathExpression.replace("@{storagePath}", storagePath).replace("@{uuid}", artifact.getId()), artifact);
    }

    public static String getPathFromPathExpression(String pathExpression, GovernanceArtifact artifact) throws GovernanceException {
        String output = GovernanceUtils.replaceNameAndNamespace(pathExpression, artifact);
        String[] elements = output.split("@");
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1);
            String artifactAttribute = artifact.getAttribute(key);
            if (artifactAttribute != null) {
                output = output.replace("@{" + key + "}", artifactAttribute);
                continue;
            }
            String msg = "Value for required attribute " + key + " found empty.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return output;
    }

    public static boolean hasSamePath(String pathExpression, GovernanceArtifact newArtifact, GovernanceArtifact oldArtifact) throws GovernanceException {
        String output = GovernanceUtils.replaceNameAndNamespace(pathExpression, newArtifact);
        String[] elements = output.split("@");
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1);
            String oldArtifactAttribute = oldArtifact.getAttribute(key);
            String newArtifactAttribute = newArtifact.getAttribute(key);
            if (newArtifactAttribute != null) {
                if (newArtifactAttribute.equals(oldArtifactAttribute)) continue;
                return false;
            }
            String msg = "Value for required attribute " + key + " found empty.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return true;
    }

    public static String[] getPathsFromPathExpression(String pathExpression, GovernanceArtifact artifact) throws GovernanceException {
        String expression = GovernanceUtils.replaceNameAndNamespace(pathExpression, artifact);
        String[] elements = expression.split("@");
        for (int i = 1; i < elements.length; ++i) {
            String key;
            String artifactAttribute;
            if (elements[i].indexOf(SYMBOL_COLON) > 0 || elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0 || (artifactAttribute = artifact.getAttribute(key = elements[i].split("}")[0].substring(1))) == null) continue;
            expression = expression.replace("@{" + key + "}", artifactAttribute);
        }
        List<String> output = GovernanceUtils.fixExpressionForMultiplePaths(artifact, expression);
        return output.toArray(new String[output.size()]);
    }

    private static List<String> fixExpressionForMultiplePaths(GovernanceArtifact artifact, String expression) throws GovernanceException {
        if (!expression.contains("@")) {
            return Collections.singletonList(expression);
        }
        LinkedList<String> output = new LinkedList<String>();
        String[] elements = expression.split("@");
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1).split(SYMBOL_COLON)[0];
            String[] artifactAttributes = artifact.getAttributes(key);
            if (artifactAttributes == null) break;
            for (String artifactAttribute : artifactAttributes) {
                String[] parts = artifactAttribute.split(SYMBOL_COLON);
                if (parts.length <= 1) continue;
                output.addAll(GovernanceUtils.fixExpressionForMultiplePaths(artifact, expression.replace("@{" + key + ":key}", parts[0]).replace("@{" + key + ":value}", parts[1])));
            }
            break;
        }
        return output;
    }

    private static String replaceNameAndNamespace(String pathExpression, GovernanceArtifact artifact) {
        String output = pathExpression;
        QName qName = artifact.getQName();
        if (qName != null) {
            output = output.replace("@{name}", qName.getLocalPart());
            String replacement = CommonUtil.derivePathFragmentFromNamespace((String)qName.getNamespaceURI());
            if (replacement.startsWith("/")) {
                replacement = replacement.substring(1);
            }
            if (replacement.endsWith("/")) {
                replacement = replacement.substring(0, replacement.length() - 1);
            }
            output = output.replace("@{namespace}", replacement);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableAspects() throws RegistryException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry systemRegistry = registryService.getConfigSystemRegistry(tenantId);
        String[] aspectsToAdd = systemRegistry.getAvailableAspects();
        if (aspectsToAdd == null) {
            return new String[0];
        }
        LinkedList<String> lifecycleAspectsToAdd = new LinkedList<String>();
        boolean isTransactionStarted = false;
        String tempResourcePath = "/governance/lcm/" + UUIDGenerator.generateUUID();
        for (String aspectToAdd : aspectsToAdd) {
            Boolean isLifecycleAspect;
            Map<String, Boolean> aspectsMap;
            if (systemRegistry.getRegistryContext().isReadOnly()) {
                lifecycleAspectsToAdd.add(aspectToAdd);
                continue;
            }
            if (!lifecycleAspects.containsKey(tenantId)) {
                Object object = ASPECT_MAP_LOCK;
                synchronized (object) {
                    if (!lifecycleAspects.containsKey(tenantId)) {
                        aspectsMap = new HashMap<String, Boolean>();
                        lifecycleAspects.put(tenantId, aspectsMap);
                    } else {
                        aspectsMap = lifecycleAspects.get(tenantId);
                    }
                }
            } else {
                aspectsMap = lifecycleAspects.get(tenantId);
            }
            if ((isLifecycleAspect = aspectsMap.get(aspectToAdd)) == null) {
                if (!isTransactionStarted) {
                    systemRegistry.beginTransaction();
                    isTransactionStarted = true;
                }
                systemRegistry.put(tempResourcePath, systemRegistry.newResource());
                systemRegistry.associateAspect(tempResourcePath, aspectToAdd);
                Resource r = systemRegistry.get(tempResourcePath);
                Properties props = r.getProperties();
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    String propKey = (String)key;
                    if (!propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.custom_lifecycle.checklist.")) continue;
                    isLifecycleAspect = Boolean.TRUE;
                    break;
                }
                if (isLifecycleAspect == null) {
                    isLifecycleAspect = Boolean.FALSE;
                }
                aspectsMap.put(aspectToAdd, isLifecycleAspect);
            }
            if (!isLifecycleAspect.booleanValue()) continue;
            lifecycleAspectsToAdd.add(aspectToAdd);
        }
        if (isTransactionStarted) {
            systemRegistry.delete(tempResourcePath);
            systemRegistry.rollbackTransaction();
        }
        return lifecycleAspectsToAdd.toArray(new String[lifecycleAspectsToAdd.size()]);
    }

    public static String derivePathFromQName(QName qName) {
        String serviceName = qName.getLocalPart();
        String serviceNamespace = qName.getNamespaceURI();
        return (serviceNamespace == null ? "" : CommonUtil.derivePathFragmentFromNamespace((String)serviceNamespace)) + serviceName;
    }

    public static String getNameFromUrl(String url) {
        int slashIndex = url.lastIndexOf(47);
        if (slashIndex == -1) {
            return url;
        }
        if (slashIndex == url.length() - 1) {
            return url.substring(0, url.length() - 1);
        }
        return url.substring(slashIndex + 1);
    }

    public static List<OMElement> evaluateXPathToElements(String expression, OMElement root) throws JaxenException {
        String[] wsdlPrefixes = new String[]{"wsdl", "http://schemas.xmlsoap.org/wsdl/", "wsdl2", "http://www.w3.org/ns/wsdl", "xsd", "http://www.w3.org/2001/XMLSchema", "soap", "http://schemas.xmlsoap.org/wsdl/soap/", "soap12", "http://schemas.xmlsoap.org/wsdl/soap12/", "http", "http://schemas.xmlsoap.org/wsdl/http/"};
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < wsdlPrefixes.length; ++j) {
            xpathExpression.addNamespace(wsdlPrefixes[j++], wsdlPrefixes[j]);
        }
        return xpathExpression.selectNodes((Object)root);
    }

    public static void associateAspect(String path, String aspect, Registry registry) throws RegistryException {
        try {
            registry.associateAspect(path, aspect);
            Resource resource = registry.get(path);
            if (resource.getAspects().size() == 1) {
                resource.setProperty("registry.LC.name", aspect);
                registry.put(path, resource);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to associate aspect with the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static void removeAspect(String path, String aspect, Registry registry) throws RegistryException {
        try {
            Resource resource = registry.get(path);
            Properties props = resource.getProperties();
            Iterator<Object> iKeys = props.keySet().iterator();
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            while (iKeys.hasNext()) {
                String propKey = (String)iKeys.next();
                if (!GovernanceUtils.isStartsWithRegistry(propKey) || !propKey.contains(aspect)) continue;
                propertiesToRemove.add(propKey);
            }
            for (String propertyName : propertiesToRemove) {
                resource.removeProperty(propertyName);
            }
            resource.removeAspect(aspect);
            if (resource.getProperty("registry.LC.name").equals(aspect)) {
                resource.removeProperty("registry.LC.name");
                if (resource.getAspects().size() > 0) {
                    resource.setProperty("registry.LC.name", (String)resource.getAspects().get(0));
                }
            }
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Failed to remove aspect " + aspect + " on resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    private static boolean isStartsWithRegistry(String propKey) {
        return propKey.startsWith("registry.custom_lifecycle.votes.") || propKey.startsWith("registry.custom_lifecycle.user.") || propKey.startsWith("registry.custom_lifecycle.checklist.") || propKey.startsWith("registry.LC.name") || propKey.startsWith("registry.lifecycle.") || propKey.startsWith("registry.Aspects");
    }

    public static AttributeSearchService getAttributeSearchService() {
        return attributeSearchService;
    }

    public static void setAttributeSearchService(AttributeSearchService attributeSearchService) {
        GovernanceUtils.attributeSearchService = attributeSearchService;
    }

    public static TermsSearchService getTermsSearchService() {
        return termsSearchService;
    }

    public static void setTermsSearchService(TermsSearchService termsSearchService) {
        GovernanceUtils.termsSearchService = termsSearchService;
    }

    public static ContentSearchService getContentSearchService() {
        return contentSearchService;
    }

    public static void setContentSearchService(ContentSearchService contentSearchService) {
        GovernanceUtils.contentSearchService = contentSearchService;
    }

    public static TermsQuerySearchService getTermsQuerySearchService() {
        return termsQuerySearchService;
    }

    public static void setTermsQuerySearchService(TermsQuerySearchService termsQuerySearchService) {
        GovernanceUtils.termsQuerySearchService = termsQuerySearchService;
    }

    public static void setDefaultLifeCycle(String path, String aspect, Registry registry) throws RegistryException {
        Resource resource = registry.get(path);
        if (resource != null) {
            resource.setProperty("registry.LC.name", aspect);
            registry.put(path, resource);
        }
    }

    public static List<GovernanceArtifact> findGovernanceArtifacts(Map<String, List<String>> criteria, Registry registry, String mediaType) throws GovernanceException {
        if (GovernanceUtils.getAttributeSearchService() == null) {
            throw new GovernanceException("Attribute Search Service not Found");
        }
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        HashMap<String, String> fields = new HashMap<String, String>();
        if (mediaType != null) {
            fields.put("mediaType", mediaType);
        }
        for (Map.Entry<String, List<String>> e : criteria.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String referenceValue : e.getValue()) {
                if (referenceValue == null || "".equals(referenceValue)) continue;
                String referenceValueModified = referenceValue;
                if (referenceValueModified.contains(" ")) {
                    referenceValueModified = referenceValueModified.replace(" ", "\\ ");
                }
                builder.append(referenceValueModified.toLowerCase()).append(",");
            }
            if (builder.length() <= 0) continue;
            fields.put(e.getKey(), builder.substring(0, builder.length() - 1));
        }
        try {
            ResourceData[] results = (ResourceData[])GovernanceUtils.getAttributeSearchService().search(fields);
            int errorCount = 0;
            for (ResourceData result : results) {
                GovernanceArtifact governanceArtifact = null;
                String path = result.getResourcePath().substring("/_system/governance".length());
                try {
                    governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, path);
                }
                catch (GovernanceException e) {
                    ++errorCount;
                    log.error((Object)("Error occurred while retrieving governance artifact by path : " + path), (Throwable)((Object)e));
                }
                if (governanceArtifact == null) continue;
                artifacts.add(governanceArtifact);
            }
            if (errorCount != 0 && errorCount == results.length) {
                throw new GovernanceException("Error occurred while retrieving all the governance artifacts");
            }
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to search by attribute", e);
        }
        return artifacts;
    }

    private static String buildSearchCriteria(String criteria, Registry registry, String mediaType, Map<String, String> possibleProperties, Map<String, String> fields, boolean hasOneProperty) throws GovernanceException {
        GovernanceArtifactConfiguration artifactConfiguration;
        String editedCriteria = "";
        try {
            if (criteria != null) {
                editedCriteria = URLDecoder.decode(criteria, "utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new GovernanceException("Error occurred while decoding the query params");
        }
        if (mediaType != null && !"".equals(mediaType)) {
            fields.put("mediaType", mediaType);
        } else if ("".equals(criteria)) {
            return null;
        }
        try {
            artifactConfiguration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType(mediaType, registry);
        }
        catch (RegistryException e) {
            throw new GovernanceException(e);
        }
        List<String> possibleKeys = Arrays.asList("createdAfter", "createdBefore", "updatedAfter", "updatedBefore", "author", "author!", "associationType", "associationDest", "updater", "updater!", "tags", "taxonomy", "content", "mediaType", "mediaType!", "lcName", "lcState", "group", "group.sort", "group.field", "group.ngroups", "group.format");
        ArrayList<String> finalTempList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)criteria)) {
            String[] tempList = criteria.split(SYMBOL_AND);
            for (int i = 0; i < tempList.length; ++i) {
                try {
                    finalTempList.add(URLDecoder.decode(tempList[i], "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new GovernanceException("Error occurred while decoding the query params");
                }
            }
        }
        for (String temp : finalTempList) {
            String value;
            String[] subParts = temp.split(SYMBOL_EQUAL);
            if (subParts.length != 2) {
                value = subParts[0].toLowerCase();
                if (value.contains(" ")) {
                    value = value.replace(" ", "\\ ");
                }
                fields.put("overview_name", value);
                continue;
            }
            if (possibleKeys.contains(subParts[0])) {
                switch (subParts[0]) {
                    case "author!": {
                        fields.put(subParts[0].substring(0, subParts[0].length() - 1), subParts[1].toLowerCase());
                        fields.put("authorNameNegate", "on");
                        break;
                    }
                    case "updater!": {
                        fields.put(subParts[0].substring(0, subParts[0].length() - 1), subParts[1].toLowerCase());
                        fields.put("updaterNameNegate", "on");
                        break;
                    }
                    case "mediaType!": {
                        fields.put(subParts[0].substring(0, subParts[0].length() - 1), subParts[1].toLowerCase());
                        fields.put("mediaTypeNegate", "on");
                        break;
                    }
                    case "tags": {
                        fields.put(subParts[0], subParts[1]);
                        break;
                    }
                    case "associationType": 
                    case "taxonomy": {
                        String taxaValue = subParts[1].toLowerCase().replaceAll("\\* (and|AND) \\*", "* && *").replaceAll("\\) (and|AND) \\(", ") && (").replaceAll("\\* (and|AND) \\(", "* && (").replaceAll("\\) (and|AND) \\*", ") && *");
                        fields.put(subParts[0], taxaValue);
                        editedCriteria = editedCriteria.replace(subParts[1], taxaValue);
                        break;
                    }
                    case "associationDest": {
                        fields.put(subParts[0], subParts[1]);
                        break;
                    }
                    case "group.field": {
                        fields.put(subParts[0], "overview_" + subParts[1]);
                        break;
                    }
                    case "group.sort": {
                        String groupSortBy = subParts[1];
                        fields.put(subParts[0], "overview_" + groupSortBy);
                        editedCriteria = editedCriteria.replace(subParts[1], groupSortBy);
                        break;
                    }
                    default: {
                        String value2 = subParts[1].toLowerCase();
                        value2 = GovernanceUtils.buildSearchValue(value2);
                        fields.put(subParts[0], value2);
                        editedCriteria = editedCriteria.replace(subParts[1], value2);
                        break;
                    }
                }
                continue;
            }
            if (subParts[0].equals("comments")) {
                fields.put("commentWords", subParts[1].toLowerCase());
                editedCriteria = editedCriteria.replace("comments", "commentWords");
                editedCriteria = editedCriteria.replace(subParts[1], subParts[1].toLowerCase());
                continue;
            }
            if (subParts[0].contains(SYMBOL_COLON)) {
                value = subParts[1].toLowerCase();
                value = GovernanceUtils.buildSearchValue(value);
                String[] tableParts = subParts[0].split(SYMBOL_COLON);
                if (OVERVIEW.equals(tableParts[0])) {
                    if (!hasOneProperty || possibleProperties.size() == 0) {
                        possibleProperties.put(tableParts[1], value);
                    }
                    String overviewField = tableParts[1] + SYMBOL_COLON + value + REPLACEMENT_OR_SEARCH;
                    editedCriteria = new StringBuilder(editedCriteria).insert(editedCriteria.lastIndexOf(subParts[0]), overviewField).toString();
                }
                fields.put(subParts[0].replace(SYMBOL_COLON, UNDERSCORE), value);
                editedCriteria = editedCriteria.replace(subParts[0], subParts[0].replace(SYMBOL_COLON, UNDERSCORE));
                editedCriteria = editedCriteria.replace(subParts[1], value);
                continue;
            }
            value = subParts[1].toLowerCase();
            value = GovernanceUtils.buildSearchValue(value);
            if (!subParts[0].equals("name")) {
                if (!hasOneProperty || possibleProperties.size() == 0) {
                    possibleProperties.put(subParts[0], value);
                    fields.put("overview_" + subParts[0], value);
                } else if (GovernanceUtils.isMultiValueField(mediaType, subParts[0])) {
                    fields.put(subParts[0], value);
                } else {
                    fields.put("overview_" + subParts[0], value);
                }
                editedCriteria = editedCriteria.replace(subParts[1], value);
                String overviewField = "overview_" + subParts[0] + SYMBOL_COLON + value + REPLACEMENT_OR_SEARCH;
                editedCriteria = new StringBuilder(editedCriteria).insert(editedCriteria.lastIndexOf(subParts[0]), overviewField).toString();
                continue;
            }
            if (artifactConfiguration != null) {
                fields.put(artifactConfiguration.getArtifactNameAttribute(), value);
                editedCriteria = editedCriteria.replace(subParts[0], artifactConfiguration.getArtifactNameAttribute());
                editedCriteria = editedCriteria.replace(subParts[1], value);
                continue;
            }
            fields.put("overview_" + subParts[0], value);
            editedCriteria = editedCriteria.replace(subParts[0], "overview_" + subParts[0]);
            editedCriteria = editedCriteria.replace(subParts[1], value);
        }
        return editedCriteria;
    }

    private static String buildSearchValue(String value) {
        if (value.contains(" or ")) {
            Object[] values = value.split(" or ");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].contains(" or")) continue;
                values[i] = ((String)values[i]).trim().replace(" ", "\\ ");
            }
            value = StringUtils.join((Object[])values, (String)REPLACEMENT_OR_SEARCH);
        } else if (value.contains(" and ")) {
            Object[] values = value.split(" and ");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].contains(" and")) continue;
                values[i] = ((String)values[i]).trim().replace(" ", "\\ ");
            }
            value = StringUtils.join((Object[])values, (String)REPLACEMENT_SYMBOL_AND);
        } else if (value.contains(" ") && !value.contains(" or")) {
            value = value.replace(" ", "\\ ");
        }
        return value;
    }

    public static List<GovernanceArtifact> findGovernanceArtifacts(String criteria, Registry registry, String mediaType) throws GovernanceException {
        return GovernanceUtils.findGovernanceArtifacts(criteria, registry, mediaType, false);
    }

    public static List<GovernanceArtifact> findGovernanceArtifacts(String criteria, Registry registry, String mediaType, boolean hasOneProperty) throws GovernanceException {
        HashMap<String, String> possibleProperties = new HashMap<String, String>();
        HashMap<String, String> fields = new HashMap<String, String>();
        String editedCriteria = GovernanceUtils.buildSearchCriteria(criteria, registry, mediaType, possibleProperties, fields, hasOneProperty);
        if (editedCriteria != null && (editedCriteria.contains(FIELDS_OR_WILD_SEARCH) || editedCriteria.contains(FIELDS_OR_SEARCH))) {
            editedCriteria = editedCriteria.replace(FIELDS_OR_WILD_SEARCH, REPLACEMENT_OR_WILD_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_AND_WILD_SEARCH, REPLACEMENT_AND_WILD_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_OR_SEARCH, REPLACEMENT_OR_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_AND_SEARCH, REPLACEMENT_AND_SEARCH);
            editedCriteria = editedCriteria.replace(SYMBOL_AND, REPLACEMENT_SYMBOL_AND);
            editedCriteria = editedCriteria.replace(SYMBOL_EQUAL, SYMBOL_COLON);
            editedCriteria = "(" + editedCriteria + ") AND mediaType:" + mediaType;
            log.debug((Object)("Content OR search | Search Criteria::: " + editedCriteria));
            return GovernanceUtils.performContentSearch(editedCriteria, registry);
        }
        List<GovernanceArtifact> attributeSearchResults = GovernanceUtils.performAttributeSearch(fields, registry);
        if (possibleProperties.size() == 1) {
            int paginationSizeAtt = 0;
            if (PaginationContext.getInstance() != null) {
                paginationSizeAtt = PaginationContext.getInstance().getLength();
            }
            for (Map.Entry entry : possibleProperties.entrySet()) {
                String propertyName = (String)entry.getKey();
                fields.remove("overview_" + propertyName);
                fields.put("propertyName", propertyName);
                fields.put("rightPropertyValue", (String)entry.getValue());
                fields.put("rightOp", "eq");
            }
            List<GovernanceArtifact> propertySearchResults = GovernanceUtils.performAttributeSearch(fields, registry);
            TreeSet<GovernanceArtifact> removeDuplicate = new TreeSet<GovernanceArtifact>(new Comparator<GovernanceArtifact>(){

                @Override
                public int compare(GovernanceArtifact artifact1, GovernanceArtifact artifact2) {
                    return artifact1.getId().compareTo(artifact2.getId());
                }
            });
            removeDuplicate.addAll(attributeSearchResults);
            removeDuplicate.addAll(propertySearchResults);
            ArrayList<GovernanceArtifact> mergeListWithoutDuplicates = new ArrayList<GovernanceArtifact>();
            mergeListWithoutDuplicates.addAll(removeDuplicate);
            TreeSet<GovernanceArtifact> set = new TreeSet<GovernanceArtifact>(new Comparator<GovernanceArtifact>(){

                @Override
                public int compare(GovernanceArtifact artifact1, GovernanceArtifact artifact2) {
                    PaginationContext paginationContext = PaginationContext.getInstance();
                    if (paginationContext != null) {
                        String sortBy = paginationContext.getSortBy();
                        String sortOrder = paginationContext.getSortOrder();
                        try {
                            if (StringUtils.isNotBlank((String)sortBy) && StringUtils.isNotBlank((String)sortOrder)) {
                                switch (sortOrder) {
                                    case "ASC": {
                                        return this.comparison(artifact1.getAttribute(sortBy), artifact2.getAttribute(sortBy), sortBy);
                                    }
                                    case "DES": 
                                    case "DESC": {
                                        return this.comparison(artifact2.getAttribute(sortBy), artifact1.getAttribute(sortBy), sortBy);
                                    }
                                }
                                return artifact1.getId().compareTo(artifact2.getId());
                            }
                        }
                        catch (GovernanceException e) {
                            log.error((Object)"Error when trying to compare the sortBy attributes of the returned artifacts.", (Throwable)((Object)e));
                        }
                    }
                    return artifact1.getId().compareTo(artifact2.getId());
                }

                private int comparison(String value1, String value2, String sortBy) throws GovernanceException {
                    if ("createdDate".equals(sortBy) || "lastUpdatedDate".equals(sortBy)) {
                        return 1;
                    }
                    if (StringUtils.isEmpty((String)value1)) {
                        throw new GovernanceException("Artifact does not contain the attribute " + sortBy);
                    }
                    int comparisonValue = value1.compareTo(value2);
                    if (comparisonValue == 0) {
                        return -1;
                    }
                    return comparisonValue;
                }
            });
            set.addAll(mergeListWithoutDuplicates);
            ArrayList<GovernanceArtifact> sortedList = new ArrayList<GovernanceArtifact>();
            sortedList.addAll(set);
            if (paginationSizeAtt != 0 && PaginationContext.getInstance() != null) {
                int reduce = 0;
                if (mergeListWithoutDuplicates.size() != 0 && mergeListWithoutDuplicates.size() != attributeSearchResults.size() + propertySearchResults.size()) {
                    reduce = attributeSearchResults.size() + propertySearchResults.size() - mergeListWithoutDuplicates.size();
                }
                int paginationSizePros = PaginationContext.getInstance().getLength();
                PaginationContext.getInstance().setLength(paginationSizeAtt + paginationSizePros - reduce);
            }
            return sortedList;
        }
        return attributeSearchResults;
    }

    private static List<GovernanceArtifact> performAttributeSearch(Map<String, String> fields, Registry registry) throws GovernanceException {
        if (GovernanceUtils.getAttributeSearchService() == null) {
            throw new GovernanceException("Attribute Search Service not Found");
        }
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        try {
            ResourceData[] results = (ResourceData[])GovernanceUtils.getAttributeSearchService().search(fields);
            int errorCount = 0;
            for (ResourceData result : results) {
                GovernanceArtifact governanceArtifact = null;
                String path = result.getResourcePath().substring("/_system/governance".length());
                try {
                    governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, path);
                }
                catch (GovernanceException e) {
                    ++errorCount;
                    log.error((Object)("Error occurred while retrieving governance artifact by path : " + path), (Throwable)((Object)e));
                }
                if (governanceArtifact == null) continue;
                artifacts.add(governanceArtifact);
            }
            if (errorCount != 0 && errorCount == results.length) {
                throw new GovernanceException("Error occurred while retrieving all the governance artifacts");
            }
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to search by attribute", e);
        }
        return artifacts;
    }

    private static List<GovernanceArtifact> performContentSearch(String criteria, Registry registry) throws GovernanceException {
        if (GovernanceUtils.getContentSearchService() == null) {
            throw new GovernanceException("Content Search Service not Found");
        }
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        try {
            ResourceData[] results = (ResourceData[])GovernanceUtils.getContentSearchService().search((Object)criteria);
            int errorCount = 0;
            for (ResourceData result : results) {
                GovernanceArtifact governanceArtifact = null;
                String path = result.getResourcePath().substring("/_system/governance".length());
                try {
                    governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, path);
                }
                catch (GovernanceException e) {
                    ++errorCount;
                    log.error((Object)("Error occurred while retrieving governance artifact by path : " + path), (Throwable)((Object)e));
                }
                if (governanceArtifact == null) continue;
                artifacts.add(governanceArtifact);
            }
            if (errorCount != 0 && errorCount == results.length) {
                throw new GovernanceException("Error occurred while retrieving all the governance artifacts");
            }
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to search by attribute", e);
        }
        return artifacts;
    }

    public static List<TermData> getTermDataList(Map<String, List<String>> criteria, String facetField, String mediaType, boolean authRequired) throws GovernanceException {
        if (GovernanceUtils.getTermsSearchService() == null) {
            throw new GovernanceException("Term Search Service not Found");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        if (mediaType != null) {
            fields.put("mediaType", mediaType);
        }
        for (Map.Entry<String, List<String>> e : criteria.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String referenceValue : e.getValue()) {
                if (referenceValue == null || "".equals(referenceValue)) continue;
                String referenceValueModified = referenceValue.replace(" ", "\\ ");
                if ((referenceValueModified = referenceValueModified.toLowerCase()).contains("*\\ ")) {
                    referenceValueModified = referenceValueModified.replace("*\\ ", "* ");
                }
                if (referenceValueModified.contains("\\ *")) {
                    referenceValueModified = referenceValueModified.replace("\\ *", " *");
                }
                referenceValueModified = referenceValueModified.replaceAll("\\sand\\s", " && ");
                builder.append(referenceValueModified).append(',');
            }
            if (builder.length() <= 0) continue;
            fields.put(e.getKey(), builder.substring(0, builder.length() - 1));
        }
        fields.put("authenticate.required", String.valueOf(authRequired));
        if (facetField == null) {
            throw new GovernanceException("Facet field is required. field cannot be null");
        }
        fields.put("facet.field", facetField);
        try {
            TermData[] termData = (TermData[])GovernanceUtils.getTermsSearchService().search(fields);
            return Arrays.asList(termData);
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to get terms for the given field", e);
        }
    }

    public static List<TermData> getTermDataList(String criteria, String facetField, String mediaType, Registry registry) throws GovernanceException {
        if (GovernanceUtils.getTermsSearchService() == null) {
            throw new GovernanceException("Term Search Service not Found");
        }
        HashMap<String, String> possibleProperties = new HashMap<String, String>();
        HashMap<String, String> fields = new HashMap<String, String>();
        String editedCriteria = GovernanceUtils.buildSearchCriteria(criteria, registry, mediaType, possibleProperties, fields, false);
        if (editedCriteria != null && (editedCriteria.contains(FIELDS_OR_WILD_SEARCH) || editedCriteria.contains(FIELDS_OR_SEARCH))) {
            if (GovernanceUtils.getTermsQuerySearchService() == null) {
                throw new GovernanceException("Term Query Search Service not Found");
            }
            editedCriteria = editedCriteria.replace(FIELDS_OR_WILD_SEARCH, REPLACEMENT_OR_WILD_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_AND_WILD_SEARCH, REPLACEMENT_AND_WILD_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_OR_SEARCH, REPLACEMENT_OR_SEARCH);
            editedCriteria = editedCriteria.replace(FIELDS_AND_SEARCH, REPLACEMENT_AND_SEARCH);
            editedCriteria = editedCriteria.replace(SYMBOL_AND, REPLACEMENT_SYMBOL_AND);
            editedCriteria = editedCriteria.replace(SYMBOL_EQUAL, SYMBOL_COLON);
            editedCriteria = "(" + editedCriteria + ") AND mediaType:" + mediaType;
            log.debug((Object)("Content OR search | Search Criteria::: " + editedCriteria));
            try {
                TermData[] termData = GovernanceUtils.getTermsQuerySearchService().search(editedCriteria, facetField);
                return Arrays.asList(termData);
            }
            catch (RegistryException e) {
                throw new GovernanceException("Unable to get terms for the given field", e);
            }
        }
        if (facetField == null) {
            throw new GovernanceException("Facet field is required. field cannot be null");
        }
        fields.put("facet.field", facetField);
        try {
            TermData[] termData = (TermData[])GovernanceUtils.getTermsSearchService().search(fields);
            if (possibleProperties.size() == 1) {
                for (Map.Entry entry : possibleProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    fields.remove("overview_" + propertyName);
                    fields.put("propertyName", propertyName);
                    fields.put("rightPropertyValue", (String)entry.getValue());
                    fields.put("rightOp", "eq");
                }
                TermData[] propertytermData = (TermData[])GovernanceUtils.getTermsSearchService().search(fields);
                TreeSet<TermData> removeDuplicate = new TreeSet<TermData>(new Comparator<TermData>(){

                    @Override
                    public int compare(TermData term1, TermData term2) {
                        return term1.getTerm().compareTo(term2.getTerm());
                    }
                });
                removeDuplicate.addAll(Arrays.asList(termData));
                removeDuplicate.addAll(Arrays.asList(propertytermData));
                ArrayList<TermData> mergeListWithoutDuplicates = new ArrayList<TermData>();
                mergeListWithoutDuplicates.addAll(removeDuplicate);
                return mergeListWithoutDuplicates;
            }
            return Arrays.asList(termData);
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to get terms for the given field", e);
        }
    }

    public static Cache<String, Boolean> getRXTConfigCache(String name) {
        Cache cache;
        CacheManager manager = GovernanceUtils.getCacheManager();
        Cache cache2 = cache = manager != null ? manager.getCache(name) : Caching.getCacheManager().getCache(name);
        if (rxtCacheInitiated) {
            cache.registerCacheEntryListener(entryCreatedListener);
            cache.registerCacheEntryListener(entryUpdatedListener);
            cache.registerCacheEntryListener(entryRemovedListener);
            rxtCacheInitiated = true;
        }
        return cache;
    }

    private static CacheManager getCacheManager() {
        return Caching.getCacheManagerFactory().getCacheManager("registryCacheManager");
    }

    public static void removeArtifactFromPath(Registry registry, String path) throws GovernanceException {
        try {
            ArtifactCache artifactCache;
            if (registry.resourceExists(path)) {
                GovernanceUtils.deleteLifecycleHistoryFile(path, registry);
                registry.delete(path);
            }
            if ((artifactCache = ArtifactCacheManager.getCacheManager().getTenantArtifactCache(((UserRegistry)registry).getTenantId())) != null && path != null && artifactCache.getArtifact(path) != null) {
                artifactCache.invalidateArtifact(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in deleting the the artifact path:" + path + ".";
            throw new GovernanceException(msg, e);
        }
    }

    public static List<String> getUniqueAttributesNames(Registry registry, String mediaType) throws GovernanceException {
        try {
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType(mediaType, registry);
            if (configuration != null) {
                return configuration.getUniqueAttributes();
            }
        }
        catch (RegistryException e) {
            throw new GovernanceException(e);
        }
        return null;
    }

    public static void CheckMandatoryFields(Registry registry, String elementString, GovernanceArtifact artifact) throws GovernanceException {
        if (artifact instanceof WsdlImpl || artifact instanceof SchemaImpl || artifact instanceof PolicyImpl) {
            return;
        }
        GovernanceArtifactConfiguration configuration = null;
        try {
            configuration = GovernanceUtils.findGovernanceArtifactConfiguration(elementString, registry);
        }
        catch (RegistryException e) {
            throw new GovernanceException("Retrieving RXT configuration for type :" + elementString + "failed.", e);
        }
        if (configuration == null) {
            throw new GovernanceException("Could not find RXT configuration for type :" + elementString);
        }
        List<Map> mandatoryAttributes = configuration.getMandatoryAttributes();
        if (mandatoryAttributes == null) {
            return;
        }
        for (int i = 0; i < mandatoryAttributes.size(); ++i) {
            int j;
            Map map = mandatoryAttributes.get(i);
            String prop = (String)map.get("properties");
            List keys = (List)map.get("keys");
            if (prop != null && "unbounded".equals(prop)) {
                String[] values = artifact.getAttributes((String)keys.get(0));
                if (values == null) continue;
                for (j = 0; j < values.length; ++j) {
                    if (values[j] != null && !"".equals(values[j])) continue;
                    throw new GovernanceException((String)map.get("name") + " is a required field, Please provide a value for this parameter.");
                }
                continue;
            }
            String value = "";
            for (j = 0; j < keys.size(); ++j) {
                String v = artifact.getAttribute((String)keys.get(j));
                if (j != 0) {
                    value = value + SYMBOL_COLON;
                }
                value = value + (v == null ? "" : v);
            }
            if (value != null && !"".equals(value)) continue;
            throw new GovernanceException((String)map.get("name") + " is a required field, Please provide a value for this parameter.");
        }
    }

    private static void deleteLifecycleHistoryFile(String artifactPath, Registry registry) throws GovernanceException {
        String artifactRootPath = "/_system/governance" + artifactPath;
        String historyResourcePath = "/repository/components/org.wso2.carbon.governance/lifecycles/history/" + artifactRootPath.replaceAll("/", UNDERSCORE);
        try {
            Registry govRegistry;
            if (registryService != null) {
                int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                govRegistry = registryService.getGovernanceSystemRegistry(tenantId);
            } else {
                govRegistry = registry;
            }
            if (govRegistry.resourceExists(historyResourcePath)) {
                govRegistry.delete(historyResourcePath);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in deleting the the lifecycle history file at: " + historyResourcePath + ".";
            throw new GovernanceException(msg, e);
        }
    }

    public static boolean isMultiValueField(String mediaType, String fieldKey) {
        List fields;
        Map rxtDetails;
        Map allTenantsUnboundedFields = RxtUnboundedFieldManagerService.getInstance().getTenantsUnboundedFields();
        if (allTenantsUnboundedFields.size() > 0 && (rxtDetails = (Map)allTenantsUnboundedFields.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) != null && (fields = (List)rxtDetails.get(mediaType)) != null) {
            return fields.contains(fieldKey);
        }
        return false;
    }

    static {
        artifactConfigurations = new HashMap<Integer, List<GovernanceArtifactConfiguration>>();
        lifecycleAspects = new HashMap<Integer, Map<String, Boolean>>();
        ASPECT_MAP_LOCK = new Object();
        tenantGovernanceSystemRegistry = new ThreadLocal();
        entryCreatedListener = new RXTConfigCacheEntryCreatedListener();
        entryRemovedListener = new RXTConfigCacheEntryRemovedListener();
        entryUpdatedListener = new RXTConfigCacheEntryUpdatedListener();
        rxtCacheInitiated = false;
    }
}

