/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.aspects.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.beans.ApprovalBean;
import org.wso2.carbon.governance.registry.extensions.beans.CheckItemBean;
import org.wso2.carbon.governance.registry.extensions.beans.CustomCodeBean;
import org.wso2.carbon.governance.registry.extensions.beans.InputBean;
import org.wso2.carbon.governance.registry.extensions.beans.PermissionsBean;
import org.wso2.carbon.governance.registry.extensions.beans.ScriptBean;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.registry.core.Resource;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static OMElement getHistoryInfoElement(String text) {
        try {
            String template = "<info></info>";
            OMElement infoElement = AXIOMUtil.stringToOM((String)template);
            infoElement.setText(text);
            return infoElement;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to build the lifecycle history info element");
            return null;
        }
    }

    public static CustomValidations loadCustomValidators(String className, Map parameterMap) throws Exception {
        CustomValidations customValidations;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> customCodeClass = Class.forName(className, true, loader);
            customValidations = (CustomValidations)customCodeClass.newInstance();
            customValidations.init(parameterMap);
        }
        catch (Exception e) {
            String msg = "Unable to load validations class";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return customValidations;
    }

    public static Execution loadCustomExecutors(String className, Map parameterMap) throws Exception {
        Execution customExecutors;
        try {
            Class<?> customCodeClass = Utils.class.getClassLoader().loadClass(className);
            customExecutors = (Execution)customCodeClass.newInstance();
            customExecutors.init(parameterMap);
        }
        catch (Exception e) {
            String msg = "Unable to load executions class";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return customExecutors;
    }

    public static PermissionsBean createPermissionBean(OMElement permChild) {
        PermissionsBean permBean = new PermissionsBean();
        permBean.setForEvent(permChild.getAttributeValue(new QName("forEvent")));
        if (permChild.getAttributeValue(new QName("roles")) != null) {
            permBean.setRoles(Arrays.asList(permChild.getAttributeValue(new QName("roles")).split(",")));
        }
        return permBean;
    }

    public static ApprovalBean createApprovalBean(OMElement permChild) {
        ApprovalBean approveBean = new ApprovalBean();
        approveBean.setForEvent(permChild.getAttributeValue(new QName("forEvent")));
        if (permChild.getAttributeValue(new QName("roles")) != null) {
            String[] roles = permChild.getAttributeValue(new QName("roles")).split(",");
            if (roles.length == 1 && roles[0].equals("")) {
                roles = new String[]{};
            }
            approveBean.setRoles(Arrays.asList(roles));
        }
        if (permChild.getAttributeValue(new QName("votes")) != null) {
            approveBean.setVotes(Integer.parseInt(permChild.getAttributeValue(new QName("votes"))));
        }
        return approveBean;
    }

    public static CustomCodeBean createCustomCodeBean(OMElement customCodeChild, String type) throws Exception {
        CustomCodeBean customCodeBean = new CustomCodeBean();
        HashMap<String, String> paramNameValues = new HashMap<String, String>();
        Iterator parameters = customCodeChild.getChildElements();
        while (parameters.hasNext()) {
            OMElement paramChild = (OMElement)parameters.next();
            if (paramChild.getAttributeValue(new QName("value")) != null) {
                paramNameValues.put(paramChild.getAttributeValue(new QName("name")), paramChild.getAttributeValue(new QName("value")));
                continue;
            }
            if (!paramChild.getText().equals("")) {
                paramNameValues.put(paramChild.getAttributeValue(new QName("name")), paramChild.getText());
                continue;
            }
            paramNameValues.put(paramChild.getAttributeValue(new QName("name")), paramChild.getFirstElement().toString());
        }
        if (type.equals("validation")) {
            customCodeBean.setClassObeject(Utils.loadCustomValidators(customCodeChild.getAttributeValue(new QName("class")), paramNameValues));
        } else if (type.equals("execution")) {
            customCodeBean.setClassObeject(Utils.loadCustomExecutors(customCodeChild.getAttributeValue(new QName("class")), paramNameValues));
        }
        customCodeBean.setEventName(customCodeChild.getAttributeValue(new QName("forEvent")));
        return customCodeBean;
    }

    public static void clearCheckItems(Resource resource, String aspectName) {
        Properties properties = (Properties)resource.getProperties().clone();
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!key.startsWith("registry.custom_lifecycle.checklist.option." + aspectName + ".")) continue;
            resource.removeProperty(key);
        }
    }

    public static void addCheckItems(Resource resource, List<CheckItemBean> currentStateCheckItems, String state, String aspectName) {
        if (currentStateCheckItems != null) {
            int order = 0;
            for (CheckItemBean currentStateCheckItem : currentStateCheckItems) {
                List<PermissionsBean> permissions = currentStateCheckItem.getPermissionsBeans();
                ArrayList<String> allowedRoles = new ArrayList<String>();
                for (PermissionsBean permission : permissions) {
                    allowedRoles.addAll(permission.getRoles());
                }
                ArrayList<String> items = new ArrayList<String>();
                items.add("status:" + state);
                items.add("name:" + currentStateCheckItem.getName());
                items.add("value:false");
                items.add("order:" + order);
                String resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.option." + aspectName + "." + order + ".item";
                String resourcePropertyNameForItemPermission = "registry.custom_lifecycle.checklist.option." + aspectName + "." + order + ".item.permission";
                resource.setProperty(resourcePropertyNameForItem, items);
                if (allowedRoles.isEmpty()) {
                    resource.setProperty(resourcePropertyNameForItemPermission, resourcePropertyNameForItemPermission);
                } else {
                    resource.setProperty(resourcePropertyNameForItemPermission, allowedRoles);
                }
                ++order;
            }
        }
    }

    public static void addScripts(String state, Resource resource, List<ScriptBean> scriptList, String aspectName) {
        if (scriptList != null) {
            for (ScriptBean scriptBean : scriptList) {
                if (!scriptBean.isConsole()) continue;
                ArrayList<String> items = new ArrayList<String>();
                items.add(scriptBean.getScript());
                items.add(scriptBean.getFunctionName());
                String resourcePropertyNameForScript = "registry.custom_lifecycle.checklist.js.script.console." + aspectName + "." + state + "." + scriptBean.getEventName();
                resource.setProperty(resourcePropertyNameForScript, items);
            }
        }
    }

    public static void addTransitionUI(Resource resource, Map<String, String> transitionUI, String aspectName) {
        ArrayList<String> tobeRemoved = new ArrayList<String>();
        Properties properties = resource.getProperties();
        for (Object object : properties.keySet()) {
            if (!object.toString().startsWith("registry.custom_lifecycle.checklist.transition.ui." + aspectName)) continue;
            tobeRemoved.add(object.toString());
        }
        for (String string : tobeRemoved) {
            resource.removeProperty(string);
        }
        if (transitionUI != null) {
            for (Map.Entry entry : transitionUI.entrySet()) {
                resource.setProperty("registry.custom_lifecycle.checklist.transition.ui." + aspectName + "." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static void addTransitionInputs(String state, Resource resource, List<InputBean> transitionUI, String aspectName) {
        if (transitionUI != null) {
            ArrayList<String> tobeRemoved = new ArrayList<String>();
            Properties properties = resource.getProperties();
            for (Object object : properties.keySet()) {
                if (!object.toString().startsWith("registry.custom_lifecycle.inputs." + aspectName + "." + state)) continue;
                tobeRemoved.add(object.toString());
            }
            for (String string : tobeRemoved) {
                resource.removeProperty(string);
            }
            int count = 0;
            for (InputBean inputBean : transitionUI) {
                ArrayList<String> items = new ArrayList<String>();
                items.add(inputBean.getForEvent());
                items.add(inputBean.getName());
                items.add(String.valueOf(inputBean.isRequired()));
                items.add(inputBean.getLabel());
                items.add(inputBean.getPlaceHolder());
                items.add(inputBean.getTooltip());
                items.add(inputBean.getRegex());
                String resourcePropertyNameForInput = "registry.custom_lifecycle.inputs." + aspectName + "." + state + "." + count + "." + inputBean.getName();
                resource.setProperty(resourcePropertyNameForInput, items);
                if (inputBean.getValues() == null) continue;
                String resourcePropertyNameForValue = "registry.custom_lifecycle.inputs." + aspectName + "." + state + "." + count + "." + inputBean.getName() + ".value";
                resource.setProperty(resourcePropertyNameForValue, inputBean.getValues());
            }
        }
    }

    public static boolean isTransitionAllowed(String[] roles, List<PermissionsBean> permissionsBeans, String eventName) {
        HashSet<String> permissionSet = new HashSet<String>(Arrays.asList(roles));
        if (permissionsBeans != null) {
            for (PermissionsBean permission : permissionsBeans) {
                if (!permission.getForEvent().equals(eventName) || permission.getRoles() == null) continue;
                List<String> permRoles = permission.getRoles();
                permissionSet.retainAll(permRoles);
            }
        }
        return !permissionSet.isEmpty();
    }

    public static boolean isCheckItemClickAllowed(String[] roles, List<PermissionsBean> permissionsBeans) {
        HashSet<String> permissionSet = new HashSet<String>(Arrays.asList(roles));
        if (permissionsBeans != null) {
            for (PermissionsBean permission : permissionsBeans) {
                if (permission.getRoles() == null) continue;
                List<String> permRoles = permission.getRoles();
                permissionSet.retainAll(permRoles);
            }
        }
        return !permissionSet.isEmpty();
    }

    public static String getCheckItemName(List<String> propValues) {
        String name = null;
        for (String propValue : propValues) {
            if (!propValue.startsWith("name:")) continue;
            name = propValue.split("name:")[1];
        }
        return name;
    }

    public static Map<String, String> extractCheckItemValues(Map<String, String> parameterMap) {
        HashMap<String, String> checkItems = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            if (!entry.getKey().endsWith(".item")) continue;
            checkItems.put(entry.getKey(), entry.getValue());
        }
        return checkItems;
    }

    public static Map<String, String> extractVotesValues(Map<String, String> parameterMap) {
        HashMap<String, String> checkItems = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            if (!entry.getKey().endsWith(".vote")) continue;
            checkItems.put(entry.getKey(), entry.getValue());
        }
        return checkItems;
    }

    public static void populateTransitionExecutors(String currentStateName, OMElement node, Map<String, List<CustomCodeBean>> transitionExecution) throws Exception {
        if (!transitionExecution.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionExecution")) {
            ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
            Iterator executorsIterator = node.getChildElements();
            while (executorsIterator.hasNext()) {
                OMElement executorChild = (OMElement)executorsIterator.next();
                customCodeBeanList.add(Utils.createCustomCodeBean(executorChild, "execution"));
            }
            transitionExecution.put(currentStateName, customCodeBeanList);
        }
    }

    public static void populateTransitionUIs(String currentStateName, OMElement node, Map<String, Map<String, String>> transitionUIs) {
        if (!transitionUIs.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionUI")) {
            HashMap<String, String> uiEventMap = new HashMap<String, String>();
            Iterator uiIterator = node.getChildElements();
            while (uiIterator.hasNext()) {
                OMElement uiElement = (OMElement)uiIterator.next();
                uiEventMap.put(uiElement.getAttributeValue(new QName("forEvent")), uiElement.getAttributeValue(new QName("href")));
            }
            transitionUIs.put(currentStateName, uiEventMap);
        }
    }

    public static void populateTransitionScripts(String currentStateName, OMElement node, Map<String, List<ScriptBean>> scriptElements) {
        if (!scriptElements.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionScripts")) {
            ArrayList<ScriptBean> scriptBeans = new ArrayList<ScriptBean>();
            Iterator scriptIterator = node.getChildElements();
            while (scriptIterator.hasNext()) {
                OMElement script = (OMElement)scriptIterator.next();
                Iterator scriptChildIterator = script.getChildElements();
                while (scriptChildIterator.hasNext()) {
                    OMElement scriptChild = (OMElement)scriptChildIterator.next();
                    scriptBeans.add(new ScriptBean(scriptChild.getQName().getLocalPart().equals("console"), scriptChild.getAttributeValue(new QName("function")), script.getAttributeValue(new QName("forEvent")), scriptChild.getFirstElement().toString()));
                }
            }
            scriptElements.put(currentStateName, scriptBeans);
        }
    }

    public static void populateTransitionInputs(String currentStateName, OMElement node, Map<String, List<InputBean>> inputElements) {
        if (!inputElements.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionInput")) {
            Iterator scriptIterator = node.getChildElements();
            ArrayList<InputBean> inputBeans = new ArrayList<InputBean>();
            while (scriptIterator.hasNext()) {
                OMElement input = (OMElement)scriptIterator.next();
                Iterator scriptChildIterator = input.getChildElements();
                while (scriptChildIterator.hasNext()) {
                    OMElement scriptChild = (OMElement)scriptChildIterator.next();
                    InputBean inputBean = new InputBean(scriptChild.getAttributeValue(new QName("name")), Boolean.parseBoolean(scriptChild.getAttributeValue(new QName("required"))), scriptChild.getAttributeValue(new QName("label")), scriptChild.getAttributeValue(new QName("placeHolder")), scriptChild.getAttributeValue(new QName("tooltip")), scriptChild.getAttributeValue(new QName("regex")), scriptChild.getAttributeValue(new QName("values")), input.getAttributeValue(new QName("forEvent")));
                    inputBeans.add(inputBean);
                }
            }
            inputElements.put(currentStateName, inputBeans);
        }
    }

    public static void populateTransitionPermissions(String currentStateName, OMElement node, Map<String, List<PermissionsBean>> transitionPermission) {
        if (!transitionPermission.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionPermission")) {
            ArrayList<PermissionsBean> permissionsBeanList = new ArrayList<PermissionsBean>();
            Iterator permissionIterator = node.getChildElements();
            while (permissionIterator.hasNext()) {
                OMElement permChild = (OMElement)permissionIterator.next();
                permissionsBeanList.add(Utils.createPermissionBean(permChild));
            }
            transitionPermission.put(currentStateName, permissionsBeanList);
        }
    }

    public static void populateTransitionValidations(String currentStateName, OMElement node, Map<String, List<CustomCodeBean>> transitionValidations) throws Exception {
        if (!transitionValidations.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionValidation")) {
            ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
            Iterator validationsIterator = node.getChildElements();
            while (validationsIterator.hasNext()) {
                OMElement validationChild = (OMElement)validationsIterator.next();
                customCodeBeanList.add(Utils.createCustomCodeBean(validationChild, "validation"));
            }
            transitionValidations.put(currentStateName, customCodeBeanList);
        }
    }

    public static void populateCheckItems(String currentStateName, OMElement node, Map<String, List<CheckItemBean>> checkListItems) throws Exception {
        if (!checkListItems.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("checkItems")) {
            ArrayList<CheckItemBean> checkItems = new ArrayList<CheckItemBean>();
            Iterator checkItemIterator = node.getChildElements();
            while (checkItemIterator.hasNext()) {
                CheckItemBean checkItemBean = new CheckItemBean();
                OMElement childElement = (OMElement)checkItemIterator.next();
                checkItemBean.setName(childElement.getAttributeValue(new QName("name")));
                if (childElement.getAttributeValue(new QName("forEvent")) != null) {
                    checkItemBean.setEvents(Arrays.asList(childElement.getAttributeValue(new QName("forEvent")).split(",")));
                }
                Iterator permissionElementIterator = childElement.getChildrenWithName(new QName("permissions"));
                while (permissionElementIterator.hasNext()) {
                    OMElement permissionElement = (OMElement)permissionElementIterator.next();
                    Iterator permissions = permissionElement.getChildElements();
                    ArrayList<PermissionsBean> permBeanList = new ArrayList<PermissionsBean>();
                    while (permissions.hasNext()) {
                        OMElement permChild = (OMElement)permissions.next();
                        permBeanList.add(Utils.createPermissionBean(permChild));
                    }
                    checkItemBean.setPermissionsBeans(permBeanList);
                }
                Iterator validationsElementIterator = childElement.getChildrenWithName(new QName("validations"));
                while (validationsElementIterator.hasNext()) {
                    ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
                    OMElement validationElement = (OMElement)validationsElementIterator.next();
                    Iterator validations = validationElement.getChildElements();
                    while (validations.hasNext()) {
                        OMElement validationChild = (OMElement)validations.next();
                        customCodeBeanList.add(Utils.createCustomCodeBean(validationChild, "validation"));
                    }
                    checkItemBean.setValidationBeans(customCodeBeanList);
                }
                checkItems.add(checkItemBean);
            }
            if (checkItems.size() > 0) {
                checkListItems.put(currentStateName, checkItems);
            }
        }
    }

    public static void populateTransitionApprovals(String currentStateName, OMElement node, Map<String, List<ApprovalBean>> transitionApproval) {
        if (!transitionApproval.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionApproval")) {
            ArrayList<ApprovalBean> approvalBeanList = new ArrayList<ApprovalBean>();
            Iterator approvalIterator = node.getChildElements();
            while (approvalIterator.hasNext()) {
                OMElement approveChild = (OMElement)approvalIterator.next();
                approvalBeanList.add(Utils.createApprovalBean(approveChild));
            }
            transitionApproval.put(currentStateName, approvalBeanList);
        }
    }

    public static void addTransitionApprovalItems(Resource resource, List<ApprovalBean> approvalBeans, String state, String aspectName) {
        if (approvalBeans != null) {
            int order = 0;
            for (ApprovalBean approvalBean : approvalBeans) {
                ArrayList<String> allowedRoles = new ArrayList<String>();
                allowedRoles.addAll(approvalBean.getRoles());
                ArrayList<String> items = new ArrayList<String>();
                items.add("status:" + state);
                items.add("name:" + approvalBean.getForEvent());
                items.add("current:0");
                items.add("votes:" + approvalBean.getVotes());
                items.add("users:");
                items.add("order:" + order);
                String resourcePropertyNameForItem = "registry.custom_lifecycle.votes.option." + aspectName + "." + order + ".vote";
                String resourcePropertyNameForVotePermission = "registry.custom_lifecycle.votes.option." + aspectName + "." + order + ".vote.permission";
                resource.setProperty(resourcePropertyNameForItem, items);
                if (allowedRoles.isEmpty()) {
                    resource.setProperty(resourcePropertyNameForVotePermission, resourcePropertyNameForVotePermission);
                } else {
                    resource.setProperty(resourcePropertyNameForVotePermission, allowedRoles);
                }
                ++order;
            }
        }
    }

    public static boolean isTransitionApprovalAllowed(String[] roles, List<ApprovalBean> approvalBeans, String eventName, int currentVotes) {
        boolean approvalAllowed = false;
        if (approvalBeans != null) {
            for (ApprovalBean approvalBean : approvalBeans) {
                if (!approvalBean.getForEvent().equals(eventName) || currentVotes <= approvalBean.getVotes()) continue;
                approvalAllowed = true;
            }
        }
        return approvalAllowed;
    }

    public static void clearTransitionApprovals(Resource resource, String aspectName) {
        Properties properties = (Properties)resource.getProperties().clone();
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (key.startsWith("registry.custom_lifecycle.votes.option." + aspectName)) {
                resource.removeProperty(key);
                continue;
            }
            if (!key.startsWith("registry.custom_lifecycle.user.vote" + aspectName)) continue;
            resource.removeProperty(key);
        }
    }
}

