/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.discoveryagents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.ExistArtifactStrategy;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.OrphanArtifactStrategy;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public abstract class DiscoveryAgentExecutorSupport {
    public static final String RESOURCE_SOURCE_PROPERTY = "resource.source";
    public static final String SOURCE_GREG_DISCOVERY = "greg-discovery";
    public static final String RESOURCE_ORIGIN_PROPERTY = "resource.origin";
    public static final String RESOURCE_DISCOVERY_SEQNO_PROPERTY = "resource.discovery_seqno";
    public static final String NAME_VERSION_SEPARATOR = ":";
    public static final String ON_ORPHAN_ARTIFACT_PROPERTY = "onOrphanArtifact";
    public static final String ON_EXIST_ARTIFACT_PROPERTY = "onExistArtifact";
    public static final String CONFIG_FILE_PARAMETER = "configFile";
    public static final String DEFAULT_CONFIG_FILE = "discoveryagent.properties";
    public static final String SERVERS_PROPERTY = "servers";
    public static final String SERVER_RXT_SHORT_NAME = "server";
    public static final String SERVER_RXT_OVERVIEW_NAME = "overview_name";
    public static final String SERVER_RXT_OVERVIEW_VERSION = "overview_version";
    public static final String SERVER_ID_SEPARATOR = ",";
    public static final String ARTIFACT_ADDED = "added";
    public static final String ARTIFACT_REMOVED = "removed";
    public static final String ARTIFACT_REPLACED = "replaced";
    public static final String ARTIFACT_IGNORED = "ignored";
    public static final String RESOURCE_DISCOVERY_SEQNO = "resource.discovery_seqno";
    public static final String ASSOCIATION_AVAILABLE_ON = "availableOn";
    public static final String ASSOCIATION_CONTAINS = "contains";
    private final Log log = LogFactory.getLog(DiscoveryAgentExecutorSupport.class);
    private OrphanArtifactStrategy onOrphanArtifactStrategy;
    private ExistArtifactStrategy onExistArtifactStrategy;

    protected void updateMaintenanceInfo(GenericArtifact artifact, String seqNo, String originProperty) throws GovernanceException {
        artifact.addAttribute(RESOURCE_SOURCE_PROPERTY, SOURCE_GREG_DISCOVERY);
        artifact.addAttribute(RESOURCE_ORIGIN_PROPERTY, originProperty);
        artifact.addAttribute("resource.discovery_seqno", seqNo);
    }

    protected Map<String, List<String>> persistDiscoveredArtifacts(Registry registry, Map<String, List<DetachedGenericArtifact>> newArtifacts, GenericArtifact serverArtifact, String seqNo, String originProperty) throws RegistryException {
        Map<String, List<String>> feedback = this.initFeedbackMap();
        for (Map.Entry<String, List<DetachedGenericArtifact>> artifactEntry : newArtifacts.entrySet()) {
            String shortName = artifactEntry.getKey();
            List<DetachedGenericArtifact> artifacts = artifactEntry.getValue();
            GenericArtifactManager artifactManager = this.getGenericArtifactManager(registry, shortName);
            for (DetachedGenericArtifact artifact : artifacts) {
                this.persistNewArtifact(artifactManager, artifact, shortName, serverArtifact, seqNo, originProperty, feedback);
            }
        }
        return feedback;
    }

    protected void persistNewArtifact(GenericArtifactManager artifactManager, DetachedGenericArtifact artifact, String shortName, GenericArtifact server, String seqNo, String originProperty, Map<String, List<String>> feedback) throws GovernanceException {
        if (this.isExists(artifactManager, artifact)) {
            switch (this.onExistArtifactStrategy) {
                case IGNORE: {
                    this.log.info((Object)("Ignored already existing artifact" + artifact));
                    feedback.get(ARTIFACT_IGNORED).add(shortName + NAME_VERSION_SEPARATOR + artifact.getQName().getLocalPart());
                    break;
                }
                case REMOVE: {
                    artifactManager.removeGenericArtifact((GenericArtifact)artifact);
                    this.log.info((Object)("Removed already existing artifact" + artifact));
                    this.addNewGenericArtifact(artifactManager, artifact, server, seqNo, originProperty);
                    feedback.get(ARTIFACT_REPLACED).add(shortName + NAME_VERSION_SEPARATOR + artifact.getQName().getLocalPart());
                    break;
                }
                case CUSTOM: {
                    this.customizeExistArtifactStrategy(artifactManager, (GenericArtifact)artifact, seqNo, originProperty);
                }
            }
        } else {
            this.addNewGenericArtifact(artifactManager, artifact, server, seqNo, originProperty);
            feedback.get(ARTIFACT_ADDED).add(shortName + NAME_VERSION_SEPARATOR + artifact.getQName().getLocalPart());
        }
    }

    private boolean isExists(GenericArtifactManager artifactManager, DetachedGenericArtifact artifact) throws GovernanceException {
        String status = artifact.getAttribute("discovery_status");
        if (status != null) {
            if ("existing".equals(status)) {
                artifact.removeAttribute("existing");
                return true;
            }
        } else {
            return artifactManager.isExists((GovernanceArtifact)artifact);
        }
        return false;
    }

    private Map<String, List<String>> initFeedbackMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put(ARTIFACT_ADDED, new ArrayList());
        map.put(ARTIFACT_REMOVED, new ArrayList());
        map.put(ARTIFACT_REPLACED, new ArrayList());
        map.put(ARTIFACT_IGNORED, new ArrayList());
        return map;
    }

    protected GenericArtifact addNewGenericArtifact(GenericArtifactManager artifactManager, DetachedGenericArtifact artifact, GenericArtifact server, String seqNo, String originProperty) throws GovernanceException {
        GenericArtifact newArtifact = artifact.makeRegistryAware(artifactManager);
        this.updateMaintenanceInfo(newArtifact, seqNo, originProperty);
        artifactManager.addGenericArtifact(newArtifact);
        this.addServerToArtifactAssociation(newArtifact, server);
        return newArtifact;
    }

    protected void addServerToArtifactAssociation(GenericArtifact source, GenericArtifact destination) throws GovernanceException {
        source.addBidirectionalAssociation(ASSOCIATION_AVAILABLE_ON, ASSOCIATION_CONTAINS, (GovernanceArtifact)destination);
    }

    protected void handleOrphanArtifacts(Registry registry, Map<String, List<DetachedGenericArtifact>> discovredArtifacts, String seqNo, String originProperty) throws RegistryException {
        switch (this.onOrphanArtifactStrategy) {
            case IGNORE: {
                this.log.info((Object)"Ignored handling orphan artifact");
                break;
            }
            case REMOVE: {
                for (Map.Entry<String, List<DetachedGenericArtifact>> entry : discovredArtifacts.entrySet()) {
                    this.removeOrphanArtifacts(registry, entry.getKey(), entry.getValue(), seqNo, originProperty);
                }
                break;
            }
            case CUSTOM: {
                for (Map.Entry<String, List<DetachedGenericArtifact>> entry : discovredArtifacts.entrySet()) {
                    this.customizeOrphanArtifactStrategy(registry, entry.getKey(), entry.getValue(), seqNo, originProperty);
                }
                break;
            }
        }
    }

    protected void removeOrphanArtifacts(Registry registry, String shortName, List<DetachedGenericArtifact> artifacts, String seqNo, String originProperty) throws RegistryException {
        GenericArtifactManager genericArtifactManager = this.getGenericArtifactManager(registry, shortName);
        for (GenericArtifact artifact : this.findOrphanArtifacts(genericArtifactManager, seqNo, originProperty)) {
            if (this.isCurrentlyDiscoveredArtifact(artifact, artifacts)) continue;
            genericArtifactManager.removeGenericArtifact(artifact.getId());
            this.log.info((Object)("Removed orphan artifact belong to " + originProperty + " server : " + artifact));
        }
    }

    private boolean isCurrentlyDiscoveredArtifact(GenericArtifact artifact, List<DetachedGenericArtifact> artifacts) {
        for (DetachedGenericArtifact detachedGenericArtifact : artifacts) {
            if (!artifact.uniqueTo((GovernanceArtifact)detachedGenericArtifact)) continue;
            return true;
        }
        return false;
    }

    protected List<GenericArtifact> findOrphanArtifacts(GenericArtifactManager genericArtifactManager, String seqNo, String originProperty) throws GovernanceException {
        Registry govRegistry;
        ArrayList<GenericArtifact> orphanArtifacts = new ArrayList<GenericArtifact>();
        String query = "resource.origin=" + originProperty;
        try {
            govRegistry = this.getGovRegistry();
        }
        catch (RegistryException e) {
            throw new GovernanceException((Throwable)e);
        }
        if (govRegistry != null) {
            for (GenericArtifact artifact : genericArtifactManager.findGovernanceArtifacts(query)) {
                String currentSeqNo;
                Resource resource = null;
                try {
                    resource = govRegistry.get(artifact.getPath());
                }
                catch (RegistryException e) {
                    this.log.error((Object)e);
                }
                if (resource == null || (currentSeqNo = resource.getProperty("resource.discovery_seqno")) != null && seqNo.equals(currentSeqNo)) continue;
                orphanArtifacts.add(artifact);
            }
        }
        return orphanArtifacts;
    }

    protected void customizeOrphanArtifactStrategy(Registry registry, String shortName, List<DetachedGenericArtifact> artifacts, String seqNo, String originProperty) {
        throw new UnsupportedOperationException("Override customizeOrphanArtifactStrategy method in a subclass of DiscoveryAgentExecutorTask  ");
    }

    protected void customizeExistArtifactStrategy(GenericArtifactManager artifactManager, GenericArtifact artifact, String seqNo, String originProperty) throws GovernanceException {
        throw new UnsupportedOperationException("Override customizeExistArtifactStrategy method in a subclass of DiscoveryAgentExecutorTask  ");
    }

    protected void setExistArtifactStrategy(Map<String, String> properties) {
        String existProperty = properties.get(ON_EXIST_ARTIFACT_PROPERTY);
        this.onExistArtifactStrategy = ExistArtifactStrategy.valueOf(existProperty.toUpperCase());
    }

    protected void setOrphanArtifactStrategy(Map<String, String> properties) {
        String orphanProperty = properties.get(ON_ORPHAN_ARTIFACT_PROPERTY);
        this.onOrphanArtifactStrategy = OrphanArtifactStrategy.valueOf(orphanProperty.toUpperCase());
    }

    protected void setExistArtifactStrategy(ExistArtifactStrategy existArtifactStrategy) {
        this.onExistArtifactStrategy = existArtifactStrategy;
    }

    protected void setOrphanArtifactStrategy(OrphanArtifactStrategy orphanArtifactStrategy) {
        this.onOrphanArtifactStrategy = orphanArtifactStrategy;
    }

    protected String getOriginProperty(GenericArtifact serverArtifact) throws GovernanceException {
        String serverName = serverArtifact.getAttribute(SERVER_RXT_OVERVIEW_NAME);
        String serverVersion = serverArtifact.getAttribute(SERVER_RXT_OVERVIEW_VERSION);
        if (serverVersion != null) {
            serverName = serverName.concat(serverVersion);
        }
        return serverName;
    }

    protected Registry getConfigRegistry() throws RegistryException {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("wso2.system.user");
        return GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getConfigSystemRegistry();
    }

    protected Registry getGovRegistry() throws RegistryException {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("wso2.system.user");
        return GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
    }

    protected String getSequenceNo() {
        return UUID.randomUUID().toString();
    }

    protected GenericArtifactManager getGenericArtifactManager(Registry registry, String mediaType) throws RegistryException {
        return new GenericArtifactManager(registry, mediaType);
    }
}

