/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.discoveryagents;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentException;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentExecutor;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentExecutorSupport;
import org.wso2.carbon.ntask.core.Task;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class DiscoveryAgentExecutorTask
extends DiscoveryAgentExecutorSupport
implements Task {
    private final Log log = LogFactory.getLog(DiscoveryAgentExecutorTask.class);
    private final String CONFIG_FILE_LOCATION = "repository/components/org.wso2.carbon.governance/discoveryagents/";
    private String serverIdPropertyFilePath;

    public void setProperties(Map<String, String> properties) {
        this.setConfigFileLocation(properties);
        this.setOrphanArtifactStrategy(properties);
        this.setExistArtifactStrategy(properties);
    }

    public void init() {
    }

    public void execute() {
        this.log.info((Object)"DiscoveryAgentExecutorTask started ....");
        try {
            Registry govRegistry = this.getGovRegistry();
            DiscoveryAgentExecutor discoveryAgentExecutor = DiscoveryAgentExecutor.getInstance();
            for (GenericArtifact serverArtifact : this.loadServersToDiscover(govRegistry)) {
                this.log.info((Object)("Started to discover new governance artifacts on " + serverArtifact.getQName() + " server"));
                Map<String, List<DetachedGenericArtifact>> newArtifacts = discoveryAgentExecutor.executeDiscoveryAgent(serverArtifact);
                String originProperty = this.getOriginProperty(serverArtifact);
                String seqNo = this.getSequenceNo();
                Map<String, List<String>> feedback = this.persistDiscoveredArtifacts(govRegistry, newArtifacts, serverArtifact, seqNo, originProperty);
                this.printFeedback(feedback);
                this.handleOrphanArtifacts(govRegistry, newArtifacts, seqNo, originProperty);
            }
            this.log.info((Object)"DiscoveryAgentExecutorTask completed ....");
        }
        catch (IOException | DiscoveryAgentException | RegistryException e) {
            this.log.error((Object)"Exception occurred running DiscoveryAgentExecutorTask ", e);
        }
    }

    private void printFeedback(Map<String, List<String>> feedback) {
    }

    protected List<GenericArtifact> loadServersToDiscover(Registry registry) throws RegistryException, IOException {
        ArrayList<GenericArtifact> serverArtifacts = new ArrayList<GenericArtifact>();
        GenericArtifactManager artifactManager = this.getGenericArtifactManager(registry, "server");
        for (String serverId : this.getServersToDiscover(this.getConfigRegistry())) {
            HashMap<String, List<String>> options = new HashMap<String, List<String>>();
            this.setServerDiscoverOptions(options, serverId);
            GenericArtifact[] serverArtifactArray = artifactManager.findGenericArtifacts(options);
            serverArtifacts.addAll(Arrays.asList(serverArtifactArray));
        }
        return serverArtifacts;
    }

    protected List<String> getServersToDiscover(Registry registry) throws RegistryException, IOException {
        Resource resource = registry.get(this.serverIdPropertyFilePath);
        if (resource != null) {
            Properties serverProperties = new Properties();
            serverProperties.load(resource.getContentStream());
            String serverStr = serverProperties.getProperty("servers");
            if (serverStr != null) {
                String[] servers = serverStr.split(",");
                return Arrays.asList(servers);
            }
        }
        return Collections.emptyList();
    }

    protected void setServerDiscoverOptions(Map<String, List<String>> options, String serverId) {
        if (serverId != null) {
            int index = serverId.indexOf(":");
            if (index > 0) {
                String serverName = serverId.substring(0, index);
                String serverVersion = serverId.substring(index);
                options.put("overview_name", Arrays.asList(serverName));
                options.put("overview_version", Arrays.asList(serverVersion));
            } else {
                options.put("overview_name", Arrays.asList(serverId));
            }
        }
    }

    protected void setConfigFileLocation(Map<String, String> properties) {
        String configFile = properties.get("configFile");
        this.serverIdPropertyFilePath = configFile != null ? "repository/components/org.wso2.carbon.governance/discoveryagents/".concat(configFile) : "repository/components/org.wso2.carbon.governance/discoveryagents/".concat("discoveryagent.properties");
    }
}

