/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.executors.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class APIDeleteExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(APIDeleteExecutor.class);
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
            if (secretResolver.isInitialized()) {
                this.apimUsername = secretResolver.isTokenProtected("apim.username") ? secretResolver.resolve("apim.username") : MiscellaneousUtil.resolve((String)this.apimUsername, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
            if (secretResolver.isInitialized()) {
                this.apimPassword = secretResolver.isTokenProtected("apim.password") ? secretResolver.resolve("apim.password") : MiscellaneousUtil.resolve((String)this.apimPassword, (SecretResolver)secretResolver);
            }
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        boolean deleted = false;
        String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            GenericArtifactManager manager = new GenericArtifactManager((Registry)RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId()), "restservice");
            GenericArtifact api = manager.getGenericArtifact(context.getResource().getUUID());
            deleted = this.deleteFromAPIManager(api);
        }
        catch (GovernanceException e) {
            log.error((Object)"Failed to read the REST API artifact from the registry. ", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to delete API from the API manager. ", (Throwable)e);
        }
        return deleted;
    }

    private boolean deleteFromAPIManager(GenericArtifact api) throws RegistryException {
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null) {
            throw new RuntimeException("APIManager login credentials are not defined");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        Utils.authenticateAPIM((HttpContext)httpContext, this.apimEndpoint, this.apimUsername, this.apimPassword);
        String removeEndpoint = this.apimEndpoint + "publisher/site/blocks/item-add/ajax/remove.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(removeEndpoint);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("action", "removeAPI"));
            params.add(new BasicNameValuePair("name", api.getAttribute("overview_name")));
            params.add(new BasicNameValuePair("provider", this.apimUsername));
            params.add(new BasicNameValuePair("version", api.getAttribute("overview_version")));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, (HttpContext)httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (ClientProtocolException e) {
            throw new RegistryException("Failed to send the http POST request to API Manager. ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RegistryException("Failed when encoding the parameter list. ", (Throwable)e);
        }
        catch (IOException e) {
            throw new RegistryException("Failed to send the http POST request to API Manager. ", (Throwable)e);
        }
        return true;
    }
}

