/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;

public abstract class AbstractGovernanceAssociationHandler
extends Handler {
    public static final String SYSTEM_GOVERNANCE_ROOT_PATH = "/_system/governance";

    public final void addAssociation(RequestContext requestContext) throws RegistryException {
        super.addAssociation(requestContext);
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        UserRegistry registry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(tenantDomain);
        GenericArtifact source = (GenericArtifact)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)this.getUserRegistryPath(requestContext.getSourcePath()));
        GenericArtifact target = (GenericArtifact)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)this.getUserRegistryPath(requestContext.getTargetPath()));
        this.onAddAssociation(requestContext.getAssociationType(), source, target);
    }

    public final void removeAssociation(RequestContext requestContext) throws RegistryException {
        super.removeAssociation(requestContext);
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        UserRegistry registry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(tenantDomain);
        GenericArtifact source = (GenericArtifact)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)this.getUserRegistryPath(requestContext.getSourcePath()));
        GenericArtifact target = (GenericArtifact)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)this.getUserRegistryPath(requestContext.getTargetPath()));
        this.onRemoveAssociation(requestContext.getAssociationType(), source, target);
    }

    public abstract void onAddAssociation(String var1, GenericArtifact var2, GenericArtifact var3) throws GovernanceException;

    public abstract void onRemoveAssociation(String var1, GenericArtifact var2, GenericArtifact var3) throws GovernanceException;

    private String getUserRegistryPath(String sourcePath) {
        if (sourcePath.startsWith(SYSTEM_GOVERNANCE_ROOT_PATH)) {
            return sourcePath.replace(SYSTEM_GOVERNANCE_ROOT_PATH, "");
        }
        return sourcePath;
    }
}

