/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class PolicyUriHandler {
    private static final Log log = LogFactory.getLog(PolicyUriHandler.class);
    private Registry governanceUserRegistry;
    private Registry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext, String sourceURL) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        log.debug((Object)"Processing Policy URI started");
        this.registry = requestContext.getRegistry();
        int tenantId = CurrentSession.getTenantId();
        String userName = CurrentSession.getUser();
        this.governanceUserRegistry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(userName, tenantId);
        try {
            InputStream inputStream;
            try {
                if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system.";
                    throw new RegistryException(msg);
                }
                inputStream = new URL(sourceURL).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + sourceURL + " is incorrect.", (Throwable)e);
            }
            this.addPolicyToRegistry(requestContext, inputStream, sourceURL);
            log.debug((Object)"Processing Policy URI finished");
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void addPolicyToRegistry(RequestContext requestContext, InputStream inputStream, String sourceURL) throws RegistryException {
        Resource policyResource;
        if (requestContext.getResource() == null) {
            policyResource = new ResourceImpl();
            policyResource.setMediaType("application/policy+xml");
        } else {
            policyResource = requestContext.getResource();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int nextChar;
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RegistryException("Exception occured while reading policy content.", (Throwable)e);
        }
        policyResource.setContent((Object)outputStream.toByteArray());
        try {
            AXIOMUtil.stringToOM((String)RegistryUtils.decodeBytes((byte[])outputStream.toByteArray()));
        }
        catch (Exception e) {
            throw new RegistryException("The given policy file does not contain valid XML.");
        }
        String resourcePath = requestContext.getResourcePath().getPath();
        String policyFileName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        Registry systemRegistry = CommonUtil.getUnchrootedSystemRegistry((RequestContext)requestContext);
        String commonLocation = this.getChrootedLocation(requestContext.getRegistryContext());
        if (!systemRegistry.resourceExists(commonLocation)) {
            systemRegistry.put(commonLocation, (Resource)systemRegistry.newCollection());
        }
        String policyPath = commonLocation + this.extractResourceFromURL(policyFileName, ".xml");
        String policyId = policyResource.getUUID();
        if (policyId == null) {
            policyId = UUID.randomUUID().toString();
            policyResource.setUUID(policyId);
        }
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)policyPath);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        this.addPolicyToRegistry(policyPath, sourceURL, policyResource);
        ((ResourceImpl)policyResource).setPath(relativeArtifactPath);
        requestContext.setProcessingComplete(true);
    }

    protected void addPolicyToRegistry(String path, String url, Resource resource) throws RegistryException {
        String source = PolicyUriHandler.getSource(path);
        GenericArtifactManager genericArtifactManager = new GenericArtifactManager(this.governanceUserRegistry, "uri");
        GenericArtifact policy = genericArtifactManager.newGovernanceArtifact(new QName(source));
        policy.setId(resource.getUUID());
        policy.setAttribute("overview_name", source);
        policy.setAttribute("overview_uri", url);
        policy.setAttribute("overview_type", "Policy");
        genericArtifactManager.addGenericArtifact(policy);
    }

    private String extractResourceFromURL(String policyURL, String suffix) {
        String resourceName = policyURL;
        if (policyURL.lastIndexOf("?") > 0) {
            resourceName = policyURL.substring(0, policyURL.indexOf("?")) + suffix;
        } else if (policyURL.indexOf(".") > 0) {
            resourceName = policyURL.substring(0, policyURL.lastIndexOf(".")) + suffix;
        } else if (!policyURL.endsWith(suffix)) {
            resourceName = policyURL + suffix;
        }
        return resourceName;
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)"/_system/governance/uris/Policy/");
    }

    public static String getSource(String uri) {
        return uri.split("/")[uri.split("/").length - 1];
    }
}

