/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.wso2.carbon.governance.registry.extensions.handlers.utils.SchemaUriProcessor;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaValidator;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;

public class SchemaUriHandler {
    private static final Log log = LogFactory.getLog(SchemaUriHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext, String sourceURL) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        log.debug((Object)"Processing Schema URI started");
        try {
            WSDLValidationInfo validationInfo;
            String resourcePath = requestContext.getResourcePath().getCompletePath();
            try {
                validationInfo = SchemaValidator.validate((XMLInputSource)new XMLInputSource(null, sourceURL, null));
            }
            catch (Exception e) {
                throw new RegistryException("Exception occured while validating the schema.", (Throwable)e);
            }
            String savedName = this.processSchemaImport(requestContext, resourcePath, validationInfo, sourceURL);
            this.onPutCompleted(resourcePath, Collections.singletonMap(sourceURL, savedName), Collections.emptyList(), requestContext);
            requestContext.setActualPath(savedName);
            log.debug((Object)"Processing Schema URI finished");
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected SchemaUriProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        return new SchemaUriProcessor(requestContext, validationInfo);
    }

    protected String processSchemaImport(RequestContext requestContext, String resourcePath, WSDLValidationInfo validationInfo, String sourceURL) throws RegistryException {
        SchemaUriProcessor schemaProcessor = this.buildSchemaProcessor(requestContext, validationInfo);
        return schemaProcessor.importSchemaToRegistry(requestContext, resourcePath, this.getChrootedLocation(requestContext.getRegistryContext()), sourceURL);
    }

    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)"/_system/governance/uris/XSD/");
    }
}

