/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers.utils;

import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaInfo;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.InputSource;

public class SchemaUriProcessor {
    private Registry registry;
    private Registry systemRegistry;
    private Registry governanceUserRegistry;
    private List<String> processedSchemas;
    private List<String> visitedSchemas;
    private Map<String, SchemaInfo> schemas;
    private List<Association> associations;
    private String baseURI = null;
    private WSDLValidationInfo validationInfo;
    private static final String SCHEMA_VALIDATION_MESSAGE = "Schema Validation Message ";
    private static final String SCHEMA_STATUS = "Schema Validation";
    private boolean useOriginalSchema;
    private String resourceName = "";
    private static final Log log = LogFactory.getLog(SchemaUriProcessor.class);
    private int i;

    public SchemaUriProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        this.registry = requestContext.getRegistry();
        try {
            this.systemRegistry = CommonUtil.getUnchrootedSystemRegistry((RequestContext)requestContext);
            int tenantId = CurrentSession.getTenantId();
            String userName = CurrentSession.getUser();
            this.governanceUserRegistry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(userName, tenantId);
        }
        catch (RegistryException ignore) {
            this.systemRegistry = null;
        }
        this.i = 0;
        this.schemas = new LinkedHashMap<String, SchemaInfo>();
        this.processedSchemas = new ArrayList<String>();
        this.visitedSchemas = new ArrayList<String>();
        this.associations = new ArrayList<Association>();
        this.validationInfo = validationInfo;
    }

    public SchemaUriProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo, boolean useOriginalSchema) {
        this(requestContext, validationInfo);
        this.useOriginalSchema = useOriginalSchema;
    }

    public String importSchemaToRegistry(RequestContext requestContext, String resourcePath, String commonLocation, String sourceURL) throws RegistryException {
        this.resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(sourceURL);
        this.baseURI = sourceURL;
        InputSource inputSource = new InputSource(sourceURL);
        try {
            XmlSchema xmlSchema = xmlSchemaCollection.read(inputSource, null);
            this.evaluateSchemasRecursively(xmlSchema, null, false, true);
        }
        catch (RuntimeException re) {
            String msg = "Could not read the XML Schema Definition file. ";
            if (re.getCause() instanceof XmlSchemaException) {
                msg = msg + re.getCause().getMessage();
                log.error((Object)msg, (Throwable)re);
                throw new RegistryException(msg);
            }
            throw new RegistryException(msg, (Throwable)re);
        }
        this.updateSchemaPaths(commonLocation);
        this.updateSchemaInternalsAndAssociations();
        Resource metaResource = requestContext.getResource();
        String path = this.saveSchemaToRegistry(resourcePath, metaResource);
        this.persistAssociations(path);
        return path;
    }

    public void evaluateSchemas(Types types, String wsdlDocumentBaseURI, ArrayList<String> dependencies) throws RegistryException {
        this.baseURI = wsdlDocumentBaseURI;
        if (types != null) {
            List extensibleElements = types.getExtensibilityElements();
            wsdlDocumentBaseURI = wsdlDocumentBaseURI.substring(0, wsdlDocumentBaseURI.lastIndexOf("/") + 1);
            for (Object extensibleElement : extensibleElements) {
                SchemaImportImpl schemaImport;
                Object extensionObject = extensibleElement;
                if (!(extensionObject instanceof Schema)) continue;
                Schema schema = (Schema)extensionObject;
                if (schema.getImports().size() > 0 && (schemaImport = (SchemaImportImpl)((Vector)schema.getImports().values().toArray()[0]).firstElement()).getReferencedSchema() != null) {
                    CommonUtil.addImportedArtifact((String)new File(schemaImport.getReferencedSchema().getDocumentBaseURI()).toString());
                }
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchemaCollection.setBaseUri(wsdlDocumentBaseURI);
                XmlSchema xmlSchema = xmlSchemaCollection.read(schema.getElement());
                this.evaluateSchemasRecursively(xmlSchema, dependencies, true, false);
            }
        }
    }

    private void evaluateSchemasRecursively(XmlSchema xmlSchema, ArrayList<String> dependencies, boolean isWSDLInlineSchema, boolean isMasterSchema) throws RegistryException {
        XmlSchemaObjectCollection includes = xmlSchema.getIncludes();
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setMasterSchema(isMasterSchema);
        this.visitedSchemas.add(xmlSchema.getSourceURI());
        if (includes != null) {
            Iterator iter = includes.getIterator();
            while (iter.hasNext()) {
                XmlSchemaExternal xmlSchemaExternal;
                XmlSchema innerSchema;
                Object externalComponent = iter.next();
                if (!(externalComponent instanceof XmlSchemaExternal) || (innerSchema = (xmlSchemaExternal = (XmlSchemaExternal)externalComponent).getSchema()) == null) continue;
                String sourceURI = innerSchema.getSourceURI();
                if (isWSDLInlineSchema) {
                    dependencies.add(sourceURI);
                } else {
                    schemaInfo.getSchemaDependencies().add(sourceURI);
                }
                if (this.visitedSchemas.contains(sourceURI)) continue;
                this.evaluateSchemasRecursively(innerSchema, null, false, false);
            }
        }
        if (!isWSDLInlineSchema) {
            String sourceURI = xmlSchema.getSourceURI();
            String fileNameToSave = isMasterSchema ? this.extractResourceFromURL(this.resourceName, ".xsd") : this.extractResourceFromURL(sourceURI.substring(sourceURI.lastIndexOf("/") + 1), ".xsd");
            String originalName = fileNameToSave = fileNameToSave.replace("?xsd=", ".");
            while (this.processedSchemas.contains(fileNameToSave)) {
                fileNameToSave = fileNameToSave.substring(0, fileNameToSave.indexOf(".")) + ++this.i + ".xsd";
            }
            if (schemaInfo.isMasterSchema() && !originalName.equals(fileNameToSave)) {
                for (SchemaInfo schema : this.schemas.values()) {
                    if (!schema.getProposedResourceName().equals(originalName)) continue;
                    if (schema.isMasterSchema()) break;
                    schema.setProposedResourceName(fileNameToSave);
                    fileNameToSave = originalName;
                    break;
                }
            }
            this.processedSchemas.add(fileNameToSave);
            schemaInfo.setProposedResourceName(fileNameToSave);
            schemaInfo.setSchema(xmlSchema);
            schemaInfo.setOriginalURL(sourceURI);
            this.schemas.put(this.getAbsoluteSchemaURL(sourceURI), schemaInfo);
        }
    }

    public String getSchemaRegistryPath(String parentRegistryPath, String sourceURL) throws RegistryException {
        SchemaInfo schemaInfo = this.schemas.get(this.getAbsoluteSchemaURL(sourceURL));
        if (schemaInfo != null) {
            return WSDLUtil.computeRelativePathWithVersion((String)parentRegistryPath, (String)schemaInfo.getProposedRegistryURL(), (Registry)this.systemRegistry);
        }
        return null;
    }

    public String getSchemaAssociationPath(String sourceURL) {
        SchemaInfo schemaInfo = this.schemas.get(sourceURL);
        if (schemaInfo != null) {
            String proposedRegistryURL = schemaInfo.getProposedRegistryURL();
            return proposedRegistryURL.replaceAll("\\.\\./", "");
        }
        return null;
    }

    private void updateSchemaPaths(String commonSchemaLocation) throws RegistryException {
        if (!this.systemRegistry.resourceExists(commonSchemaLocation)) {
            this.systemRegistry.put(commonSchemaLocation, (Resource)this.systemRegistry.newCollection());
        }
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = "unqualified";
            }
            String schemaLocation = commonSchemaLocation + schemaInfo.getProposedResourceName();
            schemaInfo.setProposedRegistryURL(schemaLocation);
        }
    }

    private void updateSchemaPaths(String commonSchemaLocation, String version, List dependencies) throws RegistryException {
        if (!this.systemRegistry.resourceExists(commonSchemaLocation)) {
            this.systemRegistry.put(commonSchemaLocation, (Resource)this.systemRegistry.newCollection());
        }
        block0: for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = "unqualified";
            }
            String schemaLocation = (commonSchemaLocation + CommonUtil.derivePathFragmentFromNamespace((String)targetNamespace)).replace("//", "/");
            String regex = schemaLocation + "[\\d].[\\d].[\\d]" + "/" + schemaInfo.getProposedResourceName();
            for (Object dependency : dependencies) {
                String path = dependency.toString();
                if (!path.matches(regex)) continue;
                schemaLocation = path;
                schemaInfo.setProposedRegistryURL(schemaLocation);
                continue block0;
            }
            schemaLocation = schemaLocation + version + "/" + schemaInfo.getProposedResourceName();
            schemaInfo.setProposedRegistryURL(schemaLocation);
        }
    }

    private void updateSchemaInternalsAndAssociations() throws RegistryException {
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            XmlSchemaObjectCollection includes = schema.getIncludes();
            if (includes != null) {
                Iterator iter = includes.getIterator();
                while (iter.hasNext()) {
                    String sourceURI;
                    XmlSchemaExternal xmlSchemaExternal;
                    XmlSchema schema1;
                    Object externalComponent = iter.next();
                    if (!(externalComponent instanceof XmlSchemaExternal) || (schema1 = (xmlSchemaExternal = (XmlSchemaExternal)externalComponent).getSchema()) == null || !this.schemas.containsKey(sourceURI = this.getAbsoluteSchemaURL(schema1.getSourceURI()))) continue;
                    SchemaInfo info = this.schemas.get(sourceURI);
                    String relativeSchemaPath = WSDLUtil.computeRelativePathWithVersion((String)schemaInfo.getProposedRegistryURL(), (String)info.getProposedRegistryURL(), (Registry)this.registry);
                    xmlSchemaExternal.setSchemaLocation(relativeSchemaPath);
                }
            }
            for (String associatedTo : schemaInfo.getSchemaDependencies()) {
                SchemaInfo schemaInfoAssociated = this.schemas.get(associatedTo);
                if (schemaInfoAssociated == null) continue;
                this.associations.add(new Association(schemaInfo.getProposedRegistryURL(), schemaInfoAssociated.getProposedRegistryURL(), "depends"));
                this.associations.add(new Association(schemaInfoAssociated.getProposedRegistryURL(), schemaInfo.getProposedRegistryURL(), "usedBy"));
            }
        }
    }

    public String saveSchemasToRegistry(String commonSchemaLocation, Resource metaResource) throws RegistryException {
        this.updateSchemaPaths(commonSchemaLocation);
        this.updateSchemaInternalsAndAssociations();
        String path = this.saveSchemaToRegistry(null, metaResource);
        this.persistAssociations(path);
        return path;
    }

    public String saveSchemasToRegistry(String commonSchemaLocation, Resource metaResource, String version, List dependencies) throws RegistryException {
        this.updateSchemaPaths(commonSchemaLocation, version, dependencies);
        this.updateSchemaInternalsAndAssociations();
        String path = this.saveSchemaToRegistry(null, metaResource);
        this.persistAssociations(path);
        return path;
    }

    private String saveSchemaToRegistry(String resourcePath, Resource metaResource) throws RegistryException {
        String path = resourcePath;
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            ResourceImpl xsdResource;
            XmlSchema schema = schemaInfo.getSchema();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            schema.write((OutputStream)byteArrayOutputStream);
            byte[] xsdContent = byteArrayOutputStream.toByteArray();
            String schemaPath = schemaInfo.getProposedRegistryURL();
            if (metaResource != null && this.registry.resourceExists(schemaPath)) {
                xsdResource = this.registry.get(schemaPath);
            } else {
                xsdResource = new ResourceImpl();
                if (metaResource != null) {
                    xsdResource.setUUID(metaResource.getUUID());
                    Properties properties = metaResource.getProperties();
                    if (properties != null) {
                        List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            String key = (String)e.getKey();
                            if (linkProperties.contains(key)) continue;
                            xsdResource.setProperty(key, (List)e.getValue());
                        }
                    }
                }
            }
            xsdResource.setMediaType("application/x-xsd+xml");
            if (this.useOriginalSchema) {
                String errMsg;
                try {
                    xsdResource.setContent((Object)CarbonUtils.getBytesFromFile((File)new File(new URI(schemaInfo.getOriginalURL()))));
                }
                catch (CarbonException e) {
                    errMsg = "Trying to store original schema in registry failed while generating the content from original schema.";
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RegistryException(errMsg, (Throwable)e);
                }
                catch (URISyntaxException e) {
                    errMsg = "Trying to store original schema in registry failed due to error occurred in file url:" + schemaInfo.getOriginalURL();
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RegistryException(errMsg, (Throwable)e);
                }
            } else {
                xsdResource.setContent((Object)xsdContent);
            }
            if (metaResource != null) {
                xsdResource.setDescription(metaResource.getDescription());
            }
            String targetNamespace = schema.getTargetNamespace();
            xsdResource.setProperty("targetNamespace", targetNamespace);
            if (schemaInfo.isMasterSchema() && this.validationInfo != null) {
                ArrayList messages = this.validationInfo.getValidationMessages();
                if (messages.size() > 0) {
                    xsdResource.setProperty(SCHEMA_STATUS, "Invalid");
                } else {
                    xsdResource.setProperty(SCHEMA_STATUS, "Valid");
                }
                int i = 1;
                for (String message : messages) {
                    if (message == null) continue;
                    if (message.length() > 1000) {
                        message = message.substring(0, 997) + "...";
                    }
                    xsdResource.setProperty(SCHEMA_VALIDATION_MESSAGE + i, message);
                    ++i;
                }
            }
            this.saveToRepositorySafely(schemaInfo.getOriginalURL(), schemaPath, (Resource)xsdResource, schemaInfo.isMasterSchema());
            if (!schemaInfo.isMasterSchema()) continue;
            path = schemaPath;
        }
        return path;
    }

    private void persistAssociations(String schemaPath) throws RegistryException {
        for (Association association : this.associations) {
            boolean isAssociationExist = false;
            Association[] existingAssociations = this.registry.getAllAssociations(association.getSourcePath());
            if (existingAssociations != null) {
                for (Association currentAssociation : existingAssociations) {
                    if (!currentAssociation.getDestinationPath().equals(association.getDestinationPath()) || !currentAssociation.getAssociationType().equals(association.getAssociationType())) continue;
                    isAssociationExist = true;
                    break;
                }
            }
            if (isAssociationExist) continue;
            this.registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
        if (schemaPath != null && this.associations.isEmpty()) {
            Association[] dependencies;
            for (Association dependency : dependencies = this.registry.getAssociations(schemaPath, "depends")) {
                if (!dependency.getSourcePath().equals(schemaPath)) continue;
                this.registry.removeAssociation(dependency.getSourcePath(), dependency.getDestinationPath(), "depends");
                this.registry.removeAssociation(dependency.getDestinationPath(), dependency.getSourcePath(), "usedBy");
            }
        }
    }

    private void saveToRepositorySafely(String url, String path, Resource resource, boolean isMasterSchema) throws RegistryException {
        String schemaId = resource.getUUID();
        if (schemaId == null) {
            schemaId = UUID.randomUUID().toString();
            resource.setUUID(schemaId);
        }
        if (this.registry.resourceExists(path)) {
            log.debug((Object)"A Resource already exists at given location. Overwriting resource content.");
        }
        this.addSchemaToRegistry(path, url, resource, this.registry, isMasterSchema);
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)path);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        ((ResourceImpl)resource).setPath(relativeArtifactPath);
    }

    protected void addSchemaToRegistry(String path, String url, Resource resource, Registry registry, boolean isMasterSchema) throws RegistryException {
        String source = SchemaUriProcessor.getSource(path);
        GenericArtifactManager genericArtifactManager = new GenericArtifactManager(this.governanceUserRegistry, "uri");
        if (!registry.resourceExists(path)) {
            GenericArtifact xsd = genericArtifactManager.newGovernanceArtifact(new QName(source));
            if (isMasterSchema) {
                xsd.setId(resource.getUUID());
            }
            xsd.setAttribute("overview_name", source);
            xsd.setAttribute("overview_uri", url);
            xsd.setAttribute("overview_type", "XSD");
            genericArtifactManager.addGenericArtifact(xsd);
        } else {
            Resource existResource = registry.get(path);
            GenericArtifact artifact = genericArtifactManager.getGenericArtifact(existResource.getUUID());
            if (!artifact.getAttribute("overview_uri").equals(url)) {
                throw new RegistryException("Different schema URI already exists in " + path + ".");
            }
        }
    }

    private String extractResourceFromURL(String wsdlURL, String suffix) {
        String resourceName = wsdlURL;
        if (wsdlURL.indexOf("?") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.indexOf("?")) + suffix;
        } else if (wsdlURL.indexOf(".") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.lastIndexOf(".")) + suffix;
        } else if (!wsdlURL.endsWith(suffix)) {
            resourceName = wsdlURL + suffix;
        }
        return resourceName;
    }

    private String getAbsoluteSchemaURL(String schemaLocation) throws RegistryException {
        if (schemaLocation != null && this.baseURI != null) {
            try {
                URI uri = new URI(this.baseURI);
                URI absoluteURI = uri.resolve(schemaLocation);
                return absoluteURI.toString();
            }
            catch (URISyntaxException e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
        }
        return schemaLocation;
    }

    public static String getSource(String uri) {
        return uri.split("/")[uri.split("/").length - 1];
    }
}

