/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers.utils;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.handlers.utils.SchemaUriProcessor;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.ExWSDLReaderImpl;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.xml.sax.InputSource;

public class WsdlUriProcessor {
    private Registry registry;
    private Registry systemRegistry;
    private Registry governanceUserRegistry;
    private Definition originalDefinition;
    private List<Association> associations;
    private SchemaUriProcessor schemaUriProcessor;
    private int i;
    private String resourceName;
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    private static final String SAMPLE_BASE_URL = "http://this.wsdl.needs/a/valid/url/to/proceed.wsdl";
    private List<String> visitedWSDLs;
    private List<String> processedWSDLs;
    private Map<String, WSDLInfo> wsdls;
    private WSDLValidationInfo wsdlValidationInfo = null;
    private WSDLValidationInfo wsiValidationInfo = null;
    private boolean hasWSDLImports = false;
    private static Log log = LogFactory.getLog(WsdlUriProcessor.class);

    public WsdlUriProcessor(RequestContext requestContext) {
        this.registry = requestContext.getRegistry();
        try {
            this.systemRegistry = CommonUtil.getUnchrootedSystemRegistry((RequestContext)requestContext);
            if (!this.systemRegistry.resourceExists(this.getChrootedSchemaLocation(requestContext.getRegistryContext()))) {
                this.systemRegistry.put(this.getChrootedSchemaLocation(requestContext.getRegistryContext()), (Resource)this.systemRegistry.newCollection());
            }
            if (!this.systemRegistry.resourceExists(WsdlUriProcessor.getChrootedWSDLLocation(requestContext.getRegistryContext()))) {
                this.systemRegistry.put(WsdlUriProcessor.getChrootedWSDLLocation(requestContext.getRegistryContext()), (Resource)this.systemRegistry.newCollection());
            }
            int tenantId = CurrentSession.getTenantId();
            String userName = CurrentSession.getUser();
            this.governanceUserRegistry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(userName, tenantId);
        }
        catch (RegistryException ignore) {
            this.systemRegistry = null;
        }
        this.i = 0;
        this.associations = new ArrayList<Association>();
        this.visitedWSDLs = new ArrayList<String>();
        this.processedWSDLs = new ArrayList<String>();
        this.schemaUriProcessor = this.buildSchemaProcessor(requestContext, null);
        this.wsdls = new LinkedHashMap<String, WSDLInfo>();
        this.resourceName = "";
    }

    public static String getChrootedWSDLLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)"/_system/governance/uris/WSDL/");
    }

    private String getChrootedSchemaLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)"/_system/governance/uris/XSD/");
    }

    private String getChrootedPolicyLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)"/_system/governance/uris/Policy/");
    }

    private String getChrootedServiceLocation(Registry registry, RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)registry.getRegistryContext().getServicePath());
    }

    public String addWSDLToRegistry(RequestContext context, String wsdlURL, Resource metadata, boolean isPut) throws RegistryException {
        String masterWSDLPath;
        boolean evaluateExports = true;
        boolean isDefaultEnvironment = true;
        String currentWsdlLocation = null;
        String currentSchemaLocation = null;
        String currentEndpointLocation = null;
        String masterVersion = null;
        ArrayList<String> dependeinciesList = new ArrayList<String>();
        String resourcePath = context.getResourcePath().getPath();
        this.resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        RegistryContext registryContext = context.getRegistryContext();
        this.evaluateWSDLsToDefinitions(wsdlURL, context, evaluateExports, false, isPut);
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
            if (wsdlDefinition == null) continue;
            Types types = wsdlDefinition.getTypes();
            this.schemaUriProcessor.evaluateSchemas(types, wsdlDefinition.getDocumentBaseURI(), wsdlInfo.getSchemaDependencies());
            String wsdlName = wsdlInfo.getProposedRegistryURL();
            int index = wsdlName.lastIndexOf("/");
            String wsdlResourceName = wsdlName.substring(index + 1);
            String wsdlPath = WsdlUriProcessor.getChrootedWSDLLocation(registryContext) + wsdlResourceName;
            if (!resourcePath.contains(wsdlResourceName)) {
                wsdlInfo.setProposedRegistryURL(wsdlPath);
                continue;
            }
            if (!resourcePath.equals("/" + wsdlName) & !resourcePath.contains("/uris/WSDL/") & this.registry.resourceExists(resourcePath)) {
                Association[] associations;
                if (currentWsdlLocation == null) {
                    String currentEnvironment = resourcePath.substring(0, resourcePath.indexOf(CommonUtil.derivePathFragmentFromNamespace((String)wsdlDefinition.getTargetNamespace()).replace("//", "/")));
                    String[] pathFragments = "/uris/WSDL/".split("/");
                    String wsdlLocation = "/uris/WSDL/";
                    String schemaLocation = "/uris/XSD/";
                    String policyLocation = "/uris/Policy/";
                    String endpointLocation = EndpointUtils.getEndpointLocation();
                    for (String pathFragment : pathFragments) {
                        if ((wsdlLocation = wsdlLocation.replace(pathFragment, "")).startsWith("/")) {
                            wsdlLocation = wsdlLocation.replaceFirst("/", "");
                        }
                        if ((schemaLocation = schemaLocation.replace(pathFragment, "")).startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        if ((policyLocation = policyLocation.replace(pathFragment, "")).startsWith("/")) {
                            policyLocation = policyLocation.replaceFirst("/", "");
                        }
                        if ((endpointLocation = endpointLocation.replace(pathFragment, "")).startsWith("/")) {
                            endpointLocation = endpointLocation.replaceFirst("/", "");
                        }
                        currentEnvironment = currentEnvironment.replace(pathFragment, "");
                    }
                    if (wsdlLocation.endsWith("/")) {
                        wsdlLocation = wsdlLocation.substring(0, wsdlLocation.length() - 1);
                    }
                    if (schemaLocation.endsWith("/")) {
                        schemaLocation = schemaLocation.substring(0, schemaLocation.length() - 1);
                    }
                    if (policyLocation.startsWith("/")) {
                        policyLocation = policyLocation.substring(0, policyLocation.length() - 1);
                    }
                    if (endpointLocation.startsWith("/")) {
                        endpointLocation = endpointLocation.substring(0, endpointLocation.length() - 1);
                    }
                    currentWsdlLocation = currentEnvironment + wsdlLocation;
                    currentSchemaLocation = currentEnvironment + schemaLocation;
                    currentEndpointLocation = currentEnvironment + endpointLocation;
                }
                if (masterVersion == null) {
                    String namespaceSegment = CommonUtil.derivePathFragmentFromNamespace((String)wsdlDefinition.getTargetNamespace()).replace("//", "/");
                    String suffix = resourcePath.substring(resourcePath.indexOf(namespaceSegment) + namespaceSegment.length());
                    masterVersion = suffix.substring(0, suffix.indexOf("/"));
                }
                wsdlPath = resourcePath;
                isDefaultEnvironment = false;
                for (Association association : associations = this.registry.getAssociations(wsdlPath, "depends")) {
                    if (!association.getSourcePath().equals(wsdlPath)) continue;
                    dependeinciesList.add(association.getDestinationPath());
                }
            }
            wsdlInfo.setProposedRegistryURL(wsdlPath);
        }
        if (!isDefaultEnvironment) {
            this.schemaUriProcessor.saveSchemasToRegistry(currentSchemaLocation, null, masterVersion, dependeinciesList);
            this.updateWSDLSchemaLocations();
            masterWSDLPath = this.saveWSDLsToRepositoryNew(context, metadata, currentEndpointLocation, dependeinciesList, masterVersion);
            this.addPolicyImports(context);
            this.saveAssociations();
        } else {
            this.schemaUriProcessor.saveSchemasToRegistry(this.getChrootedSchemaLocation(registryContext), null);
            this.updateWSDLSchemaLocations();
            masterWSDLPath = this.saveWSDLsToRepositoryNew(context, metadata);
            this.addPolicyImports(context);
            this.saveAssociations();
            List<OMElement> serviceContentBeans = this.createServiceContent(masterWSDLPath, metadata);
            for (OMElement serviceContentBean : serviceContentBeans) {
                this.addService(serviceContentBean, context);
            }
        }
        return masterWSDLPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolicyImports(RequestContext context) throws RegistryException {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            if (!wsdlInfo.isExistPolicyReferences()) continue;
            for (String policyURL : wsdlInfo.getPolicyDependencies()) {
                boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
                CommonUtil.releaseUpdateLock();
                try {
                    String path = policyURL.substring(policyURL.lastIndexOf("/") + 1);
                    if (policyURL.lastIndexOf("/") <= 0) continue;
                    String source = WsdlUriProcessor.getSource(policyURL);
                    String policyPath = this.getChrootedPolicyLocation(context.getRegistryContext()) + path;
                    GenericArtifactManager genericArtifactManager = new GenericArtifactManager(this.governanceUserRegistry, "uri");
                    if (!this.registry.resourceExists(policyPath)) {
                        GenericArtifact policy = genericArtifactManager.newGovernanceArtifact(new QName(source));
                        policy.setAttribute("overview_name", source);
                        policy.setAttribute("overview_uri", policyURL);
                        policy.setAttribute("overview_type", "Policy");
                        genericArtifactManager.addGenericArtifact(policy);
                    } else {
                        Resource resource = this.registry.get(policyPath);
                        GenericArtifact artifact = genericArtifactManager.getGenericArtifact(resource.getUUID());
                        if (!artifact.getAttribute("overview_uri").equals(policyURL)) {
                            throw new RegistryException("Different policy URI already exists in " + policyPath + ".");
                        }
                    }
                    this.registry.addAssociation(policyPath, wsdlInfo.getProposedRegistryURL(), "usedBy");
                    this.registry.addAssociation(wsdlInfo.getProposedRegistryURL(), policyPath, "depends");
                }
                finally {
                    if (!lockAlreadyAcquired) continue;
                    CommonUtil.acquireUpdateLock();
                }
            }
        }
    }

    public WSDLInfo getMasterWSDLInfo() {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            if (!wsdlInfo.isMasterWSDL()) continue;
            return wsdlInfo;
        }
        return null;
    }

    private void saveAssociations() throws RegistryException {
        for (Association association : this.associations) {
            boolean isAssociationExist = false;
            Association[] existingAssociations = this.registry.getAllAssociations(association.getSourcePath());
            if (existingAssociations != null) {
                for (Association currentAssociation : existingAssociations) {
                    if (!currentAssociation.getDestinationPath().equals(association.getDestinationPath()) || !currentAssociation.getAssociationType().equals(association.getAssociationType())) continue;
                    isAssociationExist = true;
                    break;
                }
            }
            if (isAssociationExist) continue;
            this.registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
    }

    private String extractResourceFromURL(String wsdlURL, String suffix) {
        String resourceName = wsdlURL;
        if (wsdlURL.indexOf("?") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.indexOf("?")) + suffix;
        } else if (wsdlURL.indexOf(".") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.lastIndexOf(".")) + suffix;
        } else if (!wsdlURL.endsWith(".wsdl")) {
            resourceName = wsdlURL + suffix;
        }
        return resourceName;
    }

    private void evaluateWSDLsToDefinitions(String wsdlLocation, RequestContext context, boolean evaluateImports, boolean isServiceImport, boolean isPut) throws RegistryException {
        Definition wsdlDefinition;
        block12: {
            ExWSDLReaderImpl wsdlReader;
            wsdlDefinition = null;
            this.originalDefinition = null;
            try {
                wsdlReader = new ExWSDLReaderImpl((WSDLReaderImpl)WSDLFactory.newInstance().newWSDLReader());
            }
            catch (WSDLException e) {
                String msg = "Could not initiate the wsdl reader. Caused by: " + e.getMessage();
                throw new RegistryException(msg);
            }
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setFeature("javax.wsdl.verbose", log.isDebugEnabled());
            try {
                if (isPut) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])context.getResource().getContent());
                    InputSource inputSource = new InputSource(byteArrayInputStream);
                    wsdlDefinition = wsdlReader.readWSDL(null, inputSource);
                } else {
                    wsdlDefinition = wsdlReader.readWSDL(wsdlLocation);
                }
                this.originalDefinition = wsdlDefinition;
            }
            catch (WSDLException e) {
                String msg = "Could not evaluate WSDL Definition.";
                if (e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException) {
                    msg = msg + " Unable to resolve imported document at '" + wsdlLocation + "'. Connection refused.";
                    log.error((Object)msg, (Throwable)e);
                }
                if (!(e.getCause() instanceof IOException)) break block12;
                msg = msg + " This WSDL file or one of its imports was not found.";
                log.error((Object)msg, (Throwable)e);
            }
        }
        if (!isServiceImport) {
            this.processedWSDLs.add(this.resourceName);
        }
        Map map = null;
        if (wsdlDefinition != null) {
            map = wsdlDefinition.getImports();
        }
        if (map != null && map.size() == 0) {
            log.trace((Object)"Starting WSDL Validation");
            this.wsdlValidationInfo = WSDLUtils.validateWSDL((RequestContext)context);
            log.trace((Object)"Ending WSDL Validation");
            log.trace((Object)"Starting WSI Validation");
            this.wsiValidationInfo = WSDLUtils.validateWSI((RequestContext)context);
            log.trace((Object)"Ending WSI Validation");
        } else {
            this.hasWSDLImports = true;
        }
        if (wsdlDefinition == null) {
            log.trace((Object)"Invalid WSDL definition found.");
            throw new RegistryException("Invalid WSDL definition found.");
        }
        this.evaluateWSDLsToDefinitionsRecursively(wsdlDefinition, evaluateImports, isServiceImport, null, true);
    }

    private void evaluateWSDLsToDefinitionsRecursively(Definition wsdlDefinition, boolean evaluateImports, boolean isServiceImport, WSDLInfo parent, boolean masterWSDL) throws RegistryException {
        String fileNameToSave;
        WSDLInfo wsdlInfo = new WSDLInfo();
        wsdlInfo.setMasterWSDL(masterWSDL);
        wsdlInfo.setParent(parent);
        if (evaluateImports) {
            Iterator iter = wsdlDefinition.getImports().values().iterator();
            this.visitedWSDLs.add(wsdlDefinition.getDocumentBaseURI());
            CommonUtil.addImportedArtifact((String)new File(wsdlDefinition.getDocumentBaseURI()).toString());
            while (iter.hasNext()) {
                Vector values = (Vector)iter.next();
                for (Object value : values) {
                    Import wsdlImport = (Import)value;
                    Definition innerDefinition = wsdlImport.getDefinition();
                    if (innerDefinition == null || innerDefinition.getTargetNamespace() == null) continue;
                    wsdlInfo.getWSDLDependencies().add(innerDefinition.getDocumentBaseURI());
                    if (this.visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                    this.evaluateWSDLsToDefinitionsRecursively(innerDefinition, evaluateImports, isServiceImport, wsdlInfo, false);
                }
            }
        }
        for (Binding binding : wsdlDefinition.getBindings().values()) {
            if (binding.getBindingPolicyReference() == null) continue;
            wsdlInfo.setExistPolicyReferences(true);
            wsdlInfo.getPolicyDependencies().add(binding.getBindingPolicyReference().getURI());
        }
        String baseURI = wsdlDefinition.getDocumentBaseURI();
        if (baseURI != null) {
            String wsdlFileName = baseURI.substring(baseURI.lastIndexOf("/") + 1);
            if (baseURI.equals(this.originalDefinition.getDocumentBaseURI()) && !isServiceImport) {
                fileNameToSave = this.extractResourceFromURL(this.resourceName, ".wsdl");
            } else {
                fileNameToSave = this.extractResourceFromURL(wsdlFileName, ".wsdl");
                while (this.processedWSDLs.contains(fileNameToSave)) {
                    fileNameToSave = this.extractResourceFromURL(wsdlFileName, ++this.i + ".wsdl");
                }
            }
            wsdlInfo.setOriginalURL(baseURI);
        } else {
            fileNameToSave = this.extractResourceFromURL(this.resourceName, ".wsdl");
            wsdlInfo.setOriginalURL(SAMPLE_BASE_URL);
            wsdlDefinition.setDocumentBaseURI(SAMPLE_BASE_URL);
        }
        wsdlInfo.setWSDLDefinition(wsdlDefinition);
        wsdlInfo.setProposedRegistryURL(fileNameToSave);
        this.wsdls.put(baseURI, wsdlInfo);
        this.processedWSDLs.add(fileNameToSave);
    }

    private void updateWSDLSchemaLocations() throws RegistryException {
        this.updateWSDLocations();
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition definition = wsdlInfo.getWSDLDefinition();
            Types types = definition.getTypes();
            if (types == null) continue;
            List extensibleElements = types.getExtensibilityElements();
            for (Object extensibleElement : extensibleElements) {
                Object extensionObject = extensibleElement;
                if (!(extensionObject instanceof Schema)) continue;
                Schema schemaExtension = (Schema)extensionObject;
                NodeList nodeList = schemaExtension.getElement().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String tagName = nodeList.item(i).getLocalName();
                    if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
                    NamedNodeMap nodeMap = nodeList.item(i).getAttributes();
                    for (int j = 0; j < nodeMap.getLength(); ++j) {
                        Node attribute = nodeMap.item(j);
                        if (!attribute.getNodeName().equals("schemaLocation")) continue;
                        String attributeValue = attribute.getNodeValue();
                        String schemaPath = this.schemaUriProcessor.getSchemaRegistryPath(wsdlInfo.getProposedRegistryURL(), attributeValue);
                        if (schemaPath == null) continue;
                        attribute.setNodeValue(schemaPath);
                    }
                }
            }
        }
    }

    private void updateWSDLocations() {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition definition = wsdlInfo.getWSDLDefinition();
            ArrayList wsdlDependencies = wsdlInfo.getWSDLDependencies();
            Vector[] importVector = definition.getImports().values().toArray(new Vector[definition.getImports().values().size()]);
            int count = 0;
            for (String wsdlDependancy : wsdlDependencies) {
                Vector values = importVector[count];
                WSDLInfo dependantWSDLInfo = this.wsdls.get(wsdlDependancy);
                dependantWSDLInfo.getProposedRegistryURL();
                for (Object value : values) {
                    Import importedWSDL = (Import)value;
                    String relativeSchemaPath = WSDLUtil.computeRelativePathWithVersion((String)wsdlInfo.getProposedRegistryURL(), (String)dependantWSDLInfo.getProposedRegistryURL(), (Registry)this.registry);
                    importedWSDL.setLocationURI(relativeSchemaPath);
                }
                ++count;
            }
        }
    }

    private void identifyAssociationsNew(WSDLInfo wsdlInfo) {
        String wsdlPath = wsdlInfo.getProposedRegistryURL();
        for (String association : wsdlInfo.getSchemaDependencies()) {
            String associatedTo = this.schemaUriProcessor.getSchemaAssociationPath(association);
            if (associatedTo == null) continue;
            this.associations.add(new Association(wsdlPath, associatedTo, "depends"));
            this.associations.add(new Association(associatedTo, wsdlPath, "usedBy"));
        }
        for (String association : wsdlInfo.getWSDLDependencies()) {
            String associatedTo;
            WSDLInfo info = this.wsdls.get(association);
            if (info == null || (associatedTo = info.getProposedRegistryURL()) == null) continue;
            this.associations.add(new Association(wsdlPath, associatedTo, "depends"));
            this.associations.add(new Association(associatedTo, wsdlPath, "usedBy"));
        }
    }

    private String saveWSDLsToRepositoryNew(RequestContext context, Resource metaDataResource) throws RegistryException {
        String masterWSDLPath = null;
        try {
            for (WSDLInfo wsdlInfo : this.wsdls.values()) {
                ResourceImpl wsdlResource;
                Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
                WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
                byte[] wsdlResourceContent = byteArrayOutputStream.toByteArray();
                String wsdlPath = wsdlInfo.getProposedRegistryURL();
                if (metaDataResource != null && this.registry.resourceExists(wsdlPath)) {
                    wsdlResource = this.registry.get(wsdlPath);
                } else {
                    Properties properties;
                    wsdlResource = new ResourceImpl();
                    wsdlResource.setUUID(metaDataResource.getUUID());
                    if (metaDataResource != null && (properties = metaDataResource.getProperties()) != null) {
                        List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            String key = (String)e.getKey();
                            if (linkProperties.contains(key)) continue;
                            wsdlResource.setProperty(key, (List)e.getValue());
                        }
                    }
                }
                masterWSDLPath = this.addProperties(masterWSDLPath, wsdlInfo, wsdlDefinition, wsdlResourceContent, wsdlPath, (Resource)wsdlResource);
                if (metaDataResource != null) {
                    wsdlResource.setDescription(metaDataResource.getDescription());
                }
                this.saveResource(wsdlInfo.getOriginalURL(), wsdlPath, (Resource)wsdlResource, wsdlInfo.isMasterWSDL());
                if (this.systemRegistry != null) {
                    EndpointUtils.saveEndpointsFromWSDL((RequestContext)context, (String)wsdlPath, (Resource)wsdlResource, (Registry)this.registry, (Registry)this.systemRegistry);
                }
                this.identifyAssociationsNew(wsdlInfo);
            }
        }
        catch (WSDLException e) {
            throw new RegistryException("Invalid WSDL file");
        }
        return masterWSDLPath;
    }

    private String addProperties(String masterWSDLPath, WSDLInfo wsdlInfo, Definition wsdlDefinition, byte[] wsdlResourceContent, String wsdlPath, Resource wsdlResource) throws RegistryException {
        String document;
        String name;
        if (wsdlDefinition.getQName() != null && (name = wsdlDefinition.getQName().getLocalPart()) != null) {
            wsdlResource.addProperty("registry.wsdl.Name", name);
        }
        if (wsdlDefinition.getDocumentationElement() != null && (document = wsdlDefinition.getDocumentationElement().getTextContent()) != null) {
            wsdlResource.addProperty("registry.wsdl.documentation", document);
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        wsdlResource.addProperty("registry.wsdl.TargetNamespace", targetNamespace);
        wsdlResource.setMediaType("application/wsdl+xml");
        wsdlResource.setContent((Object)wsdlResourceContent);
        if (wsdlInfo.isMasterWSDL()) {
            int i;
            ArrayList validationMessages;
            masterWSDLPath = wsdlPath;
            log.trace((Object)"Setting WSDL Validation properties");
            if (this.wsdlValidationInfo != null) {
                wsdlResource.setProperty("WSDL Validation", this.wsdlValidationInfo.getStatus());
                validationMessages = this.wsdlValidationInfo.getValidationMessages();
                if (validationMessages.size() > 0) {
                    i = 1;
                    for (String message : validationMessages) {
                        if (message == null) continue;
                        if (message.length() > 1000) {
                            message = message.substring(0, 997) + "...";
                        }
                        wsdlResource.setProperty("WSDL Validation Message " + i, message);
                        ++i;
                    }
                }
            } else if (this.hasWSDLImports) {
                wsdlResource.setProperty("WSDL Validation", "Validation is not supported for WSDLs containing WSDL imports.");
            }
            log.trace((Object)"Finished setting WSDL Validation properties");
            log.trace((Object)"Setting WSI Validation properties");
            if (this.wsiValidationInfo != null) {
                wsdlResource.setProperty("WSI Validation", this.wsiValidationInfo.getStatus());
                validationMessages = this.wsiValidationInfo.getValidationMessages();
                if (validationMessages.size() > 0) {
                    i = 1;
                    for (String message : validationMessages) {
                        if (message == null) continue;
                        if (message.length() > 1000) {
                            message = message.substring(0, 997) + "...";
                        }
                        wsdlResource.setProperty("WSI Validation Message " + i, message);
                        ++i;
                    }
                }
            } else if (this.hasWSDLImports) {
                wsdlResource.setProperty("WSI Validation", "Validation is not supported for WSDLs containing WSDL imports.");
            }
            log.trace((Object)"Finished setting WSI Validation properties");
        }
        return masterWSDLPath;
    }

    private String saveWSDLsToRepositoryNew(RequestContext context, Resource metaDataResource, String endpointEnvironment, List<String> dependenciesList, String version) throws RegistryException {
        String masterWSDLPath = null;
        try {
            for (WSDLInfo wsdlInfo : this.wsdls.values()) {
                ResourceImpl wsdlResource;
                Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
                WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
                byte[] wsdlResourceContent = byteArrayOutputStream.toByteArray();
                String wsdlPath = wsdlInfo.getProposedRegistryURL();
                if (metaDataResource != null && this.registry.resourceExists(wsdlPath)) {
                    wsdlResource = this.registry.get(wsdlPath);
                } else {
                    Properties properties;
                    wsdlResource = new ResourceImpl();
                    if (metaDataResource != null && (properties = metaDataResource.getProperties()) != null) {
                        List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            String key = (String)e.getKey();
                            if (linkProperties.contains(key)) continue;
                            wsdlResource.setProperty(key, (List)e.getValue());
                        }
                    }
                }
                if (this.registry.resourceExists(wsdlPath)) {
                    Resource oldWsdlResource = this.registry.get(wsdlPath);
                    Properties properties = oldWsdlResource.getProperties();
                    for (Map.Entry<Object, Object> e : properties.entrySet()) {
                        if (e.getValue() instanceof String) {
                            wsdlResource.setProperty((String)e.getKey(), (String)e.getValue());
                            continue;
                        }
                        wsdlResource.setProperty((String)e.getKey(), (List)e.getValue());
                    }
                }
                masterWSDLPath = this.addProperties(masterWSDLPath, wsdlInfo, wsdlDefinition, wsdlResourceContent, wsdlPath, (Resource)wsdlResource);
                if (metaDataResource != null) {
                    wsdlResource.setDescription(metaDataResource.getDescription());
                }
                this.saveResource(wsdlInfo.getOriginalURL(), wsdlPath, (Resource)wsdlResource, wsdlInfo.isMasterWSDL());
                if (this.systemRegistry != null) {
                    EndpointUtils.saveEndpointsFromWSDL((RequestContext)context, (String)wsdlPath, (Resource)wsdlResource, (Registry)this.registry, (Registry)this.systemRegistry, (String)endpointEnvironment, dependenciesList, (String)version);
                }
                this.identifyAssociationsNew(wsdlInfo);
            }
        }
        catch (WSDLException e) {
            throw new RegistryException("Invalid WSDL file");
        }
        return masterWSDLPath;
    }

    private List<OMElement> createServiceContent(String wsdlURL, Resource metadata) throws RegistryException {
        ArrayList<OMElement> serviceContentomelements = new ArrayList<OMElement>();
        if (this.originalDefinition != null) {
            Map servicesMap = this.originalDefinition.getServices();
            for (Object serviceObject : servicesMap.values()) {
                Element documentationElement;
                Service service = (Service)serviceObject;
                QName qname = service.getQName();
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMNamespace namespace = fac.createOMNamespace("http://www.wso2.org/governance/metadata", "");
                OMElement data = fac.createOMElement("metadata", namespace);
                OMElement wsdlurl = fac.createOMElement("wsdlURL", namespace);
                OMElement overview = fac.createOMElement("overview", namespace);
                OMElement interfaceelement = fac.createOMElement("interface", namespace);
                OMElement name = fac.createOMElement("name", namespace);
                name.setText(qname.getLocalPart());
                wsdlurl.setText(RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)wsdlURL));
                OMElement namespaceElement = fac.createOMElement("namespace", namespace);
                OMElement descriptionelement = fac.createOMElement("description", namespace);
                namespaceElement.setText(qname.getNamespaceURI());
                String description = metadata.getDescription();
                if (description == null && (documentationElement = this.originalDefinition.getDocumentationElement()) != null && documentationElement.getFirstChild() != null) {
                    Node firstChild = documentationElement.getFirstChild();
                    description = DOM2Writer.nodeToString((Node)firstChild);
                }
                descriptionelement.setText(description);
                overview.addChild((OMNode)name);
                overview.addChild((OMNode)namespaceElement);
                overview.addChild((OMNode)descriptionelement);
                interfaceelement.addChild((OMNode)wsdlurl);
                data.addChild((OMNode)overview);
                data.addChild((OMNode)interfaceelement);
                serviceContentomelements.add(data);
            }
        }
        return serviceContentomelements;
    }

    private void saveResource(String url, String path, Resource resource, boolean isMasterWSDL) throws RegistryException {
        log.trace((Object)"Started saving resource");
        String source = WsdlUriProcessor.getSource(path);
        GenericArtifactManager genericArtifactManager = new GenericArtifactManager(this.governanceUserRegistry, "uri");
        GenericArtifact wsdl = genericArtifactManager.newGovernanceArtifact(new QName(source));
        if (isMasterWSDL) {
            wsdl.setId(resource.getUUID());
        }
        wsdl.setAttribute("overview_name", source);
        wsdl.setAttribute("overview_uri", url);
        wsdl.setAttribute("overview_type", "WSDL");
        genericArtifactManager.addGenericArtifact(wsdl);
        log.trace((Object)"Finished saving resource");
    }

    protected SchemaUriProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        return new SchemaUriProcessor(requestContext, validationInfo);
    }

    protected SchemaUriProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo, boolean useOriginalSchema) {
        return new SchemaUriProcessor(requestContext, validationInfo, useOriginalSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(OMElement service, RequestContext context) throws RegistryException {
        Resource resource = this.registry.newResource();
        String tempNamespace = CommonUtil.derivePathFragmentFromNamespace((String)CommonUtil.getServiceNamespace((OMElement)service));
        String path = this.getChrootedServiceLocation(this.registry, context.getRegistryContext()) + tempNamespace + CommonUtil.getServiceName((OMElement)service);
        String artifactId = UUID.randomUUID().toString();
        resource.setUUID(artifactId);
        String content = service.toString();
        resource.setContent((Object)RegistryUtils.encodeString((String)content));
        resource.setMediaType("application/vnd.wso2-service+xml");
        boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
        CommonUtil.releaseUpdateLock();
        try {
            this.registry.put(path, resource);
        }
        finally {
            if (lockAlreadyAcquired) {
                CommonUtil.acquireUpdateLock();
            }
        }
        this.registry.addAssociation(path, RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL((OMElement)service)), "depends");
        this.registry.addAssociation(RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL((OMElement)service)), path, "usedBy");
    }

    public static String getSource(String uri) {
        return uri.split("/")[uri.split("/").length - 1];
    }
}

