/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators.aggregators;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;

public abstract class AbstractAggregator
implements CustomValidations {
    private static final Log log = LogFactory.getLog(AbstractAggregator.class);

    protected CustomValidations generateValidator(String input) {
        if (input != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                String[] temp = input.split(",[ ]?parameters[:]");
                String className = temp[0].substring("class:".length());
                CustomValidations customValidations = (CustomValidations)Class.forName(className, true, loader).newInstance();
                if (temp.length == 2) {
                    String[] parameterArray = temp[1].split("},");
                    String lastParameter = parameterArray[parameterArray.length - 1];
                    if (lastParameter.endsWith("}")) {
                        parameterArray[parameterArray.length - 1] = lastParameter.substring(0, lastParameter.length() - 1);
                    }
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    for (String parameter : parameterArray) {
                        String keyValuePair = parameter.substring(1);
                        int separatorIndex = keyValuePair.indexOf(":");
                        parameterMap.put(keyValuePair.substring(0, separatorIndex), keyValuePair.substring(separatorIndex + 1, keyValuePair.length()));
                    }
                    customValidations.init(parameterMap);
                }
                return customValidations;
            }
            catch (InstantiationException e) {
                log.error((Object)"Unable to instantiate validation class", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Unable to instantiate validation class", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Unable to instantiate validation class", (Throwable)e);
            }
            catch (ClassCastException e) {
                log.error((Object)"Unable to instantiate validation class", (Throwable)e);
            }
        }
        return null;
    }
}

