/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.Representation;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.xml.sax.Locator;

public class RepresentationNode
extends AbstractNode {
    Representation rep;

    public RepresentationNode(Representation r) {
        this.rep = r;
    }

    public String getMediaTypeAsClassName() {
        String mediaType = this.getMediaType();
        if (mediaType != null && mediaType.startsWith("application/")) {
            mediaType = mediaType.substring("application/".length());
        }
        return GeneratorUtil.makeClassName(mediaType);
    }

    public String getMediaType() {
        return this.rep.getMediaType();
    }

    public List<String> getProfiles() {
        return this.rep.getProfile();
    }

    public QName getElement() {
        return this.rep.getElement();
    }

    public List<Param> getParam() {
        return this.rep.getParam();
    }

    public List<Doc> getDoc() {
        return this.rep.getDoc();
    }

    public String getId() {
        return this.rep.getId();
    }

    @Override
    public Locator getLocation() {
        return this.rep.sourceLocation();
    }

    public String getOtherAttribute(QName attribute) {
        return this.rep.getOtherAttributes().get(attribute);
    }
}

