/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java.common;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ParamStyle;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.PathSegment;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl.util.MessageListener;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.jvnet.ws.wadl2java.JavaDocUtil;
import org.jvnet.ws.wadl2java.Resolver;
import org.jvnet.ws.wadl2java.ResourceClassGenerator;
import org.jvnet.ws.wadl2java.Wadl2Java;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;

public abstract class BaseResourceClassGenerator
implements ResourceClassGenerator {
    protected static final String CREATE_CLIENT_METHOD = "createClient";
    protected static final String CUSTOMIZE_CLIENT_METHOD = "customizeClientConfiguration";
    protected static final String CREATE_CLIENT_INSTANCE = "createClientInstance";
    private ResourceNode resource;
    protected JPackage pkg;
    private Resolver resolver;
    protected JCodeModel codeModel;
    private JFieldVar $clientReference;
    private JFieldVar $uriBuilder;
    private JFieldVar $templateMatrixParamValMap;
    private JDefinedClass $class = null;
    private JavaDocUtil javaDoc;
    private String generatedPackages;
    private MessageListener messageListener;

    public BaseResourceClassGenerator(MessageListener messageListener, Resolver resolver, JCodeModel codeModel, JPackage pkg, String generatedPackages, JavaDocUtil javaDoc, ResourceNode resource) {
        this.messageListener = messageListener;
        this.resource = resource;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.resolver = resolver;
        this.pkg = pkg;
        this.generatedPackages = generatedPackages;
    }

    public BaseResourceClassGenerator(MessageListener messageListener, Resolver resolver, JCodeModel codeModel, JPackage pkg, String generatedPackages, JavaDocUtil javaDoc, JDefinedClass clazz) {
        this.messageListener = messageListener;
        this.resource = null;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.resolver = resolver;
        this.pkg = pkg;
        this.$class = clazz;
        this.generatedPackages = generatedPackages;
    }

    protected abstract void generateClientFactoryMethod(JDefinedClass var1);

    protected JDefinedClass getGeneratedClass() {
        return this.$class;
    }

    protected abstract JClass clientType();

    protected abstract JClass clientFactoryType();

    protected abstract String clientFactoryMethod();

    protected abstract JClass clientResponseClientType();

    protected abstract JClass genericTypeType();

    protected abstract JClass resourceType();

    protected abstract JClass uriTemplateType();

    protected abstract String resourceFromClientMethod();

    protected abstract JClass resourceBuilderType();

    protected abstract String buildMethod();

    protected abstract String responseGetEntityMethod();

    protected JClass webApplicationExceptionType() {
        JDefinedClass owningClass = this.$class;
        while (!(owningClass.parentContainer() instanceof JPackage)) {
            owningClass = (JDefinedClass)owningClass.parentContainer();
        }
        try {
            JDefinedClass $exception = owningClass._class(20, "WebApplicationExceptionMessage");
            $exception._extends(this.codeModel.ref(WebApplicationException.class));
            $exception.javadoc().append((Object)"Workaround for JAX_RS_SPEC-312");
            JClass $responseClass = this.codeModel.ref(Response.class);
            JMethod $constructor = $exception.constructor(4);
            JVar param = $constructor.param((JType)$responseClass, "response");
            $constructor.body().directStatement("super(response);");
            this.overrideMessageOnException($exception);
            JMethod $toString = $exception.method(1, String.class, "toString");
            JBlock $body = $toString.body();
            JVar $s = $body.decl((JType)this.codeModel.ref(String.class), "s", JExpr.lit((String)WebApplicationException.class.getName()));
            JVar $message = $body.decl((JType)this.codeModel.ref(String.class), "message", (JExpression)JExpr.invoke((String)"getLocalizedMessage"));
            $body._return(JOp.plus((JExpression)$s, (JExpression)JOp.plus((JExpression)JExpr.lit((String)": "), (JExpression)$message)));
            return $exception;
        }
        catch (JClassAlreadyExistsException ex) {
            return ex.getExistingClass();
        }
    }

    protected void overrideMessageOnException(JDefinedClass $exception) {
        JClass $responseClass = this.codeModel.ref(Response.class);
        JMethod $getMessage = $exception.method(1, String.class, "getMessage");
        $getMessage.javadoc().append((Object)"Workaround for JAX_RS_SPEC-312");
        JBlock $body = $getMessage.body();
        JVar $response = $body.decl((JType)$responseClass, "response", (JExpression)JExpr.invoke((String)"getResponse"));
        JClass $statusClass = this.codeModel.ref(Response.Status.class);
        JVar $status = $body.decl((JType)$statusClass, "status", (JExpression)$statusClass.staticInvoke("fromStatusCode").arg((JExpression)$response.invoke("getStatus")));
        JConditional $if = $body._if(JOp.ne((JExpression)$status, (JExpression)JExpr._null()));
        $if._then()._return(JOp.plus((JExpression)$response.invoke("getStatus"), (JExpression)JOp.plus((JExpression)JExpr.lit((String)" "), (JExpression)$status.invoke("getReasonPhrase"))));
        $if._else()._return((JExpression)this.codeModel.ref(Integer.class).staticInvoke("toString").arg((JExpression)$response.invoke("getStatus")));
    }

    protected abstract JVar createRequestBuilderAndAccept(JBlock var1, JVar var2, RepresentationNode var3);

    protected abstract JExpression[] createProcessInvocation(MethodNode var1, JBlock var2, JVar var3, String var4, RepresentationNode var5, JType var6, JExpression var7, JExpression var8);

    private boolean validClassName(JClass parentClass, String className) {
        while (parentClass != null) {
            if (parentClass.name().equals(className)) {
                return false;
            }
            if ((parentClass = parentClass.outer()) == null) continue;
            boolean bl = false;
        }
        return true;
    }

    @Override
    public JDefinedClass generateClass(JDefinedClass parentClass, JVar $global_base_uri) throws JClassAlreadyExistsException {
        String className;
        String originalClassName = className = this.resource.getClassName();
        for (JDefinedClass owner = parentClass; owner != null && !this.validClassName((JClass)parentClass, className); owner = owner.outer()) {
            className = owner.name() + className;
        }
        String classNameRoot = className;
        int nameCounter = 0;
        JDefinedClass $impl = null;
        do {
            className = nameCounter++ <= 0 ? classNameRoot : classNameRoot + nameCounter;
            try {
                $impl = parentClass._class(17, className);
            }
            catch (JClassAlreadyExistsException cad) {
                // empty catch block
            }
        } while ($impl == null);
        if (!originalClassName.equals(className)) {
            this.resource.setClassName(className);
        }
        for (ResourceTypeNode t : this.resource.getResourceTypes()) {
            $impl._implements((JClass)t.getGeneratedInterface());
        }
        this.javaDoc.generateClassDoc(this.resource, $impl);
        this.$clientReference = $impl.field(4, (JType)this.clientType(), "_client");
        JClass uriBuilderClass = this.codeModel.ref(UriBuilder.class);
        this.$uriBuilder = $impl.field(4, (JType)uriBuilderClass, "_uriBuilder");
        JClass mapOfStringObject = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JClass hashMapOfStringObject = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
        this.$templateMatrixParamValMap = $impl.field(4, (JType)mapOfStringObject, "_templateAndMatrixParameterValues");
        JMethod $ctorCopy = $impl.constructor(4);
        JVar $clientCopyParam = $ctorCopy.param((JType)this.clientType(), "client");
        JVar $uriBuilderCopyParam = $ctorCopy.param((JType)uriBuilderClass, "uriBuilder");
        JVar $mapCopyParam = $ctorCopy.param((JType)mapOfStringObject, "map");
        JBlock $ctorCopyBody = $ctorCopy.body();
        $ctorCopyBody.assign((JAssignmentTarget)this.$clientReference, (JExpression)$clientCopyParam);
        $ctorCopyBody.assign((JAssignmentTarget)this.$uriBuilder, (JExpression)$uriBuilderCopyParam.invoke("clone"));
        $ctorCopyBody.assign((JAssignmentTarget)this.$templateMatrixParamValMap, (JExpression)$mapCopyParam);
        if (this.resource.getParentResource() != null) {
            boolean outer = !parentClass.fields().containsKey("_client");
            String accessorName = GeneratorUtil.escapeReservedWord(Character.toLowerCase(className.charAt(0)) + className.substring(1));
            JMethod $accessorMethod = parentClass.method(outer ? 17 : 1, (JType)$impl, accessorName);
            this.javaDoc.generateAccessorDoc(this.resource, $accessorMethod);
            JVar $clientAccessorParam = null;
            JVar $baseURIParam = null;
            if (outer) {
                $clientAccessorParam = $accessorMethod.param((JType)this.clientType(), "client");
                $baseURIParam = $accessorMethod.param(URI.class, "baseURI");
            }
            this.generateParameterForPathSegment(this.resource.getPathSegment(), $accessorMethod, false, $impl);
            JBlock $accessorBody = $accessorMethod.body();
            JInvocation invoke = JExpr._new((JClass)$impl);
            $accessorBody._return((JExpression)invoke);
            if (!outer) {
                invoke.arg((JExpression)this.$clientReference);
                invoke.arg((JExpression)this.$uriBuilder.invoke("buildFromMap").arg((JExpression)this.$templateMatrixParamValMap));
            } else {
                invoke.arg((JExpression)$clientAccessorParam);
            }
            for (JVar var : $accessorMethod.listParams()) {
                if (outer && "client".equals(var.name())) continue;
                invoke.arg((JExpression)var);
            }
            if (outer) {
                boolean found = false;
                for (JMethod next : parentClass.methods()) {
                    if (!next.name().equals(CREATE_CLIENT_METHOD)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.generateClientFactoryMethod(parentClass);
                }
                JMethod $accessorMethodNoClient = parentClass.method(17, (JType)$impl, accessorName);
                this.javaDoc.generateAccessorDoc(this.resource, $accessorMethodNoClient);
                JVar[] originalParams = $accessorMethod.listParams();
                for (int counter = 2; counter < originalParams.length; ++counter) {
                    $accessorMethodNoClient.param(originalParams[counter].type(), originalParams[counter].name());
                }
                JBlock $noClientBody = $accessorMethodNoClient.body();
                JInvocation $invokeOther = JExpr.invoke((JMethod)$accessorMethod);
                $noClientBody._return((JExpression)$invokeOther);
                $invokeOther.arg((JExpression)JExpr.invoke((String)CREATE_CLIENT_METHOD));
                $invokeOther.arg((JExpression)$global_base_uri);
                for (JVar next : $accessorMethodNoClient.listParams()) {
                    $invokeOther.arg((JExpression)next);
                }
                JMethod $accessorMethodNoClient2 = parentClass.method(17, (JType)$impl, accessorName);
                this.javaDoc.generateAccessorDoc(this.resource, $accessorMethodNoClient2);
                JVar[] originalParams2 = $accessorMethod.listParams();
                for (int counter = 0; counter < originalParams2.length; ++counter) {
                    if (counter == 1) continue;
                    $accessorMethodNoClient2.param(originalParams2[counter].type(), originalParams2[counter].name());
                }
                JBlock $noClientBody2 = $accessorMethodNoClient2.body();
                JInvocation $invokeOther2 = JExpr.invoke((JMethod)$accessorMethod);
                $noClientBody2._return((JExpression)$invokeOther2);
                JVar[] listParams = $accessorMethodNoClient2.listParams();
                for (int param = 0; param < listParams.length; ++param) {
                    JVar next = listParams[param];
                    $invokeOther2.arg((JExpression)next);
                    if (param != 0) continue;
                    $invokeOther2.arg((JExpression)$global_base_uri);
                }
            }
        }
        PathSegment segment = this.resource.getPathSegment();
        boolean contructorHasParameters = false;
        JMethod $ctor = $impl.constructor(1);
        JDocComment jdoc = $ctor.javadoc();
        jdoc.append((Object)Wadl2JavaMessages.CREATE_INSTANCE_CLIENT());
        JVar $clientParam = $ctor.param(this.$clientReference.type(), "client");
        JVar $uriParam = $ctor.param((JType)this.codeModel.ref(URI.class), "baseUri");
        contructorHasParameters = this.generateParameterForPathSegment(this.resource.getPathSegment(), $ctor, true, $impl);
        JBlock $ctorBody = $ctor.body();
        $ctorBody.assign((JAssignmentTarget)this.$clientReference, (JExpression)$clientParam);
        $ctorBody.assign((JAssignmentTarget)this.$uriBuilder, (JExpression)uriBuilderClass.staticInvoke("fromUri").arg((JExpression)$uriParam));
        $ctorBody.assign((JAssignmentTarget)this.$uriBuilder, (JExpression)this.$uriBuilder.invoke("path").arg(JExpr.lit((String)segment.getTemplate())));
        $ctorBody.assign((JAssignmentTarget)this.$templateMatrixParamValMap, (JExpression)JExpr._new((JClass)hashMapOfStringObject));
        for (Param p : segment.getTemplateParameters()) {
            $ctorBody.invoke((JExpression)this.$templateMatrixParamValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)GeneratorUtil.makeParamName(p.getName())));
        }
        for (Param p : segment.getMatrixParameters()) {
            if (p.isRequired() != Boolean.TRUE.booleanValue()) continue;
            $ctorBody.invoke((JExpression)this.$templateMatrixParamValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)GeneratorUtil.makeParamName(p.getName())));
        }
        if (contructorHasParameters) {
            $ctor = $impl.constructor(1);
            jdoc = $ctor.javadoc();
            jdoc.append((Object)Wadl2JavaMessages.CREATE_INSTANCE_CLIENT_URI());
            $clientParam = $ctor.param(this.$clientReference.type(), "client");
            $uriParam = $ctor.param((JType)this.codeModel.ref(URI.class), "uri");
            $ctorBody = $ctor.body();
            $ctorBody.assign((JAssignmentTarget)this.$clientReference, (JExpression)$clientParam);
            String uriPart = this.resource.getAllResourceUriTemplate();
            JVar $template = $ctorBody.decl(this.codeModel._ref(StringBuilder.class), "template", (JExpression)JExpr._new((JType)this.codeModel._ref(StringBuilder.class)).arg((JExpression)$global_base_uri.invoke("toString")));
            JConditional $endsWithSlash = $ctorBody._if(JOp.ne((JExpression)$template.invoke("charAt").arg(JOp.minus((JExpression)$template.invoke("length"), (JExpression)JExpr.lit((int)1))), (JExpression)JExpr.lit((char)'/')));
            $endsWithSlash._then().invoke((JExpression)$template, "append").arg(uriPart);
            $endsWithSlash._else().invoke((JExpression)$template, "append").arg(uriPart.substring(1));
            $ctorBody.assign((JAssignmentTarget)this.$uriBuilder, (JExpression)uriBuilderClass.staticInvoke("fromPath").arg((JExpression)$template.invoke("toString")));
            $ctorBody.assign((JAssignmentTarget)this.$templateMatrixParamValMap, (JExpression)JExpr._new((JClass)hashMapOfStringObject));
            JClass hashMapOfStringString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, String.class});
            JClass $uriTemplate = this.uriTemplateType();
            JVar $uriTemplateInstance = $ctorBody.decl((JType)$uriTemplate, "uriTemplate", (JExpression)JExpr._new((JType)$uriTemplate).arg((JExpression)$template.invoke("toString")));
            JVar $extractedParameters = $ctorBody.decl((JType)hashMapOfStringString, "parameters", (JExpression)JExpr._new((JClass)hashMapOfStringString));
            $ctorBody.invoke((JExpression)$uriTemplateInstance, "match").arg((JExpression)$uriParam.invoke("toString")).arg((JExpression)$extractedParameters);
            $ctorBody.invoke((JExpression)this.$templateMatrixParamValMap, "putAll").arg((JExpression)$extractedParameters);
        }
        this.$class = $impl;
        return this.$class;
    }

    private boolean generateParameterForPathSegment(PathSegment segment, JMethod method, boolean generateBeanDefinitions, JDefinedClass contextClass) {
        boolean required = false;
        List<Param> matrixParameters = segment.getMatrixParameters();
        for (Param p : segment.getTemplateParameters()) {
            method.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, contextClass, this.javaDoc), GeneratorUtil.makeParamName(p.getName()));
            required = true;
            this.javaDoc.generateParamDoc(p, method);
            if (!generateBeanDefinitions) continue;
            this.generateBeanProperty(contextClass, matrixParameters, p, false);
        }
        for (Param p : matrixParameters) {
            if (p.isRequired() == Boolean.TRUE.booleanValue()) {
                required = true;
                method.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, contextClass, this.javaDoc), GeneratorUtil.makeParamName(p.getName()));
                this.javaDoc.generateParamDoc(p, method);
            }
            if (!generateBeanDefinitions) continue;
            this.generateBeanProperty(contextClass, matrixParameters, p, false);
        }
        return required;
    }

    protected JDefinedClass generateExceptionClass(FaultNode f) {
        JDefinedClass $exCls;
        String exName = f.getClassName();
        try {
            $exCls = this.generateExceptionClassInternal(exName, f);
        }
        catch (JClassAlreadyExistsException ex) {
            $exCls = ex.getExistingClass();
        }
        return $exCls;
    }

    protected abstract JDefinedClass generateExceptionClassInternal(String var1, FaultNode var2) throws JClassAlreadyExistsException;

    protected abstract void generateThrowWebApplicationExceptionFromResponse(JBlock var1, JVar var2);

    protected void generateConditionalForFaultNode(MethodNode method, JBlock $methodBody, JVar $response, JType returnType, JExpression $returnTypeExpr) {
        Set statusCodes = method.getFaults().keySet();
        if (statusCodes.size() > 0) {
            JSwitch sw = $methodBody._switch((JExpression)$response.invoke("getStatus"));
            for (List statusCode : statusCodes) {
                JCase last = null;
                Iterator it = statusCode.iterator();
                while (it.hasNext()) {
                    int code = ((Long)it.next()).intValue();
                    last = sw._case(JExpr.lit((int)code));
                }
                if (last == null) continue;
                JBlock caseBody = last.body();
                FaultNode fn = (FaultNode)method.getFaults().getFirst((Object)statusCode);
                if (fn.getElement() != null) {
                    JClass rawType = (JClass)this.getTypeFromElement(fn.getElement());
                    JDefinedClass exception = this.generateExceptionClass(fn);
                    caseBody._throw((JExpression)JExpr._new((JClass)exception).arg((JExpression)$response).arg((JExpression)$response.invoke(this.responseGetEntityMethod()).arg(this.toClassLiteral((JType)rawType))));
                    continue;
                }
                this.generateThrowWebApplicationExceptionFromResponse(caseBody, $response);
                caseBody._break();
            }
            JCase defaultCase = sw._default();
            JBlock caseBody = defaultCase.body();
            this.generateIfOnStatus(caseBody, $response, returnType, $returnTypeExpr);
        } else {
            this.generateIfOnStatus($methodBody, $response, returnType, $returnTypeExpr);
        }
    }

    protected void generateIfOnStatus(JBlock block, JVar $response, JType returnType, JExpression $returnTypeExpr) {
        if (returnType != this.clientResponseClientType()) {
            JVar rType;
            JType type;
            JBlock body = block;
            if ($returnTypeExpr instanceof JVar && (type = (rType = (JVar)$returnTypeExpr).type().erasure()) == this.codeModel._ref(Class.class)) {
                body = block._if(JExpr.dotclass((JClass)this.clientResponseClientType()).invoke("isAssignableFrom").arg($returnTypeExpr).not())._then();
            }
            JBlock then = body._if($response.invoke("getStatus").gte(JExpr.lit((int)400)))._then();
            this.generateThrowWebApplicationExceptionFromResponse(then, $response);
        }
    }

    @Override
    public void generateMethodDecls(MethodNode method, boolean isAbstract) {
        block13: {
            HashMap<JType, JDefinedClass> exceptionMap;
            ArrayList<RepresentationNode> supportedOutputs;
            List<RepresentationNode> supportedInputs;
            block11: {
                block12: {
                    supportedInputs = method.getSupportedInputs();
                    supportedOutputs = new ArrayList<RepresentationNode>();
                    for (List nodeList : method.getSupportedOutputs().values()) {
                        for (RepresentationNode node : nodeList) {
                            supportedOutputs.add(node);
                        }
                    }
                    exceptionMap = new HashMap<JType, JDefinedClass>();
                    for (List fl : method.getFaults().values()) {
                        for (FaultNode f : fl) {
                            if (f.getElement() == null) {
                                this.messageListener.info(Wadl2JavaMessages.FAULT_NO_ELEMENT());
                                continue;
                            }
                            JDefinedClass generatedException = this.generateExceptionClass(f);
                            JType rawType = this.getTypeFromElement(f.getElement());
                            JType faultType = rawType == null ? this.codeModel._ref(Object.class) : rawType;
                            exceptionMap.put(faultType, generatedException);
                        }
                    }
                    if (!supportedInputs.isEmpty()) break block11;
                    if (!supportedOutputs.isEmpty()) break block12;
                    this.generateMethodVariants(exceptionMap, method, false, null, null, isAbstract);
                    if (!method.hasOptionalParameters()) break block13;
                    this.generateMethodVariants(exceptionMap, method, true, null, null, isAbstract);
                    break block13;
                }
                for (RepresentationNode returnType : supportedOutputs) {
                    this.generateMethodVariants(exceptionMap, method, false, null, returnType, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, null, returnType, isAbstract);
                }
                break block13;
            }
            for (RepresentationNode inputType : supportedInputs) {
                if (supportedOutputs.size() == 0) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, null, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, null, isAbstract);
                    continue;
                }
                RepresentationNode matchingReturn = null;
                for (RepresentationNode returnType : supportedOutputs) {
                    if (!inputType.getMediaType().equals(returnType.getMediaType())) continue;
                    matchingReturn = returnType;
                    break;
                }
                if (matchingReturn != null) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, matchingReturn, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, matchingReturn, isAbstract);
                    continue;
                }
                for (RepresentationNode returnType : supportedOutputs) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, returnType, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, returnType, isAbstract);
                }
            }
        }
    }

    protected JType getTypeFromElement(QName element) {
        JType type = this.resolver.resolve(element);
        if (type == null) {
            this.messageListener.info(Wadl2JavaMessages.ELEMENT_NOT_FOUND(element.toString()));
        }
        return type;
    }

    protected JType getTypeFromURI(String path) {
        URI uri = this.resolver.resolveURI(this.resource, path);
        JType type = this.resolver.resolve(uri);
        if (type == null) {
            this.messageListener.info(Wadl2JavaMessages.ELEMENT_NOT_FOUND(uri.toString()));
        }
        return type;
    }

    protected void generateMethodVariants(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        this.generateMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, MethodType.JAXB_MAPPING, isAbstract);
        this.generateMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, MethodType.JSON_POJO_MAPPING, isAbstract);
        this.generateMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, MethodType.GENERIC_TYPE, isAbstract);
        this.generateMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, MethodType.CLASS, isAbstract);
    }

    protected String getMethodName(MethodNode method, RepresentationNode inputRep, RepresentationNode outputRep, JType returnType) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName().toLowerCase());
        boolean outputMediaSameAsInput = false;
        if (inputRep != null && inputRep.getMediaType() != null && outputRep != null && inputRep.getMediaType().equals(outputRep.getMediaType())) {
            outputMediaSameAsInput = true;
        }
        if (inputRep != null) {
            if (inputRep.getId() != null) {
                buf.append(inputRep.getId().substring(0, 1).toUpperCase());
                buf.append(inputRep.getId().substring(1).toLowerCase());
            } else {
                buf.append(inputRep.getMediaTypeAsClassName());
            }
        }
        if (returnType != null) {
            ArrayList<RepresentationNode> supportedOutputs = new ArrayList<RepresentationNode>();
            for (List nodeList : method.getSupportedOutputs().values()) {
                for (RepresentationNode node : nodeList) {
                    supportedOutputs.add(node);
                }
            }
            if (returnType != this.clientResponseClientType()) {
                if (supportedOutputs.size() > 1 && outputRep != null) {
                    buf.append("As");
                    buf.append(returnType.name());
                    if (!outputMediaSameAsInput) {
                        buf.append(outputRep.getMediaTypeAsClassName());
                    }
                } else {
                    buf.append("As");
                    buf.append(returnType.name());
                }
            }
        } else if (outputRep != null && !outputMediaSameAsInput) {
            buf.append("As");
            buf.append(outputRep.getMediaTypeAsClassName());
        }
        return GeneratorUtil.escapeReservedWord(buf.toString());
    }

    protected void generateMethodDecl(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, MethodType methodType, boolean isAbstract) {
        JClass returnType;
        boolean isJSONPOJOMapping;
        boolean isJAXBMapping = methodType == MethodType.JAXB_MAPPING;
        boolean bl = isJSONPOJOMapping = methodType == MethodType.JSON_POJO_MAPPING;
        if (isJAXBMapping && (outputRep != null && outputRep.getElement() == null || inputRep != null && inputRep.getElement() == null)) {
            return;
        }
        if (isJSONPOJOMapping) {
            if (outputRep != null && outputRep.getOtherAttribute(Wadl2Java.JSON_SCHEMA_DESCRIBEDBY) == null || inputRep != null && inputRep.getOtherAttribute(Wadl2Java.JSON_SCHEMA_DESCRIBEDBY) == null) {
                return;
            }
            if (inputRep == null && outputRep == null) {
                return;
            }
            boolean i = false;
        }
        JType inputType = null;
        boolean wrapInputTypeInJAXBElement = false;
        boolean genericReturnType = false;
        if (isJAXBMapping) {
            if (inputRep != null) {
                inputType = this.getTypeFromElement(inputRep.getElement());
                if (inputType instanceof JDefinedClass) {
                    boolean isRootElement = false;
                    boolean isXmlType = false;
                    try {
                        Field annotationClassField = JAnnotationUse.class.getDeclaredField("clazz");
                        annotationClassField.setAccessible(true);
                        Field annotationField = JDefinedClass.class.getDeclaredField("annotations");
                        annotationField.setAccessible(true);
                        List annotations = (List)annotationField.get(inputType);
                        for (JAnnotationUse use : annotations) {
                            JClass annotationClass = (JClass)annotationClassField.get(use);
                            if (annotationClass.fullName().equals(XmlRootElement.class.getName())) {
                                isRootElement = true;
                            }
                            if (!annotationClass.fullName().equals(XmlType.class.getName())) continue;
                            isXmlType = true;
                        }
                    }
                    catch (Exception ex) {
                        this.messageListener.warning("Internal error", ex);
                    }
                    boolean bl2 = wrapInputTypeInJAXBElement = !isRootElement && isXmlType;
                }
                if (inputType == null) {
                    return;
                }
            }
            if (outputRep != null) {
                returnType = this.getTypeFromElement(outputRep.getElement());
                if (returnType == null) {
                    return;
                }
            } else {
                returnType = this.clientResponseClientType();
            }
        } else if (isJSONPOJOMapping) {
            if (inputRep != null && (inputType = this.getTypeFromURI(inputRep.getOtherAttribute(Wadl2Java.JSON_SCHEMA_DESCRIBEDBY))) == null) {
                return;
            }
            if (outputRep != null) {
                returnType = this.getTypeFromURI(outputRep.getOtherAttribute(Wadl2Java.JSON_SCHEMA_DESCRIBEDBY));
                if (returnType == null) {
                    return;
                }
            } else {
                returnType = this.clientResponseClientType();
            }
        } else {
            if (inputRep != null) {
                inputType = this.codeModel.ref(Object.class);
            }
            if (outputRep != null) {
                genericReturnType = true;
                returnType = this.codeModel.ref(Object.class);
            } else {
                genericReturnType = true;
                returnType = this.codeModel.ref(Object.class);
            }
        }
        String methodName = this.getMethodName(method, inputRep, outputRep, (JType)(isJAXBMapping || isJSONPOJOMapping ? returnType : null));
        JMethod $genMethod = this.$class.method(1, (JType)returnType, methodName);
        this.javaDoc.generateMethodDoc(method, $genMethod);
        if (outputRep != null) {
            this.javaDoc.generateReturnDoc(outputRep, $genMethod);
        }
        for (JDefinedClass $ex : exceptionMap.values()) {
            $genMethod._throws((JClass)$ex);
        }
        if (inputType != null) {
            $genMethod.param(inputType, "input");
            this.javaDoc.generateParamDoc(inputRep, $genMethod);
        }
        List<Param> params = method.getRequiredParameters();
        if (includeOptionalParams) {
            params.addAll(method.getOptionalParameters());
        }
        for (Param q : params) {
            if (q.getFixed() != null || q.getStyle() == ParamStyle.MATRIX) continue;
            JClass javaType = GeneratorUtil.getJavaType(q, this.codeModel, this.$class, this.javaDoc);
            String paramName = q.getName().equals("input") ? "queryInput" : q.getName();
            q.setName(paramName);
            this.javaDoc.generateParamDoc(q, $genMethod);
            if (q.isRepeating() == Boolean.TRUE.booleanValue()) {
                $genMethod.param((JType)this.codeModel.ref(List.class).narrow(javaType), GeneratorUtil.makeParamName(q.getName()));
                continue;
            }
            $genMethod.param((JType)javaType, GeneratorUtil.makeParamName(q.getName()));
        }
        JVar $genericMethodParameter = null;
        if (genericReturnType) {
            JTypeVar $genericParameter = $genMethod.generify("T");
            $genMethod.type((JType)$genericParameter);
            JClass baseParameter = methodType == MethodType.CLASS ? this.codeModel.ref(Class.class) : this.genericTypeType();
            JClass specificParameter = baseParameter.narrow((JClass)$genericParameter);
            $genericMethodParameter = $genMethod.param((JType)specificParameter, "returnType");
        }
        List<Param> matrixOnOwningResource = Collections.EMPTY_LIST;
        if (method.getOwningResource() != null) {
            matrixOnOwningResource = method.getOwningResource().getPathSegment().getMatrixParameters();
        }
        if (!isAbstract) {
            JBlock $throwBlock;
            JBlock $methodBody = $genMethod.body();
            JClass mapOfString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $localUriBuilder = $methodBody.decl(this.$uriBuilder.type(), "localUriBuilder", (JExpression)this.$uriBuilder.invoke("clone"));
            for (Param q : params) {
                JExpression toSet;
                boolean matrix;
                if (!includeOptionalParams && q.isRequired() == Boolean.FALSE.booleanValue() && q.getFixed() == null) continue;
                boolean bl3 = matrix = q.getStyle() == ParamStyle.MATRIX;
                if (matrix && !matrixOnOwningResource.contains(q) || q.getStyle() != ParamStyle.QUERY && !matrix) continue;
                if (q.getFixed() != null) {
                    toSet = JExpr.lit((String)q.getFixed());
                } else {
                    String paramName = GeneratorUtil.makeParamName(q.getName());
                    if (matrix) {
                        toSet = this.$templateMatrixParamValMap.invoke("get").arg(JExpr.lit((String)q.getName()));
                    } else {
                        JFieldRef $paramArg = JExpr.ref((String)paramName);
                        toSet = $paramArg;
                    }
                    if (q.isRequired() == Boolean.TRUE.booleanValue()) {
                        $throwBlock = $methodBody._if(toSet.eq(JExpr._null()))._then();
                        $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                    }
                }
                JBlock $throwBlock2 = $methodBody._if(toSet.eq(JExpr._null()))._then();
                JConditional iffy = $methodBody._if(JOp.ne((JExpression)toSet, (JExpression)JExpr._null()));
                String replaceMethodName = matrix ? "replaceMatrixParam" : "replaceQueryParam";
                iffy._then().assign((JAssignmentTarget)$localUriBuilder, (JExpression)$localUriBuilder.invoke(replaceMethodName).arg(q.getName()).arg((JExpression)(q.isRepeating() ? JExpr.cast((JType)this.codeModel.ref(Object[].class), (JExpression)toSet.invoke("toArray")) : toSet)));
                iffy._else().assign((JAssignmentTarget)$localUriBuilder, (JExpression)$localUriBuilder.invoke(replaceMethodName).arg(q.getName()).arg((JExpression)JExpr.cast((JType)this.codeModel.ref(Object[].class), (JExpression)JExpr._null())));
            }
            JVar $resource = $methodBody.decl((JType)this.resourceType(), "resource", (JExpression)this.$clientReference.invoke(this.resourceFromClientMethod()).arg((JExpression)$localUriBuilder.invoke("buildFromMap").arg((JExpression)this.$templateMatrixParamValMap)));
            JVar $resourceBuilder = this.createRequestBuilderAndAccept($methodBody, $resource, outputRep);
            for (Param q : params) {
                if (!includeOptionalParams && q.isRequired() == Boolean.FALSE.booleanValue() && q.getFixed() == null || q.getStyle() != ParamStyle.HEADER) continue;
                JFieldRef $paramArg = JExpr.ref((String)GeneratorUtil.makeParamName(q.getName()));
                if (q.isRequired() == Boolean.TRUE.booleanValue() && q.getFixed() == null) {
                    $throwBlock = $methodBody._if($paramArg.eq(JExpr._null()))._then();
                    $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                }
                Object toSet = q.getFixed() != null ? JExpr.lit((String)q.getFixed()) : $paramArg;
                $methodBody._if(toSet.ne(JExpr._null()))._then().assign((JAssignmentTarget)$resourceBuilder, (JExpression)$resourceBuilder.invoke("header").arg(q.getName()).arg((JExpression)(q.isRepeating() ? toSet.invoke("toArray") : toSet)));
            }
            this.generateBody(method, isJAXBMapping, exceptionMap, outputRep, $genericMethodParameter, wrapInputTypeInJAXBElement, inputType, (JType)returnType, $resourceBuilder, inputRep, $methodBody);
        }
    }

    private JExpression toClassLiteral(JType type) {
        if (type instanceof JClass) {
            return JExpr.dotclass((JClass)((JClass)type));
        }
        if (type instanceof JPrimitiveType) {
            return JExpr.dotclass((JClass)((JPrimitiveType)type).boxify());
        }
        return JExpr.dotclass((JClass)this.codeModel.ref(Object.class));
    }

    protected void generateBody(MethodNode method, boolean isJAXB, Map<JType, JDefinedClass> exceptionMap, RepresentationNode outputRep, JVar $genericMethodParameter, boolean wrapInputTypeInJAXBElement, JType inputType, JType returnType, JVar $resourceBuilder, RepresentationNode inputRep, JBlock $methodBody) {
        String methodString = method.getName();
        JVar $returnTypeExpr = null;
        JFieldRef $entityExpr = null;
        if ($genericMethodParameter != null) {
            $returnTypeExpr = $genericMethodParameter;
        } else if (returnType != null) {
            $returnTypeExpr = this.toClassLiteral(returnType);
        }
        if (inputRep != null) {
            if (wrapInputTypeInJAXBElement) {
                JInvocation jaxbe = JExpr._new((JClass)this.codeModel.ref(JAXBElement.class)).arg((JExpression)JExpr._new((JClass)this.codeModel.ref(QName.class)).arg(inputRep.getElement().getNamespaceURI()).arg(inputRep.getElement().getLocalPart())).arg(this.toClassLiteral(inputType)).arg((JExpression)JExpr.ref((String)"input"));
                $entityExpr = jaxbe;
            } else {
                $entityExpr = JExpr.ref((String)"input");
            }
        }
        JExpression[] executeDetails = this.createProcessInvocation(method, $methodBody, $resourceBuilder, methodString, inputRep, returnType, (JExpression)$returnTypeExpr, (JExpression)$entityExpr);
        if (outputRep != null || !isJAXB || !returnType.equals(this.codeModel.VOID)) {
            JVar rType;
            JType type;
            JBlock body = $methodBody;
            if (executeDetails.length == 2 && $returnTypeExpr instanceof JVar && (type = (rType = $returnTypeExpr).type().erasure()) == this.codeModel._ref(Class.class)) {
                JConditional _if = $methodBody._if(JExpr.dotclass((JClass)this.clientResponseClientType()).invoke("isAssignableFrom").arg((JExpression)$returnTypeExpr).not());
                body = _if._then();
                _if._else()._return((JExpression)rType.invoke("cast").arg(executeDetails[1]));
            }
            body._return(executeDetails[0]);
        }
    }

    @Override
    public void generateBeanProperty(JDefinedClass $impl, List<Param> matrixParameters, Param p, boolean isAbstract) {
        JClass rawType = GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc);
        JClass propertyType = p.isRepeating() ? this.codeModel.ref(List.class).narrow(rawType) : rawType;
        String paramName = GeneratorUtil.makeParamName(p.getName());
        String propertyName = paramName.startsWith("_") && !"_class".equals(paramName) ? paramName.substring(1) : paramName;
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        JMethod $getter = $impl.method(1, (JType)propertyType, "get" + propertyName);
        JDocComment jdoc = $getter.javadoc();
        jdoc.append((Object)("Get " + p.getName()));
        this.javaDoc.generateReturnDoc(p, $getter);
        if (!isAbstract) {
            JBlock $getterBody = $getter.body();
            $getterBody._return((JExpression)JExpr.cast((JType)propertyType, (JExpression)this.$templateMatrixParamValMap.invoke("get").arg(JExpr.lit((String)p.getName()))));
        }
        JMethod $setter = $impl.method(1, (JType)$impl, "set" + propertyName);
        jdoc = $setter.javadoc();
        jdoc.append((Object)("Duplicate state and set " + p.getName()));
        $setter.param((JType)propertyType, paramName);
        this.javaDoc.generateParamDoc(p, $setter);
        if (!isAbstract) {
            JBlock $setterBody = $setter.body();
            if (p.isRequired() == Boolean.TRUE.booleanValue()) {
                JBlock $throwBlock = $setterBody._if(JExpr.ref((String)paramName).eq(JExpr._null()))._then();
                $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(p.getName(), $setter.name()))));
            }
            JClass mapOfStringObject = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
            JClass hashMapOfStringObject = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $copyMap = $setterBody.decl((JType)mapOfStringObject, "copyMap");
            $setterBody.assign((JAssignmentTarget)$copyMap, (JExpression)JExpr._new((JClass)hashMapOfStringObject).arg((JExpression)this.$templateMatrixParamValMap));
            JVar $localUriBuilder = $setterBody.decl(this.$uriBuilder.type(), "copyUriBuilder", (JExpression)this.$uriBuilder.invoke("clone"));
            JFieldRef parameter = JExpr.ref((String)paramName);
            Object sourceValue = p.isRepeating() ? this.codeModel.ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)JExpr._new((JClass)this.codeModel.ref(ArrayList.class).narrow(rawType)).arg((JExpression)parameter)) : parameter;
            $setterBody.invoke((JExpression)$copyMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)sourceValue);
            for (Param q : matrixParameters) {
                JExpression toSet;
                if (q.getFixed() != null) {
                    toSet = JExpr.lit((String)q.getFixed());
                } else {
                    toSet = $copyMap.invoke("get").arg(JExpr.lit((String)q.getName()));
                    if (q.isRepeating()) {
                        toSet = JExpr.cast((JType)this.codeModel.ref(List.class), (JExpression)toSet);
                    }
                }
                JConditional containsIf = $setterBody._if((JExpression)$copyMap.invoke("containsKey").arg(q.getName()));
                containsIf._then().assign((JAssignmentTarget)$localUriBuilder, (JExpression)$localUriBuilder.invoke("replaceMatrixParam").arg(q.getName()).arg((JExpression)(q.isRepeating() ? JExpr.cast((JType)this.codeModel.ref(Object[].class), (JExpression)toSet.invoke("toArray")) : toSet)));
                containsIf._else().assign((JAssignmentTarget)$localUriBuilder, (JExpression)$localUriBuilder.invoke("replaceMatrixParam").arg(q.getName()).arg((JExpression)JExpr.cast((JType)this.codeModel.ref(Object[].class), (JExpression)JExpr._null())));
            }
            $setterBody._return((JExpression)JExpr._new((JClass)$impl).arg((JExpression)this.$clientReference).arg((JExpression)$localUriBuilder).arg((JExpression)$copyMap));
        }
    }

    protected static enum MethodType {
        JAXB_MAPPING,
        JSON_POJO_MAPPING,
        CLASS,
        GENERIC_TYPE;

    }
}

