/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.eclipse.EclipseWSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;
import org.osgi.framework.Bundle;

class WSDL11ValidatorPluginRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_NAMESPACE = "namespace";
    protected String extensionPointId;
    protected String tagName;

    public WSDL11ValidatorPluginRegistryReader(String extensionPointId, String tagName) {
        this.extensionPointId = extensionPointId;
        this.tagName = tagName;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, this.extensionPointId);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            for (int i = 0; i < elements.length; ++i) {
                this.readElement(elements[i]);
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(this.tagName)) {
            String validatorClass = element.getAttribute(ATT_CLASS);
            String namespace = element.getAttribute(ATT_NAMESPACE);
            if (validatorClass != null && namespace != null) {
                try {
                    Bundle pluginBundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
                    EclipseWSDL11ValidatorDelegate delegate = new EclipseWSDL11ValidatorDelegate(validatorClass, pluginBundle);
                    WSDLValidator.getInstance().registerWSDL11Validator(namespace, delegate);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

