/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import com.ibm.wsdl.DefinitionImpl;
import com.ibm.wsdl.util.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ImportHolder;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.xml.LineNumberDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLReaderImpl {
    protected MessageGenerator messagegenerator;
    protected IWSDL11ValidationInfo wsdlvalinfo;

    public WSDLReaderImpl(IWSDL11ValidationInfo wsdlvalinfo) {
        this.wsdlvalinfo = wsdlvalinfo;
    }

    protected WSDLDocument[] parseDocument(String documentBaseURI, Element defEl) throws WSDLException {
        int i;
        int initialImportArraySize = 20;
        List<E>[] filesAtDepth = new ArrayList[initialImportArraySize];
        Hashtable filesImporting = new Hashtable();
        TreeSet<ImportHolder> parsedImports = new TreeSet<ImportHolder>();
        TreeSet<ImportHolder> importsToParse = new TreeSet<ImportHolder>();
        int maxdepth = 0;
        WSDLDocument rootdoc = new WSDLDocument(documentBaseURI, defEl, 0, this.messagegenerator, this.wsdlvalinfo);
        String targetNamespace = rootdoc.getDefinition().getTargetNamespace();
        ImportHolder rootImport = new ImportHolder(targetNamespace, documentBaseURI, documentBaseURI, rootdoc, 0, null, this.messagegenerator, this.wsdlvalinfo);
        rootImport.createWSDLImport(rootdoc);
        parsedImports.add(rootImport);
        ArrayList<WSDLDocument> rootList = new ArrayList<WSDLDocument>();
        filesImporting.put(rootImport.getLocation(), new ArrayList());
        rootList.add(rootdoc);
        filesAtDepth[0] = rootList;
        importsToParse.addAll(rootdoc.getImports());
        Set imps = rootdoc.getImports();
        for (ImportHolder imp : imps) {
            ArrayList<WSDLDocument> tempList = new ArrayList<WSDLDocument>();
            tempList.add(imp.getImportingDocument());
            filesImporting.put(imp.getLocation(), tempList);
        }
        while (!importsToParse.isEmpty()) {
            int impDepth;
            ImportHolder imp;
            imp = (ImportHolder)importsToParse.first();
            imp.initialize();
            WSDLDocument impDoc = imp.getWSDLDocument();
            importsToParse.remove(imp);
            parsedImports.add(imp);
            if (impDoc == null) continue;
            if (imp.getDepth() >= initialImportArraySize) {
                List[] tempArray = new List[filesAtDepth.length + initialImportArraySize];
                System.arraycopy(filesAtDepth, 0, tempArray, 0, filesAtDepth.length);
                filesAtDepth = tempArray;
            }
            if (filesAtDepth[impDepth = imp.getDepth()] == null) {
                if (maxdepth < impDepth) {
                    maxdepth = impDepth;
                }
                filesAtDepth[impDepth] = new ArrayList();
            }
            filesAtDepth[imp.getDepth()].add(impDoc);
            Set imports = impDoc.getImports();
            ImportHolder[] importsArray = imports.toArray(new ImportHolder[imports.size()]);
            for (int i2 = 0; i2 < importsArray.length; ++i2) {
                ImportHolder ih = importsArray[i2];
                if (filesImporting.containsKey(ih.getLocation())) {
                    ((List)filesImporting.get(ih.getLocation())).add(ih.getImportingDocument());
                    continue;
                }
                ArrayList<WSDLDocument> tempList = new ArrayList<WSDLDocument>();
                tempList.add(ih.getImportingDocument());
                filesImporting.put(ih.getLocation(), tempList);
                importsToParse.add(ih);
            }
        }
        for (ImportHolder imp : parsedImports) {
            List files = (List)filesImporting.get(imp.getLocation());
            for (WSDLDocument doc : files) {
                DefinitionImpl def = (DefinitionImpl)doc.getDefinition();
                Import impElem = imp.getImport();
                if (impElem == null) continue;
                def.addImport(impElem);
                if (imp.isWSDLFileImport()) continue;
                doc.addSchemas(imp.getSchemas());
            }
        }
        for (i = maxdepth; i >= 0; --i) {
            ArrayList docs = filesAtDepth[i];
            for (WSDLDocument doc : docs) {
                doc.parseMessages();
            }
        }
        for (i = maxdepth; i >= 0; --i) {
            ArrayList docs = filesAtDepth[i];
            for (WSDLDocument doc : docs) {
                doc.parsePorttypes();
            }
        }
        for (i = maxdepth; i >= 0; --i) {
            ArrayList docs = filesAtDepth[i];
            for (WSDLDocument doc : docs) {
                doc.parseBindings();
            }
        }
        for (i = maxdepth; i >= 0; --i) {
            ArrayList docs = filesAtDepth[i];
            for (WSDLDocument doc : docs) {
                doc.parseServices();
            }
        }
        for (i = maxdepth; i >= 0; --i) {
            ArrayList docs = filesAtDepth[i];
            for (WSDLDocument doc : docs) {
                doc.parseExtensibilityElements();
            }
        }
        ArrayList<WSDLDocument> wsdlDocs = new ArrayList<WSDLDocument>();
        for (int i3 = maxdepth; i3 >= 0; --i3) {
            ArrayList docs = filesAtDepth[i3];
            for (WSDLDocument doc : docs) {
                wsdlDocs.add(doc);
            }
        }
        return wsdlDocs.toArray(new WSDLDocument[wsdlDocs.size()]);
    }

    public static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        try {
            StandardParserConfiguration configuration = new StandardParserConfiguration(){

                protected XMLErrorReporter createErrorReporter() {
                    return new XMLErrorReporter(){

                        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                            boolean reportError = true;
                            if (key.equals("PrematureEOF")) {
                                reportError = false;
                            }
                            if (reportError) {
                                super.reportError(domain, key, arguments, severity);
                            }
                        }
                    };
                }
            };
            ErrorHandler errorHandler = new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            };
            LineNumberDOMParser builder = new LineNumberDOMParser((XMLParserConfiguration)configuration);
            builder.setErrorHandler(errorHandler);
            builder.parse(inputSource);
            Document doc = builder.getDocument();
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", t);
        }
    }

    public WSDLDocument[] readWSDL(String contextURI, String wsdlURI) throws WSDLException {
        try {
            URL contextURL = contextURI != null ? StringUtils.getURL(null, (String)contextURI) : null;
            URL url = StringUtils.getURL((URL)contextURL, (String)wsdlURI);
            InputStream reader = StringUtils.getContentAsInputStream((URL)url);
            InputSource inputSource = new InputSource(reader);
            Document doc = WSDLReaderImpl.getDocument(inputSource, wsdlURI);
            reader.close();
            WSDLDocument[] wsdlDocs = null;
            if (doc.getDocumentElement() != null) {
                wsdlDocs = this.readWSDL(url.toString(), doc);
            }
            return wsdlDocs;
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + wsdlURI + "'.", t);
        }
    }

    public void setMessageGenerator(MessageGenerator mg) {
        this.messagegenerator = mg;
    }

    public WSDLDocument[] readWSDL(String wsdlURI) throws WSDLException {
        return this.readWSDL(null, wsdlURI);
    }

    protected WSDLDocument[] readWSDL(String documentBaseURI, Element definitionsElement) throws WSDLException {
        return this.parseDocument(documentBaseURI, definitionsElement);
    }

    public WSDLDocument[] readWSDL(String documentBaseURI, Document wsdlDocument) throws WSDLException {
        return this.readWSDL(documentBaseURI, wsdlDocument.getDocumentElement());
    }
}

