/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.monitor.ChunkedData;
import org.eclipse.wst.wsi.internal.core.monitor.SocketConnection;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class SocketHandler
extends Thread {
    protected SocketConnection socketConnection;
    protected SocketHandler pairedSocketHandler;
    protected String connectionType;
    protected int conversationID;
    protected String targetHost;
    protected int readTimeoutSeconds;
    protected Socket inSocket;
    protected Socket outSocket;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected boolean verbose = false;
    protected boolean readTimedOut = false;
    private String mimeCharset = null;
    private String xmlEncoding = null;
    protected static final String CRLF = "\r\n";
    protected static final String HTTP_100_CONTINUE = "100 Continue".toUpperCase();
    protected static final String CHUNKED = "Transfer-Encoding: chunked".toUpperCase();
    protected static final String CHUNKED_WITH_QUOTES = "Transfer-Encoding: \"chunked\"".toUpperCase();
    protected static final String CONTENT_LENGTH = "Content-Length:".toUpperCase();

    public SocketHandler(SocketConnection socketConnection, String connectionType, int conversationID, String targetHost, Socket inSocket, Socket outSocket, int readTimeoutSeconds) {
        this.socketConnection = socketConnection;
        this.connectionType = connectionType;
        this.conversationID = conversationID;
        this.targetHost = targetHost;
        this.inSocket = inSocket;
        this.outSocket = outSocket;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.verbose = socketConnection.getMonitor().getMonitorConfig().getVerboseOption();
        this.start();
    }

    public void setPairedSocketHandler(SocketHandler pairedSocketHandler) {
        this.pairedSocketHandler = pairedSocketHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageContext messageContext = null;
        byte[] readBuffer = new byte[4096];
        try {
            this.inputStream = this.inSocket.getInputStream();
            this.outputStream = this.outSocket.getOutputStream();
            boolean connectionActive = true;
            while (connectionActive) {
                int readLen = 0;
                messageContext = new MessageContext();
                boolean messageComplete = false;
                while (!messageComplete) {
                    try {
                        this.debug("run", "Read data from the input stream.");
                        readLen = this.inputStream.read(readBuffer, 0, readBuffer.length);
                        this.readTimedOut = false;
                        this.debug("run", "readLen: " + readLen);
                        if (readLen == -1) {
                            connectionActive = false;
                            messageComplete = true;
                        } else if (readLen > 0) {
                            String readMsg;
                            String encoding;
                            if (messageContext.timestamp == null) {
                                messageContext.timestamp = Utils.getTimestamp();
                            }
                            if (this.connectionType.equals("request")) {
                                byte[] toHost = new String(this.socketConnection.redirect.getToHost() + ":" + this.socketConnection.redirect.getToPort()).getBytes();
                                String message = new String(readBuffer, 0, readLen);
                                int index = message.indexOf("\r\nHost: ");
                                if (index > -1) {
                                    int secondPart = message.indexOf(CRLF, index += 8);
                                    this.write(this.outputStream, readBuffer, 0, index);
                                    this.write(this.outputStream, toHost, 0, toHost.length);
                                    this.write(this.outputStream, readBuffer, secondPart, readLen - secondPart);
                                } else {
                                    this.write(this.outputStream, readBuffer, 0, readLen);
                                }
                            } else {
                                this.write(this.outputStream, readBuffer, 0, readLen);
                            }
                            if (this.verbose) {
                                String bufferString = new String(readBuffer, 0, readLen);
                                this.debug("run", "buffer as string: [" + bufferString + "]");
                                if (bufferString.length() <= 50) {
                                    this.debug("run", "buffer as hexstring: [" + Utils.toHexString(bufferString) + "]");
                                } else {
                                    this.debug("run", "buffer as hexstring: [" + Utils.toHexString(bufferString.substring(0, 50)) + " ...]");
                                }
                            }
                            if (messageContext.bom == 0) {
                                messageContext.bom = this.getBOM(readBuffer);
                            }
                            this.debug("run", "bom: " + messageContext.bom);
                            try {
                                encoding = this.getEncoding();
                                readMsg = new String(readBuffer, 0, readLen, Utils.getJavaEncoding(encoding));
                                this.setEncoding(readMsg);
                                if (!encoding.equals(this.getEncoding())) {
                                    encoding = this.getEncoding();
                                    readMsg = new String(readBuffer, 0, readLen, Utils.getJavaEncoding(encoding));
                                }
                            }
                            catch (UnsupportedEncodingException uee) {
                                this.debug("run", "EXCEPTION (3): " + uee.toString());
                                throw new RuntimeException(uee.toString());
                            }
                            messageContext.encoding = encoding;
                            this.debug("run", "encoding: " + messageContext.encoding);
                            messageContext = this.processMessage(readLen, readMsg, messageContext);
                        }
                        if (!this.isMessageComplete(messageContext) && (readLen != -1 || messageContext.messageBuffer.length() <= 0)) continue;
                        this.logMessage(messageContext);
                        messageComplete = true;
                    }
                    catch (InterruptedIOException ie) {
                        this.readTimedOut = true;
                        this.debug("run", "InterruptedIOException: " + ie.toString());
                        if (this.pairedSocketHandler == null || !this.pairedSocketHandler.isReadWaiting() || !this.pairedSocketHandler.isReadTimedOut()) continue;
                        this.debug("run", "read timed out on both sockets");
                        if (this.isMessageComplete(messageContext) || messageContext.messageBuffer.length() > 0) {
                            this.logMessage(messageContext);
                        }
                        connectionActive = false;
                        messageComplete = true;
                    }
                    catch (Exception e2) {
                        this.debug("run", "EXCEPTION (2): " + e2.toString() + "\n" + Utils.getExceptionDetails(e2));
                        if (this.isMessageComplete(messageContext) || messageContext.messageBuffer.length() > 0) {
                            this.logMessage(messageContext);
                        }
                        connectionActive = false;
                        messageComplete = true;
                    }
                }
            }
        }
        catch (Exception e) {
            this.debug("run", "EXCEPTION (1): " + e.getMessage() + "\n" + Utils.getExceptionDetails(e));
        }
        catch (Error err) {
            this.debug("run", "ERROR: " + err.getMessage());
        }
        finally {
            this.shutdown();
            this.socketConnection.wakeUp();
        }
    }

    private MessageContext processMessage(int readLen, String readMsg, MessageContext inMessageContext) throws WSIException {
        int index;
        boolean continueRead = false;
        MessageContext messageContext = inMessageContext;
        StringBuffer messageBuffer = messageContext.messageBuffer;
        ChunkedData chunkedData = messageContext.chunkedData;
        if (readMsg.toUpperCase().indexOf(HTTP_100_CONTINUE) != -1 && readLen >= 25) {
            this.debug("processMessage", "Ignore HTTP 100 Continue.");
            index = Utils.getFirstCRLFCRLF(readMsg);
            if (index == readMsg.length()) {
                continueRead = true;
            } else {
                readMsg = readMsg.substring(index);
            }
        }
        if (!continueRead && this.bypassMessage(readMsg)) {
            this.debug("processMessage", "Do not log message as defined in the monitor spec, but it will be sent.");
            continueRead = true;
        }
        if (!continueRead) {
            index = 0;
            if (readMsg.toUpperCase().indexOf(CHUNKED) != -1 || readMsg.toUpperCase().indexOf(CHUNKED_WITH_QUOTES) != -1) {
                this.debug("processMessage", "Processing chunked data...");
                index = readMsg.indexOf("\r\n\r\n");
                if (index == -1) {
                    throw new WSIException("Could not locate end of HTTP header.");
                }
                this.debug("processMessage", "Add header before decoding chunked data: [" + readMsg.substring(0, index += 4) + "]");
                messageBuffer.append(readMsg.substring(0, index));
                if (readMsg.length() == index) {
                    chunkedData = new ChunkedData(this, true);
                    this.debug("processMessage", "There is chunk data, but none in this part of the message.");
                } else {
                    chunkedData = new ChunkedData(this, readMsg.substring(index));
                    if (!chunkedData.isMoreChunkedData()) {
                        chunkedData.decodeAndAddDataToBuffer(messageBuffer);
                    }
                }
            } else if (chunkedData != null && chunkedData.isMoreChunkedData()) {
                this.debug("processMessage", "Processing MORE chunked data...");
                chunkedData.addData(readMsg);
                if (!chunkedData.isMoreChunkedData()) {
                    chunkedData.decodeAndAddDataToBuffer(messageBuffer);
                }
            } else {
                this.debug("processMessage", "Add data to message entry buffer: [" + readMsg + "]");
                messageBuffer.append(readMsg);
            }
        }
        messageContext.messageBuffer = messageBuffer;
        messageContext.chunkedData = chunkedData;
        return messageContext;
    }

    protected void stopInput(Socket inSocket, InputStream inputStream) {
        try {
            if (inSocket != null) {
                inSocket.shutdownInput();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inputStream = null;
    }

    protected void stopOutput(Socket outSocket, OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.flush();
            }
            if (outSocket != null) {
                outSocket.shutdownOutput();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputStream = null;
    }

    public void shutdown() {
        this.stopInput(this.inSocket, this.inputStream);
        this.stopOutput(this.outSocket, this.outputStream);
    }

    void debug(String method, String message) {
        this.debug("SocketHandler", method, message);
    }

    void debug(String className, String method, String message) {
        if (this.verbose) {
            this.print(className, method, message);
        }
    }

    void print(String className, String method, String message) {
        System.out.println("[" + Thread.currentThread().getName() + "] [" + className + "." + method + "] [" + this.connectionType + "] " + message);
    }

    private void write(OutputStream outputStream, byte[] buffer, int start, int length) throws IOException {
        if (outputStream == null) {
            this.debug("write", "Could not write buffer because output stream is null.");
        } else {
            this.debug("write", "buffer: [" + new String(buffer, start, length) + "]");
            outputStream.write(buffer, start, length);
        }
    }

    private boolean isMessageComplete(MessageContext messageContext) throws WSIException {
        boolean messageComplete = false;
        boolean moreChunkedData = messageContext.chunkedData.isMoreChunkedData();
        String message = messageContext.messageBuffer.toString();
        int index = Utils.getFirstCRLFCRLF(message);
        String httpHeader = index == -1 ? message : message.substring(0, index);
        if (!(httpHeader.toUpperCase().indexOf(CHUNKED) == -1 && httpHeader.toUpperCase().indexOf(CHUNKED_WITH_QUOTES) == -1 || moreChunkedData)) {
            this.debug("isMessageComplete", "HTTP header indicates chunked data and there is no more chunked data");
            messageComplete = true;
        } else {
            index = httpHeader.toUpperCase().indexOf(CONTENT_LENGTH);
            if (index == -1) {
                this.debug("isMessageComplete", "HTTP header does not contain content length");
                if (httpHeader.startsWith("POST")) {
                    if (httpHeader.endsWith("\r\n\r\n")) {
                        throw new WSIException("Could not locate content-length in HTTP POST header.");
                    }
                    messageComplete = false;
                } else {
                    messageComplete = httpHeader.startsWith("GET") && message.length() == httpHeader.length() && message.endsWith("\r\n\r\n");
                }
            } else {
                index = httpHeader.toUpperCase().indexOf(CONTENT_LENGTH);
                if (index != -1) {
                    int index2 = httpHeader.indexOf(CRLF, index);
                    this.debug("isMessageComplete", "CRLF: " + Utils.toHexString(CRLF));
                    this.debug("isMessageComplete", "httpHeader/index: " + Utils.toHexString(httpHeader.substring(index)));
                    int contentLen = Integer.decode(httpHeader.substring(index + CONTENT_LENGTH.length() + 1, index2));
                    this.debug("isMessageComplete", "contentLen: " + contentLen);
                    index = Utils.getFirstCRLFCRLF(message);
                    this.debug("isMessageComplete", "actual received message length: " + (message.length() - index));
                    if (contentLen == message.length() - index) {
                        messageComplete = true;
                        this.debug("isMessageComplete", "contentLen = actual received message length.");
                    }
                } else {
                    messageComplete = false;
                }
            }
        }
        this.debug("isMessageComplete", "messageComplete: " + messageComplete);
        return messageComplete;
    }

    private void logMessage(MessageContext messageContext) throws WSIException {
        String receiverHostAndPort;
        String senderHostAndPort;
        if (this.connectionType.equals("request")) {
            senderHostAndPort = this.inSocket.getInetAddress().getHostAddress() + ":" + this.inSocket.getPort();
            receiverHostAndPort = this.targetHost + ":" + this.outSocket.getPort();
        } else {
            senderHostAndPort = this.targetHost + ":" + this.inSocket.getPort();
            receiverHostAndPort = this.outSocket.getInetAddress().getHostAddress() + ":" + this.outSocket.getPort();
        }
        this.socketConnection.logMessage(this.conversationID, this.connectionType, messageContext.timestamp, senderHostAndPort, receiverHostAndPort, messageContext.messageBuffer, messageContext.bom, messageContext.encoding);
    }

    private boolean bypassMessage(String message) {
        boolean bypass = false;
        if (message.startsWith("CONNECT") || message.startsWith("TRACE") || message.startsWith("DELETE") || message.startsWith("OPTIONS") || message.startsWith("HEAD")) {
            bypass = true;
        }
        return bypass;
    }

    private void setEncoding(String messageFragment) {
        if (this.mimeCharset == null || this.mimeCharset.length() == 0) {
            this.mimeCharset = Utils.getHTTPCharset(messageFragment);
        }
        if (this.xmlEncoding == null || this.xmlEncoding.length() == 0) {
            this.xmlEncoding = Utils.getXMLEncoding(messageFragment);
        }
    }

    private String getEncoding() {
        String encoding = "UTF-8";
        if (this.mimeCharset != null && this.mimeCharset.length() > 0) {
            encoding = this.mimeCharset;
        }
        if (this.xmlEncoding != null && this.xmlEncoding.length() > 0) {
            encoding = this.xmlEncoding;
        }
        return encoding;
    }

    private int getBOM(byte[] message) {
        int bom = 0;
        byte FF = -1;
        byte FE = -2;
        byte EF = -17;
        byte BB = -69;
        byte BF = -65;
        int i = Utils.getFirstCRLFCRLF(message, 0);
        if (i != -1) {
            this.debug("getBOM", "message[i]: " + message[i] + ", message[i+1]: " + message[i + 1]);
            if (i + 2 < message.length && message[i] == EF && message[i + 1] == BB && message[i + 2] == BF) {
                bom = 0xEFBBBF;
            } else if (i + 1 < message.length && message[i] == FE && message[i + 1] == FF) {
                bom = 65279;
            } else if (i + 1 < message.length && message[i] == FF && message[i + 1] == FE) {
                bom = 65534;
            }
        }
        return bom;
    }

    boolean isReadWaiting() {
        boolean readWaiting = false;
        try {
            this.debug("isReadWaiting", "inSocket.getInputStream().available(): " + this.inSocket.getInputStream().available());
            if (this.inSocket.getInputStream().available() == 0) {
                readWaiting = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return readWaiting;
    }

    boolean isReadTimedOut() {
        return this.readTimedOut;
    }

    class MessageContext {
        StringBuffer messageBuffer = new StringBuffer();
        ChunkedData chunkedData = new ChunkedData();
        String timestamp = null;
        int bom = 0;
        String encoding = "UTF-8";

        MessageContext() {
        }
    }
}

