/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLTags;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1211
extends AssertionProcess
implements XMLTags {
    private final BaseMessageValidator validator;

    public BP1211(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = entryContext.getMessageEntryDocument();
            Document docRequest = entryContext.getRequestDocument();
            Element soapOperation = null;
            if (this.validator.isFault(doc) || (soapOperation = this.validator.getSoapBodyChild(doc)) == null) {
                throw new AssertionNotApplicableException();
            }
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(docRequest, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = match.getOperation();
            if (!WSDLUtils.isRpcLiteral(match.getOperationStyle(), bindingOperation)) {
                throw new AssertionNotApplicableException();
            }
            Element accessor = XMLUtils.getFirstChild(soapOperation);
            while (accessor != null) {
                Attr attr = XMLUtils.getAttribute(accessor, ATTR_XSI_NIL);
                if (attr != null && (attr.getValue().equals("1") || attr.getValue().equals("true"))) {
                    throw new AssertionFailException("The accessor name is " + accessor.getNodeName());
                }
                accessor = XMLUtils.getNextSibling(accessor);
            }
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        catch (Exception e) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

