/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.wsdl.Definition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.StringTokenizer;

public class BP2201
extends AssertionProcess {
    private final WSDLValidatorImpl validator;
    private final char[] OMMITED_XML_DECLARATION_DELIMITERS = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private final char[] XML_DECLARATION_DELIMITERS = new char[]{'='};
    private final String UTF_8_ENCODING = "UTF-8";
    private final String UTF_16_ENCODING = "UTF-16";
    private final String ENCODING_TOKEN = "encoding";

    public BP2201(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        String location = definition.getDocumentBaseURI();
        String xmlDecl = this.readXMLDeclarationStatement(location);
        if (xmlDecl == null) {
            this.result = "notApplicable";
        } else if (!this.validEncoding(xmlDecl)) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(xmlDecl, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readXMLDeclarationStatement(String location) {
        String result = null;
        if (location != null) {
            URL url = null;
            Reader reader = null;
            try {
                try {
                    url = new URL(location);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                reader = url != null ? new InputStreamReader(url.openStream()) : new InputStreamReader(new FileInputStream(location));
                boolean end = false;
                if (reader.ready()) {
                    int charCode = reader.read();
                    while (reader.ready() && charCode != 60) {
                        charCode = reader.read();
                    }
                    char[] c = new char[4];
                    reader.read(c);
                    StringBuffer buf = new StringBuffer();
                    if (new String(c).toLowerCase().equals("?xml")) {
                        buf.append("<?xml");
                        while (reader.ready() && !end) {
                            charCode = reader.read();
                            buf.append((char)charCode);
                            end = charCode == 62;
                        }
                    } else {
                        this.result = "notApplicable";
                        String string = null;
                        return string;
                    }
                    result = buf.toString();
                }
            }
            catch (Exception e) {
                if (this.validator.verboseOption) {
                    System.err.println("  [WSI2201] Exception: " + e.getMessage());
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        return result;
    }

    private boolean validEncoding(String xmlDecl) {
        boolean result = true;
        if (xmlDecl != null) {
            StringTokenizer st = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration tokens = st.parse(xmlDecl);
            boolean found = false;
            while (tokens.hasMoreElements() && !found) {
                String token = (String)tokens.nextElement();
                if (!token.equals("encoding")) continue;
                found = true;
                tokens.nextElement();
                String enc = (String)tokens.nextElement();
                result = "UTF-8".equalsIgnoreCase(enc) || "UTF-16".equalsIgnoreCase(enc);
            }
        }
        return result;
    }
}

