/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.net.URI;
import javax.wsdl.Import;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2803
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2803(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Import im = (Import)entryContext.getEntry().getEntryDetail();
        try {
            if (im.getNamespaceURI() == null) {
                throw new AssertionNotApplicableException();
            }
            URI uri = new URI(im.getNamespaceURI());
            if (!uri.isAbsolute()) {
                throw new AssertionFailException(im.getNamespaceURI() + " is relative URI.");
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (Exception e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

