/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIRuntimeException;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.CandidateInfo;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.profile.ProfileArtifact;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.WSDLValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.EntryContainer;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLElementList;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;
import org.eclipse.wst.wsi.internal.core.xml.schema.TargetNamespaceProcessor;
import org.eclipse.wst.wsi.internal.core.xml.schema.XMLSchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLValidatorImpl
extends BaseValidatorImpl
implements WSDLValidator {
    protected String wsdlURL;
    protected WSDLDocument wsdlDocument = null;
    private boolean testable;
    protected HashMap containerMap = new HashMap();
    protected boolean processDefAssertions = true;

    public String getArtifactType() {
        return "description";
    }

    public String[] getEntryTypes() {
        return new String[]{"definitions", "import", "types", "message", "operation", "portType", "binding", "port"};
    }

    public void init(AnalyzerContext analyzerContext, ProfileAssertions assertions, ReportArtifact reportArtifact, AnalyzerConfig analyzerConfig, Reporter reporter) throws WSIException {
        this.init(analyzerContext, assertions, reportArtifact, analyzerConfig, reporter, true);
    }

    public void init(AnalyzerContext analyzerContext, ProfileAssertions assertions, ReportArtifact reportArtifact, AnalyzerConfig analyzerConfig, Reporter reporter, boolean processDefAssertions) throws WSIException {
        super.init(analyzerContext, assertions.getArtifact("description"), reportArtifact, reporter);
        this.wsdlDocument = analyzerContext.getWsdlDocument();
        boolean bl = this.testable = analyzerContext.getWsdlDocument() != null;
        if (this.wsdlDocument != null) {
            this.wsdlURL = this.wsdlDocument.getLocation();
        }
        this.processDefAssertions = processDefAssertions;
    }

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, String wsdlURL, WSDLDocument wsdlDocument, Reporter reporter) throws WSIException {
        this.init(analyzerContext, profileArtifact, reportArtifact, wsdlURL, wsdlDocument, reporter, true);
    }

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, String wsdlURL, WSDLDocument wsdlDocument, Reporter reporter, boolean processDefAssertions) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        this.wsdlDocument = wsdlDocument;
        boolean bl = this.testable = wsdlDocument != null;
        if (wsdlDocument != null) {
            this.wsdlURL = wsdlDocument.getLocation();
        }
        if (wsdlURL != null) {
            this.wsdlURL = wsdlURL;
        }
        this.processDefAssertions = processDefAssertions;
    }

    public void validateArtifact() throws WSIException {
        Service service = null;
        Port port = null;
        Binding binding = null;
        PortType portType = null;
        Operation operation = null;
        Message message = null;
        String classPrefix = this.getClass().getPackage().getName() + ".";
        Definition definition = this.wsdlDocument.getDefinitions();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        CandidateInfo candidate = new CandidateInfo(serviceReference, this.wsdlDocument);
        this.analyzerContext.setCandidateInfo(candidate);
        this.reporter.setPrereqType("entryContainer");
        if (this.processDefAssertions) {
            this.processDefinitionAssertions(classPrefix, candidate);
            this.processTypesAssertions(classPrefix, candidate);
            this.processImportAssertions(classPrefix, candidate);
        }
        if (serviceReference.getWSDLElement().isPort()) {
            service = definition.getService(serviceReference.getWSDLElement().getParentElementQName());
            if (service == null) {
                throw new WSIRuntimeException("Could not locate WSDL service: " + serviceReference.getWSDLElement().getParentElementName());
            }
            port = service.getPort(serviceReference.getWSDLElement().getName());
            if (port == null) {
                throw new WSIRuntimeException("Could not locate WSDL port: " + serviceReference.getWSDLElement().getName());
            }
            binding = port.getBinding();
            if (binding == null || binding.isUndefined()) {
                this.setMissingInput(EntryType.getEntryType("binding"));
                this.setMissingInput(EntryType.getEntryType("portType"));
                this.setMissingInput(EntryType.getEntryType("operation"));
                this.setMissingInput(EntryType.getEntryType("message"));
            } else {
                this.processBindingAssertions(binding, serviceReference, classPrefix, this.wsdlDocument);
                portType = binding.getPortType();
                if (portType == null || portType.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("portType"));
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    this.setMissingInput(EntryType.getEntryType("message"));
                } else {
                    this.processMessageAssertions(binding, serviceReference, classPrefix, this.wsdlDocument);
                    this.processPortTypeAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                    this.processOperationAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                    this.processMessageAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                }
            }
        } else if (serviceReference.getWSDLElement().isBinding()) {
            WSDLElement wsdlElement = serviceReference.getWSDLElement();
            if (wsdlElement.getQName() != null && wsdlElement.getQName().getLocalPart() != null && wsdlElement.getQName().getLocalPart().length() > 0) {
                binding = definition.getBinding(serviceReference.getWSDLElement().getQName());
                if (binding == null || binding.isUndefined()) {
                    throw new WSIRuntimeException("Could not locate WSDL binding: " + serviceReference.getWSDLElement().getName());
                }
                this.processBindingAssertions(binding, serviceReference, classPrefix, this.wsdlDocument);
                this.processMessageAssertions(binding, serviceReference, classPrefix, this.wsdlDocument);
                portType = binding.getPortType();
                if (portType == null || portType.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("portType"));
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    this.setMissingInput(EntryType.getEntryType("message"));
                } else {
                    this.processPortTypeAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                    this.processOperationAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                    this.processMessageAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
                }
            } else {
                this.setMissingInput(EntryType.getEntryType("binding"));
                this.setMissingInput(EntryType.getEntryType("portType"));
                this.setMissingInput(EntryType.getEntryType("operation"));
                this.setMissingInput(EntryType.getEntryType("message"));
            }
        } else if (serviceReference.getWSDLElement().isPortType()) {
            portType = definition.getPortType(serviceReference.getWSDLElement().getQName());
            if (portType == null || portType.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL PortType: " + serviceReference.getWSDLElement().getName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.processPortTypeAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
            this.processOperationAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
            this.processMessageAssertions(portType, serviceReference, classPrefix, this.wsdlDocument);
        } else if (serviceReference.getWSDLElement().isOperation()) {
            portType = definition.getPortType(serviceReference.getWSDLElement().getParentElementQName());
            if (portType == null || portType.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL portType: " + serviceReference.getWSDLElement().getParentElementQName());
            }
            operation = this.getOperationFromPortType(portType, serviceReference.getWSDLElement().getName());
            if (operation == null || operation.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL Operation: " + serviceReference.getWSDLElement().getName() + "in portType: " + portType.getQName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.setMissingInput(EntryType.getEntryType("portType"));
            this.processOperationAssertions(operation, portType, serviceReference, classPrefix, this.wsdlDocument);
            this.processMessageAssertions(operation, serviceReference, classPrefix, this.wsdlDocument);
        } else if (serviceReference.getWSDLElement().isMessage()) {
            message = definition.getMessage(serviceReference.getWSDLElement().getQName());
            if (message == null || message.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL Message: " + serviceReference.getWSDLElement().getName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.setMissingInput(EntryType.getEntryType("portType"));
            this.setMissingInput(EntryType.getEntryType("operation"));
            this.processMessageAssertions(message, serviceReference, classPrefix, this.wsdlDocument);
        } else {
            throw new WSIRuntimeException("The following WSDL type is not supported: " + serviceReference.getWSDLElement().getType());
        }
        this.cleanup();
    }

    public WSDLDocument validate() throws WSIException {
        this.validateArtifact();
        return this.wsdlDocument;
    }

    protected EntryContainer getEntryContainer(String filename) {
        EntryContainer entryContainer = null;
        entryContainer = (EntryContainer)this.containerMap.get(filename);
        if (entryContainer == null) {
            entryContainer = this.reporter.createEntryContainer();
            entryContainer.setId(filename);
            this.containerMap.put(filename, entryContainer);
        }
        return entryContainer;
    }

    protected Operation getOperationFromPortType(PortType portType, String operationName) {
        Operation op2 = null;
        if (portType.getOperations() != null) {
            for (Operation op2 : portType.getOperations()) {
                if (!operationName.equals(op2.getName())) continue;
                return op2;
            }
        }
        return null;
    }

    protected void processDefinitionAssertions(String classPrefix, CandidateInfo candidate) throws WSIException {
        Entry entry = null;
        Definition[] wsdlDefinitions = candidate.getDefinitions();
        for (int i = 0; i < wsdlDefinitions.length; ++i) {
            Definition definition = wsdlDefinitions[i];
            if (definition == null) continue;
            entry = this.reporter.getReport().createEntry();
            entry.setEntryType(EntryType.getEntryType("definitions"));
            entry.setReferenceID(definition.getDocumentBaseURI());
            entry.setEntryDetail(definition);
            entry.setEntryContainer(this.getEntryContainer(definition.getDocumentBaseURI()));
            this.processAssertions(classPrefix, new EntryContext(entry, candidate.getWsdlDocument()));
        }
    }

    protected void processTypesAssertions(String classPrefix, CandidateInfo candidate) throws WSIException {
        Entry entry = null;
        Types[] wsdlTypes = candidate.getTypes();
        Definition[] wsdlDefinitions = candidate.getDefinitions();
        if (wsdlTypes == null || wsdlTypes.length == 0) {
            this.setMissingInput(EntryType.getEntryType("types"));
        } else {
            for (int i = 0; i < wsdlTypes.length; ++i) {
                Types types = wsdlTypes[i];
                if (types == null) continue;
                entry = this.reporter.getReport().createEntry();
                entry.setEntryType(EntryType.getEntryType("types"));
                entry.setReferenceID(candidate.getDefinition(types).getDocumentBaseURI() + "-Types");
                entry.setEntryDetail(types);
                entry.setEntryContainer(this.getEntryContainer(wsdlDefinitions[i].getDocumentBaseURI()));
                this.processAssertions(classPrefix, new EntryContext(entry, candidate.getWsdlDocument()));
            }
        }
    }

    protected void processImportAssertions(String classPrefix, CandidateInfo candidate) throws WSIException {
        Entry entry = null;
        Import[] wsdlImports = candidate.getImports();
        if (wsdlImports == null || wsdlImports.length == 0) {
            this.setMissingInput(EntryType.getEntryType("import"));
        } else {
            for (int i = 0; i < wsdlImports.length; ++i) {
                Import wsdlImport = wsdlImports[i];
                entry = this.reporter.getReport().createEntry();
                entry.setEntryType(EntryType.getEntryType("import"));
                entry.setReferenceID(wsdlImport.getNamespaceURI());
                entry.setEntryDetail(wsdlImport);
                entry.setEntryContainer(this.getEntryContainer(wsdlImport.getLocationURI()));
                this.processAssertions(classPrefix, new EntryContext(entry, candidate.getWsdlDocument()));
            }
        }
    }

    protected void processPortAssertions(Port port, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        Entry entry = null;
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("port"));
        entry.setReferenceID(port.getName());
        entry.setParentElementName(serviceReference.getWSDLElement().getParentElementName());
        entry.setEntryDetail(port);
        this.processAssertions(classPrefix, new EntryContext(entry, wsdlDocument));
    }

    protected void processBindingAssertions(Binding binding, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        Entry entry = null;
        QName bindingQName = binding.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("binding"));
        entry.setReferenceID(bindingQName.toString());
        entry.setEntryDetail(binding);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(binding);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(classPrefix, new EntryContext(entry, wsdlDocument));
    }

    protected void processPortTypeAssertions(PortType portType, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        Entry entry = null;
        QName portTypeQName = portType.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("portType"));
        entry.setReferenceID(portTypeQName.toString());
        entry.setEntryDetail(portType);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(portType);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(classPrefix, new EntryContext(entry, wsdlDocument));
    }

    protected void processOperationAssertions(Operation operation, PortType portType, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        Entry entry = null;
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("operation"));
        entry.setReferenceID(operation.getName());
        entry.setParentElementName(portType.getQName().getLocalPart());
        entry.setEntryDetail(operation);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(portType);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(classPrefix, new EntryContext(entry, wsdlDocument));
    }

    protected void processOperationAssertions(PortType portType, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        if (portType.getOperations() == null) {
            this.setMissingInput(EntryType.getEntryType("operation"));
        } else {
            for (Operation operation : portType.getOperations()) {
                if (operation == null || operation.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    continue;
                }
                this.processOperationAssertions(operation, portType, serviceReference, classPrefix, wsdlDocument);
            }
        }
    }

    protected void processMessageAssertions(Message message, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        Entry entry = null;
        QName messageQName = message.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("message"));
        entry.setReferenceID(messageQName.toString());
        entry.setEntryDetail(message);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(message);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(classPrefix, new EntryContext(entry, wsdlDocument));
    }

    protected void processMessageAssertions(Binding binding, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        HashSet messageSet;
        if (binding.getBindingOperations() != null && (messageSet = WSDLUtils.findMessages(wsdlDocument.getDefinitions(), binding)).size() > 0) {
            for (Message message : messageSet) {
                if (message.isUndefined()) continue;
                this.processMessageAssertions(message, serviceReference, classPrefix, wsdlDocument);
            }
        }
    }

    protected void processMessageAssertions(PortType portType, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        HashSet<Message> messageSet = new HashSet<Message>();
        if (portType.getOperations() != null) {
            for (Operation op : portType.getOperations()) {
                if (op.getInput() != null && !op.getInput().getMessage().isUndefined()) {
                    messageSet.add(op.getInput().getMessage());
                }
                if (op.getOutput() != null && !op.getOutput().getMessage().isUndefined()) {
                    messageSet.add(op.getOutput().getMessage());
                }
                if (op.getFaults() == null) continue;
                Iterator faultIt = op.getFaults().values().iterator();
                while (faultIt.hasNext()) {
                    Message message = ((Fault)faultIt.next()).getMessage();
                    if (message.isUndefined()) continue;
                    messageSet.add(message);
                }
            }
            if (messageSet.size() == 0) {
                this.setMissingInput(EntryType.getEntryType("message"));
            } else {
                Iterator messageIt = messageSet.iterator();
                while (messageIt.hasNext()) {
                    this.processMessageAssertions((Message)messageIt.next(), serviceReference, classPrefix, wsdlDocument);
                }
            }
        }
    }

    protected void processMessageAssertions(Operation op, ServiceReference serviceReference, String classPrefix, WSDLDocument wsdlDocument) throws WSIException {
        HashSet<Message> messageSet = new HashSet<Message>();
        if (op.getInput() != null && !op.getInput().getMessage().isUndefined()) {
            messageSet.add(op.getInput().getMessage());
        }
        if (op.getOutput() != null && !op.getOutput().getMessage().isUndefined()) {
            messageSet.add(op.getOutput().getMessage());
        }
        Iterator faultIt = op.getFaults().values().iterator();
        while (faultIt.hasNext()) {
            Message message = ((Fault)faultIt.next()).getMessage();
            if (message.isUndefined()) continue;
            messageSet.add(message);
        }
        if (messageSet.size() == 0) {
            this.setMissingInput(EntryType.getEntryType("message"));
        } else {
            Iterator messageIt = messageSet.iterator();
            while (messageIt.hasNext()) {
                this.processMessageAssertions((Message)messageIt.next(), serviceReference, classPrefix, wsdlDocument);
            }
        }
    }

    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, EntryContext targetContext) {
        boolean match = false;
        if (testAssertion.getEntryTypeName().equals(targetContext.getEntry().getEntryType().getTypeName())) {
            match = true;
        }
        return match;
    }

    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean notApplicable = false;
        return notApplicable;
    }

    protected SOAPFault[] getSoapFaults(Binding inBinding) throws WSIException {
        Vector<SOAPFault> soapFaults = new Vector<SOAPFault>();
        BindingFault[] bindingFaults = this.getAllBindingFaults(inBinding);
        for (int fault = 0; fault < bindingFaults.length; ++fault) {
            SOAPFault soapFault = this.getSoapFault(bindingFaults[fault]);
            if (soapFault == null) continue;
            soapFaults.add(soapFault);
        }
        Object[] soapFaultArray = new SOAPFault[soapFaults.size()];
        soapFaults.copyInto(soapFaultArray);
        return soapFaultArray;
    }

    protected BindingFault[] getAllBindingFaults(Binding inBinding) throws WSIException {
        Vector<BindingFault> faults = new Vector<BindingFault>();
        try {
            Iterator bindingOperations = inBinding.getBindingOperations().iterator();
            while (bindingOperations.hasNext()) {
                try {
                    BindingOperation bo = (BindingOperation)bindingOperations.next();
                    Iterator bindingFaults = bo.getBindingFaults().values().iterator();
                    while (bindingFaults.hasNext()) {
                        faults.add((BindingFault)bindingFaults.next());
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Object[] faultArray = new BindingFault[faults.size()];
        faults.copyInto(faultArray);
        return faultArray;
    }

    protected SOAPFault getSoapFault(BindingFault bindingFault) throws WSIException {
        SOAPFault soapFault = null;
        try {
            Iterator faultExtensibles = bindingFault.getExtensibilityElements().iterator();
            while (faultExtensibles.hasNext() && soapFault == null) {
                try {
                    soapFault = (SOAPFault)faultExtensibles.next();
                }
                catch (ClassCastException e) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return soapFault;
    }

    protected SOAPHeader[] getSoapHeaders(Binding inBinding) throws WSIException {
        Binding[] bindingList = new Binding[]{inBinding};
        Vector<SOAPHeader> soapHeaderList = new Vector<SOAPHeader>();
        for (int binding = 0; binding < bindingList.length; ++binding) {
            try {
                BindingOperation[] bindingOperations = bindingList[binding].getBindingOperations().toArray(new BindingOperation[0]);
                for (int bo = 0; bo < bindingOperations.length; ++bo) {
                    try {
                        BindingInput bindingInput = bindingOperations[bo].getBindingInput();
                        BindingOutput bindingOutput = bindingOperations[bo].getBindingOutput();
                        Iterator extElements = bindingInput.getExtensibilityElements().iterator();
                        while (extElements.hasNext()) {
                            try {
                                soapHeaderList.add((SOAPHeader)extElements.next());
                            }
                            catch (ClassCastException e) {}
                        }
                        extElements = bindingOutput.getExtensibilityElements().iterator();
                        while (extElements.hasNext()) {
                            try {
                                soapHeaderList.add((SOAPHeader)extElements.next());
                            }
                            catch (ClassCastException e) {}
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        Object[] soapHeaderArray = new SOAPHeader[soapHeaderList.size()];
        soapHeaderList.copyInto(soapHeaderArray);
        return soapHeaderArray;
    }

    protected SOAPHeaderFault[] getSoapHeaderFaults(Binding inBinding) throws WSIException {
        Vector soapHeaderFaultList = new Vector();
        SOAPHeader[] soapHeaderArray = this.getSoapHeaders(inBinding);
        List list = null;
        for (int header = 0; header < soapHeaderArray.length; ++header) {
            list = soapHeaderArray[header].getSOAPHeaderFaults();
            if (list == null) continue;
            soapHeaderFaultList.addAll(list);
        }
        Object[] soapHeaderFaultArray = new SOAPHeaderFault[soapHeaderFaultList.size()];
        soapHeaderFaultList.copyInto(soapHeaderFaultArray);
        return soapHeaderFaultArray;
    }

    protected SOAPBody[] getSoapBodies(Binding inBinding) throws WSIException {
        Binding[] bindingList = new Binding[]{inBinding};
        Vector<SOAPBody> soapBodies = new Vector<SOAPBody>();
        for (int binding = 0; binding < bindingList.length; ++binding) {
            BindingOperation[] bindingOperations = bindingList[binding].getBindingOperations().toArray(new BindingOperation[0]);
            for (int bo = 0; bo < bindingOperations.length; ++bo) {
                try {
                    Iterator inputExtensibles = bindingOperations[bo].getBindingInput().getExtensibilityElements().iterator();
                    while (inputExtensibles.hasNext()) {
                        try {
                            soapBodies.add((SOAPBody)inputExtensibles.next());
                        }
                        catch (ClassCastException e) {}
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Iterator outputExtensibles = bindingOperations[bo].getBindingOutput().getExtensibilityElements().iterator();
                    while (outputExtensibles.hasNext()) {
                        try {
                            soapBodies.add((SOAPBody)outputExtensibles.next());
                        }
                        catch (ClassCastException e) {}
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        Object[] soapBodyArray = new SOAPBody[soapBodies.size()];
        soapBodies.copyInto(soapBodyArray);
        return soapBodyArray;
    }

    protected SOAPBody getSoapBody(BindingInput bindingInput) throws WSIException {
        SOAPBody soapBody = null;
        for (Object extensible : bindingInput.getExtensibilityElements()) {
            if (!(extensible instanceof SOAPBody)) continue;
            soapBody = (SOAPBody)extensible;
            break;
        }
        return soapBody;
    }

    protected SOAPBody getSoapBody(BindingOutput bindingOutput) throws WSIException {
        SOAPBody soapBody = null;
        for (Object extensible : bindingOutput.getExtensibilityElements()) {
            if (!(extensible instanceof SOAPBody)) continue;
            soapBody = (SOAPBody)extensible;
            break;
        }
        return soapBody;
    }

    protected String getSchemaUsed(Definition def) throws AssertionFailException {
        String schemaUsed = "";
        try {
            Element element;
            Document document = this.wsdlDocument.getDocument();
            if (document == null) {
                document = this.parseXMLDocumentURL(def.getDocumentBaseURI(), null);
            }
            if (document != null && (element = document.getDocumentElement()) != null) {
                schemaUsed = element.getNamespaceURI();
            }
        }
        catch (WSIException we) {
            throw new AssertionFailException("problem getting WSDL defintions namespace");
        }
        return schemaUsed;
    }

    public static SOAPBinding getSoapBinding(Binding binding) throws WSIException {
        SOAPBinding soapBinding = null;
        List exElements = binding.getExtensibilityElements();
        if (exElements != null) {
            Iterator iterator = binding.getExtensibilityElements().iterator();
            while (iterator.hasNext() && soapBinding == null) {
                try {
                    soapBinding = (SOAPBinding)iterator.next();
                }
                catch (ClassCastException e) {}
            }
        }
        return soapBinding;
    }

    protected XMLSchemaValidator createXMLSchemaValidator(String documentBaseURI) {
        return new XMLSchemaValidator(documentBaseURI);
    }

    protected List getSchemaTargetNamespaceList(Definition definition) throws WSIException {
        Vector list = null;
        List nextList = null;
        Types types = null;
        types = definition.getTypes();
        if (types != null) {
            Iterator iterator = types.getExtensibilityElements().iterator();
            ExtensibilityElement extElement = null;
            while (iterator.hasNext()) {
                extElement = (ExtensibilityElement)iterator.next();
                TargetNamespaceProcessor tnsProcessor = null;
                if (!(extElement instanceof Schema)) continue;
                tnsProcessor = new TargetNamespaceProcessor(definition.getDocumentBaseURI());
                nextList = tnsProcessor.processAllSchema(((Schema)extElement).getElement());
                if (nextList != null && list == null) {
                    list = new Vector();
                }
                list.addAll(nextList);
            }
        }
        return list;
    }

    protected List getSchemaNamespaceList(Definition definition) throws WSIException {
        Map importMap;
        Vector list = new Vector();
        List targetNamespaceList = this.getSchemaTargetNamespaceList(definition);
        if (targetNamespaceList != null && !targetNamespaceList.isEmpty()) {
            list.addAll(targetNamespaceList);
        }
        if ((importMap = definition.getImports()) != null && !importMap.isEmpty()) {
            for (List importList : importMap.values()) {
                for (Import imp : importList) {
                    if (imp == null || imp.getDefinition() == null) continue;
                    list.addAll(this.getSchemaNamespaceList(imp.getDefinition()));
                }
            }
        }
        return list;
    }

    protected List getWSDLTargetNamespaceList(Definition definition) {
        return this.getWSDLTargetNamespaceList(definition, new ArrayList());
    }

    protected List getWSDLTargetNamespaceList(Definition definition, List alreadyProcessedDefinitions) {
        ArrayList<String> list = new ArrayList<String>();
        if (definition != null && !alreadyProcessedDefinitions.contains(definition)) {
            Map importMap;
            alreadyProcessedDefinitions.add(definition);
            if (definition.getTargetNamespace() != null) {
                list.add(definition.getTargetNamespace());
            }
            if ((importMap = definition.getImports()) != null && !importMap.isEmpty()) {
                for (List importList : importMap.values()) {
                    for (Import imp : importList) {
                        if (imp == null || imp.getDefinition() == null) continue;
                        list.addAll(this.getWSDLTargetNamespaceList(imp.getDefinition(), alreadyProcessedDefinitions));
                    }
                }
            }
        }
        return list;
    }

    public BindingMatch[] getBindingMatches(Binding binding, String soapBindingStyle, String soapBodyUse) throws WSIException {
        Vector<BindingMatch> bindingMatches = new Vector<BindingMatch>();
        SOAPBinding soapBinding = WSDLValidatorImpl.getSoapBinding(binding);
        if (soapBinding != null) {
            List bindingOpsList;
            String defaultStyle = soapBinding.getStyle();
            if (defaultStyle == null) {
                defaultStyle = "document";
            }
            if ((bindingOpsList = binding.getBindingOperations()) != null) {
                for (BindingOperation bindingOp : bindingOpsList) {
                    SOAPBody outputSoapBody;
                    BindingOutput bOutput;
                    SOAPBody inputSoapBody;
                    SOAPOperation soapOp = WSDLValidatorImpl.getSoapOperation(bindingOp);
                    if (!(soapOp == null && defaultStyle.equals(soapBindingStyle) || soapOp != null && soapOp.getStyle() == null && defaultStyle.equals(soapBindingStyle)) && (soapOp == null || soapOp.getStyle() == null || !soapOp.getStyle().equals(soapBindingStyle))) continue;
                    BindingInput bInput = bindingOp.getBindingInput();
                    if (bInput != null && ((inputSoapBody = this.getSoapBody(bInput)) == null || inputSoapBody.getUse() != null && !inputSoapBody.getUse().equals(soapBodyUse))) {
                        bInput = null;
                    }
                    if ((bOutput = bindingOp.getBindingOutput()) != null && ((outputSoapBody = this.getSoapBody(bOutput)) == null || outputSoapBody.getUse() != null && !outputSoapBody.getUse().equals(soapBodyUse))) {
                        bOutput = null;
                    }
                    if (bOutput == null && bInput == null) continue;
                    bindingMatches.add(new BindingMatch(binding, bindingOp, soapBinding, bInput, bOutput));
                }
            }
        }
        Object[] BindingMatchArray = new BindingMatch[bindingMatches.size()];
        bindingMatches.copyInto(BindingMatchArray);
        return BindingMatchArray;
    }

    public static SOAPOperation getSoapOperation(BindingOperation bindingOperation) throws WSIException {
        if (bindingOperation.getExtensibilityElements() == null) {
            return null;
        }
        for (Object extensible : bindingOperation.getExtensibilityElements()) {
            if (!(extensible instanceof SOAPOperation)) continue;
            return (SOAPOperation)extensible;
        }
        return null;
    }

    protected HashMap getSoapOperations(Binding binding) throws WSIException {
        HashMap soapOperationList = new HashMap();
        if (binding.getBindingOperations() == null) {
            return null;
        }
        Iterator operations = binding.getBindingOperations().iterator();
        BindingOperation bindingOperation = null;
        while (operations.hasNext()) {
            bindingOperation = (BindingOperation)operations.next();
            for (Object extensible : bindingOperation.getExtensibilityElements()) {
                if (!(extensible instanceof SOAPOperation)) continue;
                soapOperationList.put(extensible, bindingOperation.getName());
            }
        }
        return soapOperationList;
    }

    protected boolean checkPartAttributes(BindingMatch[] bindingMatch, String inOrOut, String attrib) throws AssertionFailException {
        if (!inOrOut.equals("useInput") && !inOrOut.equals("useOutput") || !attrib.equals("useType") && !attrib.equals("useElement")) {
            return false;
        }
        for (int i = 0; i < bindingMatch.length; ++i) {
            BindingMatch nextMatch = bindingMatch[i];
            BindingOperation bindingOp = nextMatch.getBindingOperation();
            if (bindingOp == null) continue;
            Operation op = bindingOp.getOperation();
            try {
                Iterator<Object> partIteration;
                Message msg;
                if (inOrOut.equals("useInput")) {
                    if (op.getInput() == null || !nextMatch.hasBindingInput()) continue;
                    msg = op.getInput().getMessage();
                } else {
                    if (op.getOutput() == null || !nextMatch.hasBindingOutput()) continue;
                    msg = op.getOutput().getMessage();
                }
                if (msg == null) continue;
                Map parts = msg.getParts();
                List partsNameList = null;
                partsNameList = this.getPartsList(nextMatch, inOrOut);
                if (partsNameList != null) {
                    Vector partsList = new Vector();
                    Iterator partsNameIterator = partsNameList.iterator();
                    while (partsNameIterator.hasNext()) {
                        partsList.add(parts.get((String)partsNameIterator.next()));
                    }
                    partIteration = partsList.iterator();
                } else {
                    partIteration = parts.values().iterator();
                }
                while (partIteration.hasNext()) {
                    Part part = (Part)partIteration.next();
                    QName attributeName = attrib.equals("useElement") ? part.getElementName() : part.getTypeName();
                    if (attributeName != null) continue;
                    throw new AssertionFailException("Name of operation that failed: " + op.getName() + "\n" + op.toString() + "\n" + "\nName of message that failed: " + msg.getQName() + "\n" + msg.toString());
                }
                continue;
            }
            catch (NullPointerException n) {
                throw new AssertionFailException(n.toString());
            }
        }
        return true;
    }

    private List getPartsList(BindingMatch bindingMatch, String type) {
        List partsList = null;
        Iterator iterator = null;
        try {
            BindingOperation bindingOp = bindingMatch.getBindingOperation();
            iterator = type.equals("useInput") ? bindingOp.getBindingInput().getExtensibilityElements().iterator() : bindingOp.getBindingOutput().getExtensibilityElements().iterator();
        }
        catch (NullPointerException e) {
            return null;
        }
        while (iterator.hasNext() && partsList == null) {
            try {
                SOAPBody soapBody = (SOAPBody)iterator.next();
                partsList = soapBody.getParts();
            }
            catch (ClassCastException cce) {}
        }
        return partsList;
    }

    protected ElementLocation getElementLocation(WSDLDocument wsdlDocument, Object wsdlElement) {
        ElementLocation elementLocation = null;
        WSDLElementList wsdlElementList = wsdlDocument.getElementList();
        if (wsdlElementList != null) {
            elementLocation = wsdlElementList.getElementLocation(wsdlElement);
        }
        return elementLocation;
    }

    protected FailureDetail createFailureDetail(String message, EntryContext entryContext) {
        return this.createFailureDetail(message, entryContext, entryContext.getEntry().getEntryDetail());
    }

    protected FailureDetail createFailureDetail(String message, EntryContext entryContext, Object wsdlElement) {
        FailureDetail failureDetail = this.reporter.createFailureDetail();
        failureDetail.setFailureMessage(message);
        failureDetail.setElementLocation(this.getElementLocation(entryContext.getWSDLDocument(), wsdlElement));
        return failureDetail;
    }

    protected boolean namespaceFoundInSoapLiteral(ExtensibilityElement extElement) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = extElement.getClass();
        Method getUseMethod = c.getMethod("getUse", new Class[0]);
        Method getNamespaceURIMethod = c.getMethod("getNamespaceURI", new Class[0]);
        if (getUseMethod.invoke((Object)extElement, null) == null || !getUseMethod.invoke((Object)extElement, null).equals("literal")) {
            return false;
        }
        boolean namespaceFound = getNamespaceURIMethod.invoke((Object)extElement, null) != null;
        return namespaceFound;
    }

    protected boolean isLiteral(ExtensibilityElement extensible) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = extensible.getClass();
        Method getUseMethod = c.getMethod("getUse", new Class[0]);
        return getUseMethod.invoke((Object)extensible, null) != null && getUseMethod.invoke((Object)extensible, null).equals("literal");
    }

    public boolean runTests() {
        return this.testable;
    }

    protected class BindingMatch {
        private Binding binding;
        private BindingOperation bindingOperation;
        private SOAPBinding soapBinding;
        private BindingInput bindingInput;
        private BindingOutput bindingOutput;

        public BindingMatch(Binding b, BindingOperation bo, SOAPBinding sb, BindingInput bin, BindingOutput bout) {
            this.binding = b;
            this.bindingOperation = bo;
            this.soapBinding = sb;
            this.bindingInput = bin;
            this.bindingOutput = bout;
        }

        public BindingMatch(Binding b, BindingOperation bo, SOAPBinding sb, BindingInput bin) {
            this(b, bo, sb, bin, null);
        }

        public BindingMatch(Binding b, BindingOperation bo, SOAPBinding sb, BindingOutput bout) {
            this(b, bo, sb, null, bout);
        }

        public SOAPBinding getSoapBinding() {
            return this.soapBinding;
        }

        public BindingOperation getBindingOperation() {
            return this.bindingOperation;
        }

        public BindingInput getBindingInput() {
            return this.bindingInput;
        }

        public BindingOutput getBindingOutput() {
            return this.bindingOutput;
        }

        public boolean hasBindingInput() {
            return this.bindingInput != null;
        }

        public boolean hasBindingOutput() {
            return this.bindingOutput != null;
        }

        public Binding getBinding() {
            return this.binding;
        }
    }
}

