/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsi.internal.WSITestToolsPlugin;

public class ArtifactType {
    private String type;
    private static Map typeMap;
    private static List loggableArtifactTypes;
    public static final String TYPE_ENVELOPE = "envelope";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_DISCOVERY = "discovery";
    public static final ArtifactType ARTIFACT_TYPE_ENVELOPE;
    public static final ArtifactType ARTIFACT_TYPE_MESSAGE;
    public static final ArtifactType ARTIFACT_TYPE_DESCRIPTION;
    public static final ArtifactType ARTIFACT_TYPE_DISCOVERY;

    private ArtifactType(String type) {
        this.type = type;
    }

    public boolean isLoggable() {
        if (loggableArtifactTypes == null) {
            String[] artifactArray = WSITestToolsPlugin.getPlugin().getAllReportArtifactTypes();
            loggableArtifactTypes = new ArrayList(artifactArray.length);
            for (int i = 0; i < artifactArray.length; ++i) {
                loggableArtifactTypes.add(artifactArray[i]);
            }
        }
        return loggableArtifactTypes.contains(this.type);
    }

    public boolean isEnvelope() {
        return this.type.equals(TYPE_ENVELOPE);
    }

    public boolean isMessages() {
        return this.type.equals(TYPE_MESSAGE);
    }

    public boolean isDescription() {
        return this.type.equals(TYPE_DESCRIPTION);
    }

    public boolean isDiscovery() {
        return this.type.equals(TYPE_DISCOVERY);
    }

    public String getTypeName() {
        return this.type;
    }

    public static void registerArtifactType(String name) {
        if (typeMap == null) {
            typeMap = new HashMap();
        }
        typeMap.put(name, new ArtifactType(name));
    }

    public static final ArtifactType getArtifactType(String typeName) throws RuntimeException {
        if (typeMap == null) {
            String[] types = WSITestToolsPlugin.getPlugin().getArtifactTypes();
            for (int i = 0; i < types.length; ++i) {
                ArtifactType.registerArtifactType(types[i]);
            }
        }
        if (typeMap == null) {
            return ArtifactType.newArtifactType(typeName);
        }
        if (typeMap.containsKey(typeName)) {
            return (ArtifactType)typeMap.get(typeName);
        }
        throw new RuntimeException("Could not create new artifact type using invalid type name: " + typeName + ".");
    }

    public static final ArtifactType newArtifactType(String typeName) throws RuntimeException {
        ArtifactType artifactType = null;
        if (typeName.equals(TYPE_DESCRIPTION)) {
            artifactType = ARTIFACT_TYPE_DESCRIPTION;
        } else if (typeName.equals(TYPE_MESSAGE)) {
            artifactType = ARTIFACT_TYPE_MESSAGE;
        } else if (typeName.equals(TYPE_ENVELOPE)) {
            artifactType = ARTIFACT_TYPE_ENVELOPE;
        } else if (typeName.equals(TYPE_DISCOVERY)) {
            artifactType = ARTIFACT_TYPE_DISCOVERY;
        } else {
            throw new RuntimeException("Could not create new artifact type using invalid type name: " + typeName + ".");
        }
        return artifactType;
    }

    static {
        ARTIFACT_TYPE_ENVELOPE = new ArtifactType(TYPE_ENVELOPE);
        ARTIFACT_TYPE_MESSAGE = new ArtifactType(TYPE_MESSAGE);
        ARTIFACT_TYPE_DESCRIPTION = new ArtifactType(TYPE_DESCRIPTION);
        ARTIFACT_TYPE_DISCOVERY = new ArtifactType(TYPE_DISCOVERY);
    }
}

