/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.StringTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.wst.wsi.internal.core.util.BasicRules;
import sun.net.www.MessageHeader;

public class HttpHeadersValidator {
    private static final String HEADER_ALLOW = "Allow";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_CONTENT_LANGUAGE = "Content-Language";
    private static final String HEADER_CONTENT_LENGHT = "Content-Length";
    private static final String HEADER_CONTENT_LOCATION = "Content-Location";
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_DATE = "Date";
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_TRAILER = "Trailer";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_UPGRADE = "Upgrade";
    private static final String HEADER_VIA = "Via";
    private static final String HEADER_WARNING = "Warning";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_EXPECT = "Expect";
    private static final String HEADER_FROM = "From";
    private static final String HEADER_HOST = "Host";
    private static final String HEADER_IF_MATCH = "If-Match";
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_IF_RANGE = "If-Range";
    private static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String HEADER_MAX_FORWARDS = "Max-Forwards";
    private static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String HEADER_RANGE = "Range";
    private static final String HEADER_REFERER = "Referer";
    private static final String HEADER_TE = "TE";
    private static final String HEADER_USER_AGENT = "User-Agent";

    public static boolean validateHttpRequestHeaders(String headers) {
        MessageHeader mh = new MessageHeader();
        try {
            mh.parseHeader(new ByteArrayInputStream(headers.getBytes()));
        }
        catch (IOException e) {
            return false;
        }
        String header = null;
        String value = null;
        header = mh.getKey(0);
        if (header != null) {
            return false;
        }
        value = mh.getValue(0);
        if (value == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        if (!st.hasMoreElements()) {
            return false;
        }
        String str = st.nextToken();
        if (!HttpHeadersValidator.isToken(str)) {
            return false;
        }
        if (!st.hasMoreElements()) {
            return false;
        }
        str = st.nextToken();
        if (!HttpHeadersValidator.isURI(str) && !str.equals("*")) {
            return false;
        }
        if (!st.hasMoreElements()) {
            return false;
        }
        str = st.nextToken();
        if (!HttpHeadersValidator.isHTTPVersion(str)) {
            return false;
        }
        int i = 1;
        try {
            while ((header = mh.getKey(i)) != null) {
                value = mh.getValue(i);
                ++i;
                if (!HttpHeadersValidator.isToken(header)) {
                    return false;
                }
                if (!(header.equals(HEADER_ALLOW) ? !HttpHeadersValidator.isValidAllow(value) : (header.equals(HEADER_CONTENT_TYPE) ? !HttpHeadersValidator.isMediaType(value) : (header.equals(HEADER_CONTENT_ENCODING) ? !HttpHeadersValidator.isToken(value) : (header.equals(HEADER_CONTENT_LANGUAGE) ? !HttpHeadersValidator.isLanguageTag(value) : (header.equals(HEADER_CONTENT_LENGHT) ? !HttpHeadersValidator.isDidgit(value) : (header.equals(HEADER_CONTENT_LOCATION) ? !HttpHeadersValidator.isURI(value) : (header.equals(HEADER_CONTENT_RANGE) ? !HttpHeadersValidator.isValidContentRange(value) : (header.equals(HEADER_EXPIRES) || header.equals(HEADER_LAST_MODIFIED) ? !HttpHeadersValidator.isHTTPDate(value) : (header.equals(HEADER_CACHE_CONTROL) ? !HttpHeadersValidator.isValidCacheControl(value) : (header.equals(HEADER_CONNECTION) ? !HttpHeadersValidator.isToken(value) : (header.equals(HEADER_DATE) ? !HttpHeadersValidator.isHTTPDate(value) : (header.equals(HEADER_PRAGMA) ? !HttpHeadersValidator.isPragmaDerective(value) : (header.equals(HEADER_TRAILER) ? !HttpHeadersValidator.isToken(value) : (header.equals(HEADER_TRANSFER_ENCODING) ? !HttpHeadersValidator.isTransferCoding(value) : (header.equals(HEADER_UPGRADE) ? !HttpHeadersValidator.isValidUpgrade(value) : (header.equals(HEADER_VIA) ? !HttpHeadersValidator.isValidVia(value) : (header.equals(HEADER_WARNING) ? !HttpHeadersValidator.isValidWarning(value) : (header.equals(HEADER_ACCEPT) ? !HttpHeadersValidator.isValidAccept(value) : (header.equals(HEADER_ACCEPT_CHARSET) ? !HttpHeadersValidator.isValidAcceptCharSet(value) : (header.equals(HEADER_ACCEPT_ENCODING) ? !HttpHeadersValidator.isValidAcceptEncoding(value) : (header.equals(HEADER_ACCEPT_LANGUAGE) ? !HttpHeadersValidator.isValidAcceptLanguage(value) : (header.equals(HEADER_AUTHORIZATION) || header.equals(HEADER_PROXY_AUTHORIZATION) ? !HttpHeadersValidator.isCredentials(value) : (header.equals(HEADER_EXPECT) ? !HttpHeadersValidator.isExpectation(value) : (header.equals(HEADER_FROM) ? !MailboxValidator.validateMailbox(value) : (header.equals(HEADER_IF_MATCH) || header.equals(HEADER_IF_NONE_MATCH) ? !HttpHeadersValidator.isValidIfMatch(value) : (header.equals(HEADER_IF_RANGE) ? !HttpHeadersValidator.isEntityTag(value) && !HttpHeadersValidator.isHTTPDate(value) : (header.equals(HEADER_IF_MODIFIED_SINCE) ? !HttpHeadersValidator.isHTTPDate(value) : (header.equals(HEADER_IF_UNMODIFIED_SINCE) ? !HttpHeadersValidator.isHTTPDate(value) : (header.equals(HEADER_MAX_FORWARDS) ? !HttpHeadersValidator.isDidgit(value) : (header.equals(HEADER_USER_AGENT) ? !HttpHeadersValidator.isValidUserAgent(value) : (header.equals(HEADER_TE) ? !HttpHeadersValidator.isValidTE(value) : (header.equals(HEADER_RANGE) ? !HttpHeadersValidator.isRange(value) : (header.equals(HEADER_HOST) ? !HttpHeadersValidator.isHost(value) : header.equals(HEADER_REFERER) && !HttpHeadersValidator.isURI(value))))))))))))))))))))))))))))))))))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isValidIfMatch(String value) {
        if (value.trim().length() == 0) {
            return true;
        }
        if ("*".equals(value.trim())) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            if (HttpHeadersValidator.isEntityTag(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidUpgrade(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            if (HttpHeadersValidator.isProduct(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCacheControl(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            int index = str.indexOf(61);
            if (index == -1) continue;
            if (!HttpHeadersValidator.isToken(str.substring(0, index))) {
                return false;
            }
            String strAfterEq = str.substring(index + 1);
            if (HttpHeadersValidator.isToken(strAfterEq) || HttpHeadersValidator.isQuotedString(strAfterEq)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHTTPVersion(String str) {
        int idx2;
        if (!str.startsWith("HTTP/")) {
            return false;
        }
        int idx = "HTTP/".length();
        String s = str.substring(idx, idx2 = str.indexOf("."));
        if (!HttpHeadersValidator.isDidgit(s)) {
            return false;
        }
        s = str.substring(idx2 + 1);
        return HttpHeadersValidator.isDidgit(s);
    }

    private static boolean isValidWarning(String value) {
        if (value.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value = value.trim(), " ");
        String str = st.nextToken();
        if (str.length() > 3 || !HttpHeadersValidator.isDidgit(str)) {
            return false;
        }
        if (!st.hasMoreTokens()) {
            return false;
        }
        str = st.nextToken();
        if (!HttpHeadersValidator.isHost(str) && !HttpHeadersValidator.isToken(str)) {
            return false;
        }
        str = st.nextToken("").trim();
        int lastQuotedString = BasicRules.getLastQuotedString(str, 0);
        if (lastQuotedString == str.length()) {
            return true;
        }
        String data = str.substring(lastQuotedString);
        if (data.charAt(data.length()) != '\"') {
            return false;
        }
        if (str.charAt(0) != '\"') {
            return false;
        }
        return HttpHeadersValidator.isHTTPDate(str.substring(1, data.length() - 1));
    }

    private static boolean isValidVia(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            StringTokenizer st2 = new StringTokenizer(str, " ");
            int idx = (str = st2.nextToken()).indexOf("/");
            if (idx == -1 ? !HttpHeadersValidator.isToken(str) : !HttpHeadersValidator.isToken(str.substring(0, idx)) || !HttpHeadersValidator.isToken(str.substring(idx + 1))) {
                return false;
            }
            str = st2.nextToken();
            if (!HttpHeadersValidator.isHost(str) && !HttpHeadersValidator.isToken(str)) {
                return false;
            }
            if (!st2.hasMoreTokens() || HttpHeadersValidator.isComment((str = st2.nextToken("")).trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean isHost(String value) {
        try {
            new URL("http://" + value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidAllow(String value) {
        if (value.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            if (HttpHeadersValidator.isToken(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidContentRange(String value) {
        if (value.length() == 0) {
            return false;
        }
        if (!value.startsWith("bytes")) {
            return false;
        }
        String str = value.substring("bytes".length()).trim();
        int idx = str.indexOf("/");
        if (idx == -1) {
            return false;
        }
        String byteRange = str.substring(0, idx);
        int idx2 = byteRange.indexOf("-");
        if (idx2 == -1 ? !byteRange.equals("*") : !HttpHeadersValidator.isDidgit(byteRange.substring(0, idx2)) || !HttpHeadersValidator.isDidgit(byteRange.substring(idx2 + 1))) {
            return false;
        }
        return HttpHeadersValidator.isDidgit(str.substring(idx + 1)) || str.substring(idx + 1).equals("*");
    }

    private static boolean isRange(String value) {
        if (value.length() == 0) {
            return false;
        }
        if (!value.startsWith("bytes=")) {
            return false;
        }
        String strByteRange = value.substring("bytes=".length());
        StringTokenizer st = new StringTokenizer(strByteRange, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken();
            int idx = str.indexOf("-");
            if (idx == -1) {
                return false;
            }
            if (!(idx == 0 ? !HttpHeadersValidator.isDidgit(str.substring(1)) : (idx == str.length() - 1 ? !HttpHeadersValidator.isDidgit(str.substring(0, str.length() - 1)) : !HttpHeadersValidator.isDidgit(str.substring(0, idx)) || !HttpHeadersValidator.isDidgit(str.substring(idx + 1))))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidTE(String value) {
        if (value.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            if (st.equals("trailers")) {
                return true;
            }
            int idx = str.indexOf(";");
            if (idx == -1) {
                if (HttpHeadersValidator.isLanguageRange(str)) continue;
                return false;
            }
            String _1 = str.substring(0, idx).trim();
            String _2 = str.substring(idx + 1).trim();
            if (!HttpHeadersValidator.isLanguageRange(_1)) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidUserAgent(String value) {
        if (value.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        while (st.hasMoreElements()) {
            String str = st.nextToken();
            if (HttpHeadersValidator.isProduct(str) || HttpHeadersValidator.isComment(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean isComment(String str) {
        return BasicRules.getLastComment(str, 0) == str.length();
    }

    private static boolean isValidAcceptLanguage(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            int idx = str.indexOf(";");
            if (idx == -1) {
                if (HttpHeadersValidator.isToken(str)) continue;
                return false;
            }
            String _1 = str.substring(0, idx).trim();
            String _2 = str.substring(idx + 1).trim();
            if (!HttpHeadersValidator.isToken(_1)) {
                return false;
            }
            if (HttpHeadersValidator.isAcceptParams(_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLanguageRange(String str) {
        if (str.trim().equals("*")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(str, "-");
        while (st.hasMoreElements()) {
            if (HttpHeadersValidator.is8ALPHA(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAcceptEncoding(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            int idx = str.indexOf(";");
            if (idx == -1) {
                if (HttpHeadersValidator.isToken(str) || str.equals("*")) continue;
                return false;
            }
            String _1 = str.substring(0, idx).trim();
            String _2 = str.substring(idx + 1).trim();
            if (!HttpHeadersValidator.isToken(_1) && !_1.equals("*")) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAcceptCharSet(String value) {
        if (value.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            int idx = str.indexOf(";");
            if (idx == -1) {
                if (HttpHeadersValidator.isToken(str) || str.equals("*")) continue;
                return false;
            }
            String _1 = str.substring(0, idx).trim();
            String _2 = str.substring(idx + 1).trim();
            if (!HttpHeadersValidator.isToken(_1) && !_1.equals("*")) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAccept(String value) {
        if (value.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String str = st.nextToken().trim();
            int idx = str.indexOf(";");
            if (!(idx == -1 ? !HttpHeadersValidator.isMediaRange(str) : !HttpHeadersValidator.isMediaRange(str.substring(0, idx).trim()) || !HttpHeadersValidator.isAcceptParams(str.substring(idx + 1).trim()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAcceptParams(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(string, ";");
        String str = st.nextToken();
        int idx = str.indexOf("=");
        if (idx == -1 ? str.equals("q") || !HttpHeadersValidator.isToken(str) : (str.substring(0, idx).equals("q") ? !HttpHeadersValidator.isQValue(str.substring(idx + 1)) : !HttpHeadersValidator.isParameterWithoutValue(str))) {
            return false;
        }
        while (st.hasMoreElements()) {
            str = st.nextToken();
            if (HttpHeadersValidator.isParameterWithoutValue(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean isQAndQValue(String str) {
        if (!(str = str.trim()).trim().startsWith("q=")) {
            return false;
        }
        return HttpHeadersValidator.isQValue(str.substring("q=".length()));
    }

    private static boolean isQValue(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        int idx = string.indexOf(".");
        if (idx == -1) {
            if (!"0".equals(string) && !"1".equals(string)) {
                return false;
            }
        } else {
            String strDig = string.substring(idx + 1);
            if (strDig.length() > 3) {
                return false;
            }
            if (string.substring(0, idx).equals("0")) {
                if (!HttpHeadersValidator.isDidgit(strDig)) {
                    return false;
                }
            } else {
                if (!string.substring(0, idx).equals("1")) {
                    return false;
                }
                for (int i = 0; i < strDig.length(); ++i) {
                    if (strDig.charAt(i) == '0') continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isMediaRange(String str) {
        if (str.trim().length() == 0) {
            return false;
        }
        int idx = str.indexOf("/");
        if (idx == -1) {
            return false;
        }
        if (!HttpHeadersValidator.isToken(str.substring(0, idx)) && !str.substring(0, idx).equals("*")) {
            return false;
        }
        return HttpHeadersValidator.isToken(str.substring(idx + 1)) || str.substring(idx + 1).equals("*");
    }

    private static boolean isEntityTag(String value) {
        int idx = 0;
        if (value.startsWith("W/")) {
            idx = 2;
        }
        return HttpHeadersValidator.isQuotedString(value.substring(idx));
    }

    private static boolean isExpectation(String value) {
        if (value.equals("100-continue")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreElements()) {
            if (HttpHeadersValidator.isParameterWithoutValue(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCredentials(String value) {
        StringTokenizer st = new StringTokenizer(value, " ");
        if (!HttpHeadersValidator.isToken(st.nextToken())) {
            return false;
        }
        while (st.hasMoreElements()) {
            String param = st.nextToken(",");
            if (HttpHeadersValidator.isParameter(param)) continue;
            return false;
        }
        return true;
    }

    private static boolean isProduct(String value) {
        int idx = value.indexOf("/");
        return !(idx == -1 ? !HttpHeadersValidator.isToken(value) : !HttpHeadersValidator.isToken(value.substring(0, idx)) || !HttpHeadersValidator.isToken(value.substring(idx + 1)));
    }

    private static boolean isTransferCoding(String value) {
        if (value.equals("chunked")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ";");
        if (!HttpHeadersValidator.isToken(st.nextToken())) {
            return false;
        }
        while (st.hasMoreElements()) {
            if (HttpHeadersValidator.isParameter(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isParameter(String string) {
        int idx = string.indexOf("=");
        if (!HttpHeadersValidator.isToken(string.substring(0, idx))) {
            return false;
        }
        String parValue = string.substring(idx + 1);
        return HttpHeadersValidator.isToken(parValue) || HttpHeadersValidator.isQuotedString(parValue);
    }

    private static boolean isParameterWithoutValue(String string) {
        int idx = string.indexOf("=");
        if (idx != -1) {
            if (!HttpHeadersValidator.isToken(string.substring(0, idx))) {
                return false;
            }
            String parValue = string.substring(idx + 1);
            if (!HttpHeadersValidator.isToken(parValue) && !HttpHeadersValidator.isQuotedString(parValue)) {
                return false;
            }
        } else if (!HttpHeadersValidator.isToken(string)) {
            return false;
        }
        return true;
    }

    private static boolean isPragmaDerective(String value) {
        if (value.equals("no-cache")) {
            return true;
        }
        int idx = value.indexOf("=");
        if (idx == -1) {
            if (HttpHeadersValidator.isToken(value)) {
                return true;
            }
        } else {
            String str = value.substring(idx + 1);
            if (HttpHeadersValidator.isToken(value.substring(0, idx)) && (HttpHeadersValidator.isToken(str) || HttpHeadersValidator.isQuotedString(str))) {
                return true;
            }
        }
        return true;
    }

    private static boolean isHTTPDate(String value) {
        SimpleDateFormat sdf;
        String rfc1123_date = "EEE, dd MMM yyyy hh:mm:ss 'GMT'";
        String rfc850_date = "EEEE, dd-MMM-yy hh:mm:ss 'GMT'";
        String asctime_date = "EEE MMM d hh:mm:ss yyyy";
        try {
            sdf = new SimpleDateFormat(rfc1123_date, Locale.US);
            if (sdf.parse(value) != null) {
                return true;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            sdf = new SimpleDateFormat(rfc850_date, Locale.US);
            if (sdf.parse(value) != null) {
                return true;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            sdf = new SimpleDateFormat(asctime_date, Locale.US);
            if (sdf.parse(value) != null) {
                return true;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return false;
    }

    private static boolean isURI(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            try {
                new URL("http://localhost" + value);
            }
            catch (MalformedURLException e2) {
                return false;
            }
        }
        return true;
    }

    private static boolean isLanguageTag(String value) {
        int idx = value.indexOf("-");
        if (idx == -1) {
            return HttpHeadersValidator.is8ALPHA(value);
        }
        return HttpHeadersValidator.is8ALPHA(value.substring(0, idx)) && HttpHeadersValidator.is8ALPHA(value.substring(idx + 1));
    }

    private static boolean is8ALPHA(String string) {
        return string.length() <= 8 && HttpHeadersValidator.isALPHA(string);
    }

    private static boolean isALPHA(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (BasicRules.isCHAR(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDidgit(String value) {
        if (value.length() == 0) {
            return false;
        }
        char[] chs = value.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] >= '0' && chs[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isMediaType(String value) {
        int idx;
        StringTokenizer st = new StringTokenizer(value, ";");
        String mediaType = st.nextToken();
        if (!HttpHeadersValidator.isToken(mediaType.substring(0, idx = mediaType.indexOf("/"))) || !HttpHeadersValidator.isToken(mediaType.substring(idx + 1))) {
            return false;
        }
        while (st.hasMoreElements()) {
            if (HttpHeadersValidator.isParameter(st.nextToken(";").trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean isQuotedString(String parValue) {
        return BasicRules.getLastQuotedString(parValue, 0) == parValue.length();
    }

    private static boolean isToken(String value) {
        return BasicRules.isToken(value);
    }

    public static class MailboxValidator {
        private static final char[] SPECIAL = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '.', '[', ']'};

        public static boolean validateMailbox(String mailbox) {
            return MailboxValidator.isFullAddr(mailbox) || MailboxValidator.isShortAddr(mailbox);
        }

        private static boolean isShortAddr(String mailbox) {
            int indexAt = mailbox.indexOf(64);
            if (indexAt == -1) {
                return false;
            }
            return MailboxValidator.isLocalPart(mailbox.substring(0, indexAt)) && MailboxValidator.isDomain(mailbox.substring(indexAt + 1));
        }

        private static boolean isDomain(String string) {
            if (string.trim().length() == 0) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(string, ".");
            while (st.hasMoreTokens()) {
                String subDomain = st.nextToken();
                if (MailboxValidator.isAtom(subDomain) || MailboxValidator.isDomainLiteral(subDomain)) continue;
                return false;
            }
            return true;
        }

        private static boolean isDomainLiteral(String subDomain) {
            return MailboxValidator.getLastDomainLiteral(subDomain, 0) == subDomain.length();
        }

        private static int getLastDomainLiteral(String str, int startIndex) {
            int index;
            block5: {
                index = startIndex;
                if (startIndex == str.length()) {
                    return startIndex;
                }
                if (str.charAt(index) != '[') {
                    return startIndex;
                }
                ++index;
                do {
                    if ((index = MailboxValidator.getLastDtext(str, index)) == str.length()) {
                        return startIndex;
                    }
                    if (!BasicRules.isQuotedPair(str, index - 1)) break block5;
                } while (++index != str.length());
                return startIndex;
            }
            if (str.charAt(index) != ']') {
                return startIndex;
            }
            return ++index;
        }

        private static int getLastDtext(String str, int startIndex) {
            int i;
            if (str.length() == startIndex) {
                return startIndex;
            }
            for (i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                i = BasicRules.getLastIndexLWS(str, i);
                if (BasicRules.isCHAR(ch) && str.charAt(i) != '[' && str.charAt(i) != ']' && str.charAt(i) != '\\' && str.charAt(i) != '\r') continue;
                return i + 1;
            }
            return i + 1;
        }

        private static boolean isLocalPart(String string) {
            if (string.trim().length() == 0) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(string, ".");
            while (st.hasMoreTokens()) {
                if (MailboxValidator.isWord(st.nextToken())) continue;
                return false;
            }
            return true;
        }

        private static boolean isWord(String string) {
            return MailboxValidator.isAtom(string) || HttpHeadersValidator.isQuotedString(string);
        }

        private static boolean isAtom(String string) {
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (BasicRules.isCHAR(string.charAt(i)) && !MailboxValidator.isSpecial(string.charAt(i)) && string.charAt(i) != ' ' && !BasicRules.isCTL(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isSpecial(char ch) {
            for (int index = 0; index < SPECIAL.length; ++index) {
                if (ch != SPECIAL[index]) continue;
                return true;
            }
            return false;
        }

        private static boolean isFullAddr(String mailbox) {
            int idxGT;
            if (mailbox.length() == 0) {
                return false;
            }
            int idxLT = mailbox.indexOf(60);
            if (idxLT == -1) {
                return false;
            }
            String phrase = mailbox.substring(0, idxLT);
            StringTokenizer st = new StringTokenizer(phrase, " ");
            if (st.countTokens() == 0) {
                return false;
            }
            while (st.hasMoreTokens()) {
                if (MailboxValidator.isWord(st.nextToken())) continue;
                return false;
            }
            if (phrase.charAt(phrase.length() - 1) != ' ') {
                return false;
            }
            String routeAddr = mailbox.substring(idxLT + 1);
            int idxTwoSpot = routeAddr.indexOf(58);
            if (idxTwoSpot != -1) {
                StringTokenizer stRouteAddr = new StringTokenizer(routeAddr.substring(0, idxTwoSpot), ",");
                if (!stRouteAddr.hasMoreTokens()) {
                    return false;
                }
                while (stRouteAddr.hasMoreTokens()) {
                    if (MailboxValidator.isDomain(stRouteAddr.nextToken())) continue;
                    return false;
                }
            }
            if ((idxGT = routeAddr.indexOf(62)) == -1 || idxGT != routeAddr.length() - 1) {
                return false;
            }
            return MailboxValidator.isShortAddr(routeAddr.substring(idxTwoSpot + 1, idxGT));
        }
    }
}

