/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.util.BasicRules;

public class SetCookie2Validator {
    private Vector commentVect = new Vector();
    private Vector commentURLVect = new Vector();
    private Vector domainVect = new Vector();
    private Vector max_AgeVect = new Vector();
    private Vector pathVect = new Vector();
    private Vector portVect = new Vector();
    private Vector versionVect = new Vector();
    private boolean path = false;

    private void resetPath() {
        this.path = false;
    }

    public boolean isSetCookie2(String str) {
        try {
            int index = 0;
            int newIndex = 0;
            while (true) {
                if (index == (newIndex = this.getLastCookie(str, index))) {
                    return false;
                }
                index = newIndex;
                if ((index = this.skipSpaces(str, index)) == str.length()) {
                    return true;
                }
                if (str.charAt(index) != ',') {
                    return false;
                }
                ++index;
                index = this.skipSpaces(str, index);
            }
        }
        catch (Throwable th) {
            return false;
        }
    }

    private int getLastCookie(String str, int startIndex) {
        this.resetPath();
        int index = startIndex;
        int newIndex = BasicRules.getLastToken(str, index);
        if (index == newIndex) {
            return startIndex;
        }
        index = newIndex;
        if (index == str.length()) {
            return startIndex;
        }
        if (str.charAt(index) != '=') {
            return startIndex;
        }
        if (++index == str.length()) {
            return startIndex;
        }
        newIndex = this.getLastValue(str, index);
        if (index == newIndex) {
            return startIndex;
        }
        do {
            if ((index = newIndex) == str.length()) {
                return index;
            }
            if (str.charAt(index) != ';') {
                return index;
            }
            ++index;
            if ((index = this.skipSpaces(str, index)) != str.length()) continue;
            return startIndex;
        } while (index != (newIndex = this.getLastSetCookieAv(str, index)));
        return startIndex;
    }

    private int getLastValue(String str, int startIndex) {
        int index = BasicRules.getLastToken(str, startIndex);
        if (index != startIndex) {
            return index;
        }
        index = BasicRules.getLastQuotedString(str, startIndex);
        if (index != startIndex) {
            return index;
        }
        return startIndex;
    }

    private int getLastSetCookieAv(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        if (str.startsWith("Comment=", index)) {
            if ((index += "Comment=".length()) == (newIndex = this.getLastValue(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            this.commentVect.add(qqq);
            return newIndex;
        }
        if (str.startsWith("CommentURL=", index)) {
            if (str.charAt(index += "CommentURL=".length()) != '\"') {
                return startIndex;
            }
            newIndex = str.indexOf(34, index + 1);
            if (newIndex == -1) {
                return startIndex;
            }
            try {
                new URL(str.substring(index + 1, newIndex));
            }
            catch (MalformedURLException mue) {
                return startIndex;
            }
            String qqq = this.getValue(str, index + 1, newIndex);
            this.commentURLVect.add(qqq);
            return ++newIndex;
        }
        if (str.startsWith("Discard", index)) {
            return startIndex + "Discard".length();
        }
        if (str.startsWith("Domain=", index)) {
            if ((index += "Domain=".length()) == (newIndex = this.getLastValue(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            this.domainVect.add(qqq);
            return newIndex;
        }
        if (str.startsWith("Max-Age=", index)) {
            if ((index += "Max-Age=".length()) == (newIndex = this.getLastValue(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            try {
                Integer.parseInt(qqq);
            }
            catch (NumberFormatException nfe) {
                return startIndex;
            }
            this.max_AgeVect.add(qqq);
            return newIndex;
        }
        if (str.startsWith("Path=", index)) {
            if ((index += "Path=".length()) == (newIndex = this.getLastValue(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            if (!this.path) {
                this.pathVect.add(qqq);
            }
            this.path = true;
            return newIndex;
        }
        if (str.startsWith("Port", index)) {
            if (str.charAt(index += "Port".length()) != '=') {
                return index;
            }
            if (str.charAt(++index) != '\"') {
                return startIndex;
            }
            if (++index == (newIndex = this.getLastPortList(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            this.portVect.add(qqq);
            index = newIndex;
            if (str.charAt(index) != '\"') {
                return startIndex;
            }
            return ++index;
        }
        if (str.startsWith("Secure", index)) {
            return startIndex + "Secure".length();
        }
        if (str.startsWith("Version=", index)) {
            if ((index += "Version=".length()) == (newIndex = this.getLastDIGIT(str, index))) {
                return startIndex;
            }
            String qqq = this.getValue(str, index, newIndex);
            this.versionVect.add(qqq);
            return newIndex;
        }
        return startIndex;
    }

    private int getLastPortList(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        while (index != (newIndex = this.getLastDIGIT(str, index))) {
            index = newIndex;
            if (str.charAt(index) != ',') {
                return index;
            }
            ++index;
        }
        return startIndex;
    }

    private int getLastDIGIT(String str, int startIndex) {
        int index;
        for (index = startIndex; index < str.length(); ++index) {
            if (BasicRules.isDIGIT(str.charAt(index))) continue;
            return index;
        }
        return index;
    }

    public boolean isCookie(String str) {
        int index = 0;
        int newIndex = 0;
        try {
            newIndex = this.getLastVersion(str, index);
            if (index == newIndex) {
                return false;
            }
            index = newIndex;
            if (str.charAt(index = this.skipSpaces(str, index)) != ';' && str.charAt(index) != ',') {
                return false;
            }
            ++index;
            index = this.skipSpaces(str, index);
            while (true) {
                if (index == (newIndex = this.getLastCookiesValue(str, index))) {
                    return false;
                }
                index = newIndex;
                if (index == str.length()) {
                    return true;
                }
                if (str.charAt(index) != ';' && str.charAt(index) != ',') {
                    return false;
                }
                ++index;
                index = this.skipSpaces(str, index);
            }
        }
        catch (Throwable th) {
            return false;
        }
    }

    private int getLastVersion(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        if (!str.startsWith("$Version=")) {
            return startIndex;
        }
        if ((index += "$Version=".length()) == (newIndex = this.getLastValue(str, index))) {
            return startIndex;
        }
        return newIndex;
    }

    private int getLastCookiesValue(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        int oldIndex = 0;
        newIndex = BasicRules.getLastToken(str, index);
        if (index == newIndex) {
            return startIndex;
        }
        index = newIndex;
        if (index == str.length()) {
            return startIndex;
        }
        if (str.charAt(index) != '=') {
            return startIndex;
        }
        if (++index == str.length()) {
            return startIndex;
        }
        newIndex = this.getLastValue(str, index);
        if (index == newIndex) {
            return startIndex;
        }
        index = newIndex;
        if (index == str.length()) {
            return index;
        }
        if (str.charAt(index) != ';') {
            return index;
        }
        oldIndex = index++;
        if (index == str.length()) {
            return startIndex;
        }
        if ((index = this.skipSpaces(str, index)) == str.length()) {
            return startIndex;
        }
        newIndex = this.getLastPath(str, index);
        if (index != newIndex) {
            index = newIndex;
            if (index == str.length()) {
                return index;
            }
            if (str.charAt(index) != ';') {
                return index;
            }
            oldIndex = index++;
            if (index == str.length()) {
                return startIndex;
            }
            if ((index = this.skipSpaces(str, index)) == str.length()) {
                return startIndex;
            }
        }
        if (index != (newIndex = this.getLastDomain(str, index))) {
            index = newIndex;
            if (index == str.length()) {
                return index;
            }
            if (str.charAt(index) != ';') {
                return index;
            }
            oldIndex = index++;
            if (index == str.length()) {
                return startIndex;
            }
            if ((index = this.skipSpaces(str, index)) == str.length()) {
                return startIndex;
            }
        }
        if (index != (newIndex = this.getLastPort(str, index))) {
            return newIndex;
        }
        return oldIndex;
    }

    private int getLastPath(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        if (!str.startsWith("$Path=", index)) {
            return startIndex;
        }
        if ((index += "$Path=".length()) == (newIndex = this.getLastValue(str, index))) {
            return startIndex;
        }
        return newIndex;
    }

    private int getLastDomain(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        if (!str.startsWith("$Domain=", index)) {
            return startIndex;
        }
        if ((index += "$Domain=".length()) == (newIndex = this.getLastValue(str, index))) {
            return startIndex;
        }
        return newIndex;
    }

    private int getLastPort(String str, int startIndex) {
        int index = startIndex;
        int newIndex = 0;
        if (!str.startsWith("$Port", index)) {
            return startIndex;
        }
        if (str.charAt(index += "$Port".length()) != '=') {
            return index;
        }
        if (str.charAt(++index) != '\"') {
            return startIndex;
        }
        if (++index == (newIndex = this.getLastPortList(str, index))) {
            return startIndex;
        }
        index = newIndex;
        if (str.charAt(index) != '\"') {
            return startIndex;
        }
        return ++index;
    }

    private int skipSpaces(String str, int index) {
        while (index < str.length() && BasicRules.isSP(str.charAt(index))) {
            ++index;
        }
        return index;
    }

    private String getValue(String str, int beg, int end) {
        String qqq = null;
        qqq = str.charAt(beg) == '\"' ? str.substring(beg + 1, end - 1) : str.substring(beg, end);
        return qqq;
    }
}

