/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.governance.registry.extensions.executors.CopyExecutor;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class TransformAndCopyExecutor
extends CopyExecutor {
    private static final String MAPPINGS_RESOURCE = "mappingsResource";
    private static final String STARTING_INDEX = "startingIndex";

    @Override
    protected void doCopy(RequestContext requestContext, String resourcePath, String newPath) throws RegistryException {
        if (requestContext.getResource() instanceof Collection) {
            Registry registry = requestContext.getRegistry();
            Object content = registry.get((String)this.parameterMap.get(MAPPINGS_RESOURCE)).getContent();
            String contentString = this.getContentString(content);
            int startingIndex = Integer.parseInt((String)this.parameterMap.get(STARTING_INDEX));
            HashMap<String, String> conversions = new HashMap<String, String>();
            for (String mapping : contentString.split("\n")) {
                String[] mappings = mapping.split("\r")[0].split(",");
                conversions.put(mappings[startingIndex - 1].trim(), mappings[startingIndex].trim());
            }
            registry.put(newPath, registry.get(resourcePath));
            for (String path : ((Collection)requestContext.getResource()).getChildren()) {
                String temp = "/" + RegistryUtils.getResourceName((String)path);
                Resource resource = registry.get(resourcePath + temp);
                String string = this.getContentString(resource.getContent());
                for (Map.Entry e : conversions.entrySet()) {
                    string = string.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
                }
                resource.setContent((Object)string);
                registry.put(newPath + temp, resource);
            }
        }
    }

    private String getContentString(Object content) throws RegistryException {
        String contentString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
        return contentString;
    }
}

