/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.apistore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class ApiStoreExecutor
implements Execution {
    Log log = LogFactory.getLog(ApiStoreExecutor.class);
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;
    private String defaultTier = "Unlimited";
    private String apiThrottlingTier = "Unlimited,Unlimited,Unlimited,Unlimited,Unlimited";
    private Map parameterMap = new HashMap();

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        this.parameterMap = parameterMap;
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
            if (secretResolver.isInitialized()) {
                this.apimUsername = secretResolver.isTokenProtected("apim.username") ? secretResolver.resolve("apim.username") : MiscellaneousUtil.resolve((String)this.apimUsername, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
            if (secretResolver.isInitialized()) {
                this.apimPassword = secretResolver.isTokenProtected("apim.password") ? secretResolver.resolve("apim.password") : MiscellaneousUtil.resolve((String)this.apimPassword, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("default.tier") != null) {
            this.defaultTier = parameterMap.get("default.tier").toString();
        }
        if (parameterMap.get("throttlingTier") != null) {
            this.apiThrottlingTier = parameterMap.get("throttlingTier").toString();
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        Resource resource = context.getResource();
        try {
            String artifactString = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
            OMElement xmlContent = AXIOMUtil.stringToOM((String)artifactString);
            String serviceName = CommonUtil.getServiceName((OMElement)xmlContent);
            ServiceManager serviceManager = new ServiceManager((Registry)RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId()));
            Service service = serviceManager.getService(context.getResource().getUUID());
            this.publishDataToAPIM(service, serviceName);
        }
        catch (RegistryException e) {
            this.log.error((Object)"Failed to publish service to API store ", (Throwable)e);
            return false;
        }
        catch (XMLStreamException e) {
            this.log.error((Object)"Failed to convert service to xml content");
            return false;
        }
        return true;
    }

    private void publishDataToAPIM(Service service, String serviceName) {
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null) {
            String msg = "APIManager endpoint URL or credentials are not defined";
            this.log.error((Object)msg);
            throw new RuntimeException(msg + "API Publish might fail");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        this.authenticateAPIM((HttpContext)httpContext);
        String addAPIendpoint = this.apimEndpoint + "publisher/site/blocks/item-add/ajax/add.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(addAPIendpoint);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (service.getAttachedEndpoints().length == 0) {
                String msg = "Service Endpoint is a must attribute to create an API definition at the APIStore.Publishing at gateway might fail";
                this.log.warn((Object)msg);
            }
            if (service.getAttachedEndpoints().length > 0) {
                params.add(new BasicNameValuePair("endpoint", service.getAttachedEndpoints()[0].getUrl()));
            }
            params.add(new BasicNameValuePair("action", "addAPI"));
            params.add(new BasicNameValuePair("name", serviceName));
            params.add(new BasicNameValuePair("context", serviceName));
            params.add(new BasicNameValuePair("version", service.getAttribute("overview_version")));
            params.add(new BasicNameValuePair("API_PROVIDER", CarbonContext.getThreadLocalCarbonContext().getUsername()));
            params.add(new BasicNameValuePair("tiersCollection", this.defaultTier));
            params.add(new BasicNameValuePair("uriTemplate-0", "/*"));
            params.add(new BasicNameValuePair("resourceMethod-0", "POST"));
            params.add(new BasicNameValuePair("resourceMethodAuthType-0", "Any"));
            params.add(new BasicNameValuePair("visibility", "public"));
            params.add(new BasicNameValuePair("resourceMethodThrottlingTier-0", this.apiThrottlingTier));
            for (int i = 0; i < service.getAttachedWsdls().length; ++i) {
                String wsdlPath = service.getAttachedWsdls()[0].getPath();
                if (wsdlPath == null || !wsdlPath.toLowerCase().startsWith("http")) continue;
                params.add(new BasicNameValuePair("wsdl", wsdlPath));
            }
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, (HttpContext)httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error in updating APIM DB", (Throwable)e);
        }
    }

    private void authenticateAPIM(HttpContext httpContext) {
        String loginEP = this.apimEndpoint + "publisher/site/blocks/user/login/ajax/login.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(loginEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
            params.add(new BasicNameValuePair("action", "login"));
            params.add(new BasicNameValuePair("username", this.apimUsername));
            params.add(new BasicNameValuePair("password", this.apimPassword));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(" Authentication with APIM failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Authentication with APIM fails", (Throwable)e);
        }
    }

    private void updateStatus(Service service, String serviceName, HttpContext httpContext) {
        String lifeCycleEP = this.apimEndpoint + "publisher/site/blocks/life-cycles/ajax/life-cycles.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(lifeCycleEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(6);
            params.add(new BasicNameValuePair("action", "updateStatus"));
            params.add(new BasicNameValuePair("name", serviceName));
            params.add(new BasicNameValuePair("version", service.getAttribute("overview_version")));
            params.add(new BasicNameValuePair("provider", CarbonContext.getThreadLocalCarbonContext().getUsername()));
            params.add(new BasicNameValuePair("status", "CREATED"));
            params.add(new BasicNameValuePair("publishToGateway", "false"));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("PublishedAPI status update failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"PublishedAPI status update failed", (Throwable)e);
        }
    }
}

