/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers.utils;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ResourceProcessor {
    private Registry registry;
    private String wadlPath;

    public ResourceProcessor(Registry registry, String wadlPath) {
        this.registry = registry;
        this.wadlPath = wadlPath;
    }

    public void saveResources(OMElement resourcesElement, String basePath) throws JaxenException, RegistryException {
        Iterator resources = resourcesElement.getChildrenWithLocalName("resource");
        while (resources.hasNext()) {
            String resourcePath = "/_system/governance" + this.addResource((OMElement)resources.next(), basePath);
            if (resourcePath == null) continue;
            this.addDependency(this.wadlPath, resourcePath);
        }
    }

    public String addResource(OMElement resourceElement, String basePath) throws JaxenException, RegistryException {
        String path = resourceElement.getAttribute(new QName("path")).getAttributeValue();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        UserRegistry governanceSystemRegistry = RegistryCoreServiceComponent.getRegistryService().getGovernanceSystemRegistry();
        GenericArtifactManager genericArtifactManager = new GenericArtifactManager((Registry)governanceSystemRegistry, "wadlresource");
        if (path.matches("^\\{([^~!@#;%^*+=\\{\\}\\(\\)\\|\\\\<>;,]+)\\}$")) {
            path = path.replaceAll("\\{(.*)\\}$", "$1");
            path = "exp-" + path;
        } else if (!path.matches("[^~!@#;%^*+=\\{\\}\\(\\)\\|\\\\<>;,]+")) {
            throw new RegistryException("Invalid resource: " + path);
        }
        GenericArtifact resourceArtifact = genericArtifactManager.newGovernanceArtifact(new QName(path));
        resourceArtifact.addAttribute("overview_name", path);
        resourceArtifact.addAttribute("overview_base", basePath);
        Iterator methods = resourceElement.getChildrenWithLocalName("method");
        while (methods.hasNext()) {
            OMElement method = (OMElement)methods.next();
            if (method.getAttribute(new QName("name")) == null || method.getAttribute(new QName("id")) == null) continue;
            resourceArtifact.addAttribute("methods_entry", method.getAttribute(new QName("name")).getAttributeValue() + ":" + method.getAttribute(new QName("id")).getAttributeValue());
        }
        genericArtifactManager.addGenericArtifact(resourceArtifact);
        this.saveResources(resourceElement, basePath + path);
        return resourceArtifact.getPath();
    }

    private void addDependency(String source, String target) throws RegistryException {
        this.registry.addAssociation(source, target, "depends");
        this.registry.addAssociation(target, source, "usedBy");
    }
}

