/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators;

import java.util.Collections;
import java.util.Map;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.validators.AttributeExistenceValidator;

public class AttributeValueCountValidator
extends AttributeExistenceValidator
implements CustomValidations {
    private int count = 0;
    private String expression = "";

    @Override
    public void init(Map parameterMap) {
        if (parameterMap != null) {
            this.count = Integer.parseInt((String)parameterMap.get("count"));
            this.expression = (String)parameterMap.get("expression");
            super.init(Collections.singletonMap("attributes", (String)parameterMap.get("attribute")));
        }
    }

    @Override
    protected boolean validateAttribute(GovernanceArtifact governanceArtifact, String attribute) throws GovernanceException {
        String[] values = governanceArtifact.getAttributes(attribute);
        if (values == null) {
            return false;
        }
        if (this.expression.equals(">")) {
            return values.length > this.count;
        }
        if (this.expression.equals("<")) {
            return values.length < this.count;
        }
        if (this.expression.equals("==")) {
            return values.length == this.count;
        }
        if (this.expression.equals("!=")) {
            return values.length != this.count;
        }
        if (this.expression.equals(">=")) {
            return values.length >= this.count;
        }
        if (this.expression.equals("<=")) {
            return values.length >= this.count;
        }
        return false;
    }
}

