/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.ui.clients;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.activation.DataHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.stub.ResourceAdminServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ResourceServiceClient {
    private static final Log log = LogFactory.getLog(ResourceServiceClient.class);
    private ResourceAdminServiceStub stub;
    private String epr;
    private String BASE_PATH = "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "registryextensions";

    public ResourceServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ResourceServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ResourceServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public void addExtension(String name, DataHandler content) throws Exception {
        try {
            Options options = this.stub._getServiceClient().getOptions();
            options.setProperty("enableMTOM", (Object)"true");
            options.setTimeOutInMilliSeconds(300000L);
            this.stub.addExtension(name, content);
        }
        catch (Exception e) {
            String msg = "Failed to add extension.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] listExtensions() throws Exception {
        try {
            return this.stub.listExtensions();
        }
        catch (Exception e) {
            String msg = "Failed to list extensions.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean deleteExtension(String name) throws Exception {
        try {
            boolean isValidPath;
            name = name.trim();
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("Wrong extension name");
            }
            Path baseAbsolutePath = Paths.get(this.BASE_PATH, new String[0]).toAbsolutePath();
            Path userPath = Paths.get(name, new String[0]);
            Path resolvedPath = baseAbsolutePath.resolve(userPath).normalize();
            boolean bl = isValidPath = !baseAbsolutePath.toString().equals(resolvedPath.toString()) && resolvedPath.toString().startsWith(baseAbsolutePath.toString());
            if (!isValidPath) {
                throw new IllegalArgumentException("User path escapes the base path");
            }
            return this.stub.removeExtension(name);
        }
        catch (Exception e) {
            String msg = "Failed to remove extension.";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }
}

