/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.DelayedClassLoadingListener;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.util.PluginUtil;

public final class EventsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "listeners";
    private static final String EL_LISTENER = "listener";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_EVENT_TYPES = "eventTypes";

    public static void processExtensions(FacetedProjectFrameworkImpl framework) {
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_LISTENER)) continue;
            try {
                String className = PluginUtil.findRequiredAttribute(element, ATTR_CLASS);
                String eventTypes = element.getAttribute(ATTR_EVENT_TYPES);
                ArrayList<IFacetedProjectEvent.Type> types = new ArrayList<IFacetedProjectEvent.Type>();
                if (eventTypes != null) {
                    String[] stringArray = eventTypes.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        segment = segment.trim();
                        try {
                            String uppercased = segment.toUpperCase();
                            types.add(IFacetedProjectEvent.Type.valueOf(uppercased));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String msg = Resources.bind((String)Resources.invalidEventType, (Object)segment, (Object)pluginId);
                            FacetCorePlugin.log(msg);
                        }
                        ++n2;
                    }
                }
                IFacetedProjectEvent.Type[] typesArray = new IFacetedProjectEvent.Type[types.size()];
                types.toArray(typesArray);
                DelayedClassLoadingListener listener = new DelayedClassLoadingListener(pluginId, className);
                framework.addListener(listener, typesArray);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    public static final class Resources
    extends NLS {
        public static String invalidEventType;

        static {
            Resources.initializeMessages((String)EventsExtensionPoint.class.getName(), Resources.class);
        }
    }
}

